/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;

public final class UnsignedType
extends Enum<UnsignedType> {
    @NotNull
    private final ClassId classId;
    @NotNull
    private final Name typeName;
    @NotNull
    private final ClassId arrayClassId;
    public static final /* enum */ UnsignedType UBYTE;
    public static final /* enum */ UnsignedType USHORT;
    public static final /* enum */ UnsignedType UINT;
    public static final /* enum */ UnsignedType ULONG;
    private static final /* synthetic */ UnsignedType[] $VALUES;

    private UnsignedType(ClassId classId) {
        this.classId = classId;
        Name name = this.classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classId.shortClassName");
        this.typeName = name;
        this.arrayClassId = new ClassId(this.classId.getPackageFqName(), Name.identifier(Intrinsics.stringPlus((String)this.typeName.asString(), (Object)"Array")));
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @NotNull
    public final Name getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final ClassId getArrayClassId() {
        return this.arrayClassId;
    }

    public static UnsignedType[] values() {
        UnsignedType[] unsignedTypeArray = $VALUES;
        UnsignedType[] unsignedTypeArray2 = new UnsignedType[unsignedTypeArray.length];
        System.arraycopy(unsignedTypeArray, 0, unsignedTypeArray2, 0, unsignedTypeArray.length);
        return unsignedTypeArray2;
    }

    public static UnsignedType valueOf(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Enum.valueOf(UnsignedType.class, value);
    }

    static {
        ClassId classId = ClassId.fromString("kotlin/UByte");
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(\"kotlin/UByte\")");
        UBYTE = new UnsignedType(classId);
        classId = ClassId.fromString("kotlin/UShort");
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(\"kotlin/UShort\")");
        USHORT = new UnsignedType(classId);
        classId = ClassId.fromString("kotlin/UInt");
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(\"kotlin/UInt\")");
        UINT = new UnsignedType(classId);
        classId = ClassId.fromString("kotlin/ULong");
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(\"kotlin/ULong\")");
        ULONG = new UnsignedType(classId);
        $VALUES = unsignedTypeArray = new UnsignedType[]{UnsignedType.UBYTE, UnsignedType.USHORT, UnsignedType.UINT, UnsignedType.ULONG};
    }
}

