/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.konan.properties.PropertiesKt;
import org.jetbrains.kotlin.library.BaseWriter;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.KotlinLibraryVersioningKt;
import org.jetbrains.kotlin.library.impl.BaseWriterImpl;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutForWriter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000bH\u0016J\u0014\u0010&\u001a\u00020#2\n\u0010'\u001a\u00060\u0017j\u0002`\u0018H\u0016J\b\u0010(\u001a\u00020#H\u0016R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/library/impl/BaseWriterImpl;", "Lorg/jetbrains/kotlin/library/BaseWriter;", "libraryLayout", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;", "moduleName", "", "_versions", "Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "builtInsPlatform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "nativeTargets", "", "nopack", "", "shortName", "(Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;Ljava/lang/String;Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;Ljava/util/List;ZLjava/lang/String;)V", "klibFile", "Lorg/jetbrains/kotlin/konan/file/File;", "getKlibFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "getLibraryLayout", "()Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;", "manifestProperties", "Ljava/util/Properties;", "Lorg/jetbrains/kotlin/konan/properties/Properties;", "getManifestProperties", "()Ljava/util/Properties;", "getNopack", "()Z", "getShortName", "()Ljava/lang/String;", "versions", "getVersions", "()Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "addLinkDependencies", "", "libraries", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "addManifestAddend", "properties", "commit", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nKotlinLibraryWriterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLibraryWriterImpl.kt\norg/jetbrains/kotlin/library/impl/BaseWriterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1#2:186\n1855#3,2:187\n*S KotlinDebug\n*F\n+ 1 KotlinLibraryWriterImpl.kt\norg/jetbrains/kotlin/library/impl/BaseWriterImpl\n*L\n67#1:187,2\n*E\n"})
public class BaseWriterImpl
implements BaseWriter {
    @NotNull
    private final KotlinLibraryLayoutForWriter libraryLayout;
    private final boolean nopack;
    @Nullable
    private final String shortName;
    @NotNull
    private final File klibFile;
    @NotNull
    private final Properties manifestProperties;
    @NotNull
    private final KotlinLibraryVersioning versions;

    public BaseWriterImpl(@NotNull KotlinLibraryLayoutForWriter libraryLayout, @NotNull String moduleName, @NotNull KotlinLibraryVersioning _versions, @NotNull BuiltInsPlatform builtInsPlatform, @NotNull List<String> nativeTargets, boolean nopack, @Nullable String shortName) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)libraryLayout, (String)"libraryLayout");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)_versions, (String)"_versions");
            Intrinsics.checkNotNullParameter((Object)((Object)builtInsPlatform), (String)"builtInsPlatform");
            Intrinsics.checkNotNullParameter(nativeTargets, (String)"nativeTargets");
            this.libraryLayout = libraryLayout;
            this.nopack = nopack;
            this.shortName = shortName;
            this.klibFile = this.libraryLayout.getLibFile().getCanonicalFile();
            this.manifestProperties = new Properties();
            this.versions = _versions;
            this.klibFile.deleteRecursively();
            File $this$_init__u24lambda_u240 = this.klibFile.getParentFile();
            boolean bl = false;
            if (!$this$_init__u24lambda_u240.getExists()) {
                $this$_init__u24lambda_u240.mkdirs();
            }
            this.libraryLayout.getResourcesDir().mkdirs();
            this.manifestProperties.setProperty("unique_name", moduleName);
            KotlinLibraryVersioningKt.writeKonanLibraryVersioning(this.manifestProperties, _versions);
            if (builtInsPlatform != BuiltInsPlatform.COMMON) {
                this.manifestProperties.setProperty("builtins_platform", builtInsPlatform.name());
                if (builtInsPlatform == BuiltInsPlatform.NATIVE) {
                    this.manifestProperties.setProperty("native_targets", CollectionsKt.joinToString$default((Iterable)nativeTargets, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
            }
            String string2 = this.shortName;
            if (string2 == null) break block3;
            String it = string2;
            boolean bl2 = false;
            this.manifestProperties.setProperty("short_name", it);
        }
    }

    public /* synthetic */ BaseWriterImpl(KotlinLibraryLayoutForWriter kotlinLibraryLayoutForWriter, String string2, KotlinLibraryVersioning kotlinLibraryVersioning, BuiltInsPlatform builtInsPlatform, List list, boolean bl, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        this(kotlinLibraryLayoutForWriter, string2, kotlinLibraryVersioning, builtInsPlatform, list, bl, string3);
    }

    @NotNull
    public final KotlinLibraryLayoutForWriter getLibraryLayout() {
        return this.libraryLayout;
    }

    public final boolean getNopack() {
        return this.nopack;
    }

    @Nullable
    public final String getShortName() {
        return this.shortName;
    }

    @NotNull
    public final File getKlibFile() {
        return this.klibFile;
    }

    @NotNull
    public final Properties getManifestProperties() {
        return this.manifestProperties;
    }

    @Override
    @NotNull
    public KotlinLibraryVersioning getVersions() {
        return this.versions;
    }

    @Override
    public void addLinkDependencies(@NotNull List<? extends KotlinLibrary> libraries) {
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        if (libraries.isEmpty()) {
            this.manifestProperties.remove("depends");
            return;
        }
        String newValue2 = CollectionsKt.joinToString$default((Iterable)libraries, (CharSequence)" ", null, null, (int)0, null, (Function1)addLinkDependencies.newValue.1.INSTANCE, (int)30, null);
        this.manifestProperties.setProperty("depends", newValue2);
        Iterable $this$forEach$iv = libraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinLibrary it = (KotlinLibrary)element$iv;
            boolean bl = false;
            if (it.getVersions().getLibraryVersion() == null) continue;
            this.manifestProperties.setProperty("dependency_version_" + KotlinLibraryKt.getUniqueName(it), it.getVersions().getLibraryVersion());
        }
    }

    @Override
    public void addManifestAddend(@NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.manifestProperties.putAll((Map<?, ?>)properties);
    }

    @Override
    public void commit() {
        PropertiesKt.saveToFile((Properties)this.manifestProperties, (File)this.libraryLayout.getManifestFile());
        if (!this.nopack) {
            ZipUtilKt.zipDirAs((File)this.libraryLayout.getUnzippedDir(), (File)this.klibFile);
            this.libraryLayout.getUnzippedDir().deleteRecursively();
        }
    }
}

