/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.MBeanServerNotificationFilter;
import org.jolokia.backend.executor.AbstractMBeanServerExecutor;
import org.jolokia.detector.ServerDetector;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.request.JmxRequest;
import org.jolokia.util.ServersInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerExecutorLocal
extends AbstractMBeanServerExecutor
implements NotificationListener {
    private MBeanServer jolokiaMBeanServer;
    private Set<MBeanServerConnection> mBeanServers;
    private Set<MBeanServerConnection> allMBeanServers;

    public MBeanServerExecutorLocal(List<ServerDetector> pDetectors) {
        this.init(pDetectors);
    }

    public MBeanServerExecutorLocal() {
        this(Collections.emptyList());
    }

    private synchronized void init(List<ServerDetector> pDetectors) {
        this.mBeanServers = new LinkedHashSet<MBeanServerConnection>();
        this.jolokiaMBeanServer = this.lookupJolokiaMBeanServer();
        for (ServerDetector detector : pDetectors) {
            detector.addMBeanServers(this.mBeanServers);
        }
        ArrayList<MBeanServer> beanServers = MBeanServerFactory.findMBeanServer(null);
        if (beanServers != null) {
            this.mBeanServers.addAll(beanServers);
        }
        this.mBeanServers.add(ManagementFactory.getPlatformMBeanServer());
        this.allMBeanServers = new LinkedHashSet<MBeanServerConnection>();
        if (this.jolokiaMBeanServer != null) {
            this.allMBeanServers.add(this.jolokiaMBeanServer);
        }
        this.allMBeanServers.addAll(this.mBeanServers);
    }

    public Object handleRequest(JsonRequestHandler pRequestHandler, JmxRequest pJmxReq) throws MBeanException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException {
        AttributeNotFoundException attrException = null;
        InstanceNotFoundException objNotFoundException = null;
        for (MBeanServerConnection conn : this.getMBeanServers()) {
            try {
                return pRequestHandler.handleRequest(conn, pJmxReq);
            }
            catch (InstanceNotFoundException exp) {
                objNotFoundException = exp;
            }
            catch (AttributeNotFoundException exp) {
                attrException = exp;
            }
            catch (IOException exp) {
                throw new IllegalStateException("I/O Error while dispatching", exp);
            }
        }
        if (attrException != null) {
            throw attrException;
        }
        throw objNotFoundException;
    }

    @Override
    protected Set<MBeanServerConnection> getMBeanServers() {
        return this.allMBeanServers;
    }

    @Override
    protected MBeanServerConnection getJolokiaMBeanServer() {
        return this.jolokiaMBeanServer;
    }

    private MBeanServer lookupJolokiaMBeanServer() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName holderMBeanName = null;
        try {
            holderMBeanName = new ObjectName("jolokia:type=MBeanServer");
            return (MBeanServer)server.getAttribute(holderMBeanName, "JolokiaMBeanServer");
        }
        catch (InstanceNotFoundException exp) {
            MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
            filter.enableObjectName(holderMBeanName);
            try {
                server.addNotificationListener(this.getMBeanServerDelegateName(), this, (NotificationFilter)filter, null);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException("Internal: Cannot lookup " + this.getMBeanServerDelegateName() + ": " + e, e);
            }
            catch (NoSuchFieldError error) {
                // empty catch block
            }
            return null;
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal: Cannot get Jolokia MBeanServer via JMX lookup: " + e, e);
        }
    }

    @Override
    public synchronized void handleNotification(Notification notification, Object handback) {
        if ("JMX.mbean.registered".equals(notification.getType())) {
            this.jolokiaMBeanServer = this.lookupJolokiaMBeanServer();
        } else if ("JMX.mbean.unregistered".equals(notification.getType())) {
            this.jolokiaMBeanServer = null;
        }
        this.allMBeanServers.clear();
        this.allMBeanServers.add(this.jolokiaMBeanServer);
        this.allMBeanServers.addAll(this.mBeanServers);
    }

    public void destroy() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            server.removeNotificationListener(this.getMBeanServerDelegateName(), this);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Internal: Cannot lookup " + MBeanServerDelegate.DELEGATE_NAME + ": " + e, e);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    public String getServersInfo() {
        return ServersInfo.dump(this.allMBeanServers);
    }

    private ObjectName getMBeanServerDelegateName() {
        try {
            return MBeanServerDelegate.DELEGATE_NAME;
        }
        catch (NoSuchFieldError error) {
            try {
                return new ObjectName("JMImplementation:type=MBeanServerDelegate");
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Internal: Server delegate object name could not be created", e);
            }
        }
    }
}

