/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.Authenticator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.jvmagent.UserPasswordAuthenticator;
import org.jolokia.util.NetworkUtil;

public class JolokiaServerConfig {
    private Configuration jolokiaConfig;
    private String protocol;
    private int port;
    private int backlog;
    private InetAddress address;
    private String executor;
    private int threadNr;
    private String keystore;
    private String context;
    private boolean useSslClientAuthentication;
    private char[] keystorePassword;
    private Authenticator authenticator;

    public JolokiaServerConfig(Map<String, String> pConfig) {
        this.init(pConfig);
    }

    protected void init(Map<String, String> pConfig) {
        Map<String, String> finalCfg = this.getDefaultConfig(pConfig);
        finalCfg.putAll(pConfig);
        this.prepareDetectorOptions(finalCfg);
        this.addJolokiaId(finalCfg);
        this.jolokiaConfig = new Configuration(new Object[0]);
        this.jolokiaConfig.updateGlobalConfiguration(finalCfg);
        this.initConfigAndValidate(finalCfg);
    }

    private void addJolokiaId(Map<String, String> pFinalCfg) {
        if (!pFinalCfg.containsKey(ConfigKey.AGENT_ID.getKeyValue())) {
            pFinalCfg.put(ConfigKey.AGENT_ID.getKeyValue(), NetworkUtil.getAgentId((int)this.hashCode(), (String)"jvm"));
        }
        pFinalCfg.put(ConfigKey.AGENT_TYPE.getKeyValue(), "jvm");
    }

    protected Map<String, String> getDefaultConfig(Map<String, String> pConfig) {
        InputStream is = this.getClass().getResourceAsStream("/default-jolokia-agent.properties");
        return this.readPropertiesFromInputStream(is, "default-jolokia-agent.properties");
    }

    public Configuration getJolokiaConfig() {
        return this.jolokiaConfig;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public String getContextPath() {
        return this.context;
    }

    public String getExecutor() {
        return this.executor;
    }

    public int getThreadNr() {
        return this.threadNr;
    }

    public boolean useSslClientAuthentication() {
        return this.useSslClientAuthentication;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    protected void initConfigAndValidate(Map<String, String> agentConfig) {
        this.initContext();
        this.initAuthenticator();
        this.initProtocol(agentConfig);
        this.initAddress(agentConfig);
        this.port = Integer.parseInt(agentConfig.get("port"));
        this.backlog = Integer.parseInt(agentConfig.get("backlog"));
        this.initExecutor(agentConfig);
        this.initThreadNr(agentConfig);
        this.initKeystore(agentConfig);
        String auth = agentConfig.get("useSslClientAuthentication");
        this.useSslClientAuthentication = auth != null && Boolean.getBoolean(auth);
        String password = agentConfig.get("keystorePassword");
        this.keystorePassword = password != null ? password.toCharArray() : new char[]{};
    }

    private void initAuthenticator() {
        this.initCustomAuthenticator();
        if (this.authenticator == null) {
            this.initDefaultAuthenticator();
        }
    }

    private void initCustomAuthenticator() {
        String authenticatorClass = this.jolokiaConfig.get(ConfigKey.AUTHENTICATOR_CLASS);
        if (authenticatorClass != null) {
            try {
                Class<?> authClass = Class.forName(authenticatorClass);
                if (!Authenticator.class.isAssignableFrom(authClass)) {
                    throw new IllegalArgumentException("Provided authenticator class [" + authenticatorClass + "] is not a subclass of Authenticator");
                }
                this.lookupAuthenticator(authClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find authenticator class", e);
            }
        }
    }

    private void lookupAuthenticator(Class pAuthClass) {
        try {
            try {
                Constructor constructorThatTakesConfiguration = pAuthClass.getConstructor(Configuration.class);
                this.authenticator = (Authenticator)constructorThatTakesConfiguration.newInstance(this.jolokiaConfig);
            }
            catch (NoSuchMethodException ignore) {
                this.authenticator = this.lookupAuthenticatorWithDefaultConstructor(pAuthClass, ignore);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot create an instance of custom authenticator class with configuration", e);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class", e);
        }
    }

    private Authenticator lookupAuthenticatorWithDefaultConstructor(Class pAuthClass, NoSuchMethodException ignore) throws InstantiationException, IllegalAccessException {
        try {
            Constructor defaultConstructor = pAuthClass.getConstructor(new Class[0]);
            return (Authenticator)defaultConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class, no default constructor to use", e);
        }
        catch (InvocationTargetException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator using default constructor", e);
        }
    }

    private void initDefaultAuthenticator() {
        String user = this.jolokiaConfig.get(ConfigKey.USER);
        String password = this.jolokiaConfig.get(ConfigKey.PASSWORD);
        this.authenticator = user != null && password != null ? new UserPasswordAuthenticator(user, password) : null;
    }

    private void initProtocol(Map<String, String> agentConfig) {
        String string = this.protocol = agentConfig.containsKey("protocol") ? agentConfig.get("protocol") : "http";
        if (!this.protocol.equals("http") && !this.protocol.equals("https")) {
            throw new IllegalArgumentException("Invalid protocol '" + this.protocol + "'. Must be either 'http' or 'https'");
        }
    }

    private void initContext() {
        this.context = this.jolokiaConfig.get(ConfigKey.AGENT_CONTEXT);
        if (this.context == null) {
            this.context = ConfigKey.AGENT_CONTEXT.getDefaultValue();
        }
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
    }

    private void initKeystore(Map<String, String> agentConfig) {
        this.keystore = agentConfig.get("keystore");
        if (this.protocol.equals("https") && this.keystore == null) {
            throw new IllegalArgumentException("No keystore defined for HTTPS protocol. Please use the 'keystore' option to point to a valid keystore");
        }
    }

    private void initThreadNr(Map<String, String> agentConfig) {
        String threadNrS = agentConfig.get("threadNr");
        this.threadNr = threadNrS != null ? Integer.parseInt(threadNrS) : 5;
    }

    private void initExecutor(Map<String, String> agentConfig) {
        String string = this.executor = agentConfig.containsKey("executor") ? agentConfig.get("executor") : "single";
        if (!("single".equalsIgnoreCase(this.executor) || "fixed".equalsIgnoreCase(this.executor) || "cached".equalsIgnoreCase(this.executor))) {
            throw new IllegalArgumentException("Executor model can be '" + this.executor + "' but most be either 'single', 'fixed' or 'cached'");
        }
    }

    private void initAddress(Map<String, String> agentConfig) {
        String host = agentConfig.get("host");
        try {
            this.address = "*".equals(host) || "0.0.0.0".equals(host) ? null : (host != null ? InetAddress.getByName(host) : InetAddress.getByName(null));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Can not lookup " + (host != null ? host : "loopback interface") + ": " + e, e);
        }
    }

    protected Map<String, String> readPropertiesFromInputStream(InputStream pIs, String pLabel) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (pIs == null) {
            return ret;
        }
        Properties props = new Properties();
        try {
            props.load(pIs);
            ret.putAll(props);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("jolokia: Cannot load properties " + pLabel + " : " + e, e);
        }
        return ret;
    }

    protected void prepareDetectorOptions(Map<String, String> pConfig) {
        StringBuffer detectorOpts = new StringBuffer("{");
        if (pConfig.containsKey("bootAmx") && Boolean.parseBoolean(pConfig.get("bootAmx"))) {
            detectorOpts.append("\"glassfish\" : { \"bootAmx\" : true }");
        }
        if (detectorOpts.length() > 1) {
            detectorOpts.append("}");
            pConfig.put(ConfigKey.DETECTOR_OPTIONS.getKeyValue(), detectorOpts.toString());
        }
    }
}

