/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.service.discovery.AbstractDiscoveryMessage;
import org.jolokia.service.discovery.DiscoveryIncomingMessage;
import org.jolokia.service.discovery.DiscoveryOutgoingMessage;
import org.jolokia.service.discovery.MulticastUtil;

class MulticastSocketListenerThread
extends Thread {
    private final JolokiaContext context;
    private final InetAddress address;
    private boolean running;
    private MulticastSocket socket;

    MulticastSocketListenerThread(String pName, InetAddress pHostAddress, JolokiaContext pContext) throws IOException {
        super(pName);
        this.address = pHostAddress != null ? pHostAddress : NetworkUtil.getLocalAddressWithMulticast();
        this.context = pContext;
        this.socket = MulticastUtil.newMulticastSocket(this.address, pContext);
        pContext.debug(this.address + "<-- Listening for queries");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.setRunning(true);
        try {
            while (this.isRunning()) {
                this.refreshSocket();
                this.context.debug(this.address + "<-- Waiting");
                DiscoveryIncomingMessage msg = this.receiveMessage();
                if (!this.shouldMessageBeProcessed(msg)) continue;
                this.handleQuery(msg);
            }
        }
        catch (IllegalStateException e) {
            this.context.error(this.address + "<-- Cannot reopen socket, exiting listener thread: " + e.getCause(), e.getCause());
        }
        finally {
            if (this.socket != null) {
                this.socket.close();
            }
            this.context.debug(this.address + "<-- Stop listening");
        }
    }

    private synchronized void setRunning(boolean pRunning) {
        this.running = pRunning;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void shutdown() {
        this.setRunning(false);
        this.interrupt();
        this.socket.close();
    }

    private boolean shouldMessageBeProcessed(DiscoveryIncomingMessage pMsg) {
        return pMsg != null && this.context.isRemoteAccessAllowed(new String[]{pMsg.getSourceAddress().getHostAddress()}) && pMsg.isQuery();
    }

    private DiscoveryIncomingMessage receiveMessage() {
        byte[] buf = new byte[8972];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        try {
            packet.setLength(buf.length);
            this.socket.receive(packet);
            return new DiscoveryIncomingMessage(packet);
        }
        catch (IOException e) {
            if (!this.socket.isClosed()) {
                this.context.info("Error while handling discovery request" + (String)(packet.getAddress() != null ? " from " + packet.getAddress() : "") + ". Ignoring this request. --> " + e);
            }
            return null;
        }
    }

    private void refreshSocket() {
        if (this.socket.isClosed()) {
            this.context.info(this.address + "<-- Socket closed, reopening it");
            try {
                this.socket = MulticastUtil.newMulticastSocket(this.address, this.context);
            }
            catch (IOException exp) {
                this.context.error("Cannot reopen socket. Exiting multicast listener thread ...", (Throwable)exp);
                throw new SocketVerificationFailedException(exp);
            }
        }
    }

    private void handleQuery(DiscoveryIncomingMessage pMsg) {
        DiscoveryOutgoingMessage answer = new DiscoveryOutgoingMessage.Builder(AbstractDiscoveryMessage.MessageType.RESPONSE).respondTo(pMsg).agentDetails(this.context.getAgentDetails()).build();
        this.context.debug(this.address + "<-- Discovery request from " + pMsg.getSourceAddress() + ":" + pMsg.getSourcePort());
        this.send(answer);
    }

    private void send(DiscoveryOutgoingMessage pAnswer) {
        byte[] message = pAnswer.getData();
        DatagramPacket packet = new DatagramPacket(message, message.length, pAnswer.getTargetAddress(), pAnswer.getTargetPort());
        if (!this.socket.isClosed()) {
            try {
                this.socket.send(packet);
            }
            catch (IOException exp) {
                this.context.info(this.address + "<-- Can not send discovery response to " + packet.getAddress());
            }
        }
    }

    private static class SocketVerificationFailedException
    extends RuntimeException {
        public SocketVerificationFailedException(IOException e) {
            super(e);
        }
    }
}

