
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Value", namespace = "http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "value",
    "displayValue",
    "property",
    "extensions"
})
public class Value
    extends org.dmg.pmml.PMMLObject
    implements HasDisplayValue<Value> , HasExtensions<Value> , Indexable<String>
{

    @XmlAttribute(name = "value", required = true)
    @JsonProperty("value")
    private String value;
    @XmlAttribute(name = "displayValue")
    @JsonProperty("displayValue")
    private String displayValue;
    @XmlAttribute(name = "property")
    @JsonProperty("property")
    private Value.Property property;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305485L;

    public Value() {
    }

    public Value(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
    }

    @Override
    public String getKey() {
        return getValue();
    }

    public String getValue() {
        return value;
    }

    public Value setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public String getDisplayValue() {
        return displayValue;
    }

    public Value setDisplayValue(
        @org.jpmml.model.annotations.Property("displayValue")
        String displayValue) {
        this.displayValue = displayValue;
        return this;
    }

    public Value.Property getProperty() {
        if (property == null) {
            return Value.Property.VALID;
        } else {
            return property;
        }
    }

    public Value setProperty(
        @org.jpmml.model.annotations.Property("property")
        Value.Property property) {
        this.property = property;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Value addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Property
        implements StringValue<Value.Property>
    {

        @XmlEnumValue("valid")
        @JsonProperty("valid")
        VALID("valid"),
        @XmlEnumValue("invalid")
        @JsonProperty("invalid")
        INVALID("invalid"),
        @XmlEnumValue("missing")
        @JsonProperty("missing")
        MISSING("missing");
        private final String value;

        Property(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Value.Property fromValue(String v) {
            for (Value.Property c: Value.Property.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
