
package org.dmg.pmml;

import org.dmg.pmml.association.AssociationModel;
import org.dmg.pmml.association.AssociationRule;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.ItemRef;
import org.dmg.pmml.association.Itemset;
import org.dmg.pmml.baseline.Alternate;
import org.dmg.pmml.baseline.Baseline;
import org.dmg.pmml.baseline.BaselineModel;
import org.dmg.pmml.baseline.CountTable;
import org.dmg.pmml.baseline.FieldValue;
import org.dmg.pmml.baseline.FieldValueCount;
import org.dmg.pmml.baseline.TestDistributions;
import org.dmg.pmml.bayesian_network.BayesianNetworkModel;
import org.dmg.pmml.bayesian_network.BayesianNetworkNodes;
import org.dmg.pmml.bayesian_network.ContinuousConditionalProbability;
import org.dmg.pmml.bayesian_network.ContinuousNode;
import org.dmg.pmml.bayesian_network.DiscreteConditionalProbability;
import org.dmg.pmml.bayesian_network.DiscreteNode;
import org.dmg.pmml.bayesian_network.LognormalDistribution;
import org.dmg.pmml.bayesian_network.Lower;
import org.dmg.pmml.bayesian_network.Mean;
import org.dmg.pmml.bayesian_network.NormalDistribution;
import org.dmg.pmml.bayesian_network.ParentValue;
import org.dmg.pmml.bayesian_network.TriangularDistribution;
import org.dmg.pmml.bayesian_network.Upper;
import org.dmg.pmml.bayesian_network.ValueProbability;
import org.dmg.pmml.bayesian_network.Variance;
import org.dmg.pmml.clustering.CenterFields;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.clustering.Comparisons;
import org.dmg.pmml.clustering.Covariances;
import org.dmg.pmml.clustering.KohonenMap;
import org.dmg.pmml.clustering.MissingValueWeights;
import org.dmg.pmml.gaussian_process.ARDSquaredExponentialKernel;
import org.dmg.pmml.gaussian_process.AbsoluteExponentialKernel;
import org.dmg.pmml.gaussian_process.GaussianProcessModel;
import org.dmg.pmml.gaussian_process.GeneralizedExponentialKernel;
import org.dmg.pmml.gaussian_process.Lambda;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.BaselineCell;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.Categories;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.CovariateList;
import org.dmg.pmml.general_regression.EventValues;
import org.dmg.pmml.general_regression.FactorList;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PCell;
import org.dmg.pmml.general_regression.PCovCell;
import org.dmg.pmml.general_regression.PCovMatrix;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.general_regression.PPMatrix;
import org.dmg.pmml.general_regression.ParamMatrix;
import org.dmg.pmml.general_regression.Parameter;
import org.dmg.pmml.general_regression.ParameterCell;
import org.dmg.pmml.general_regression.ParameterList;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.general_regression.PredictorList;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.BayesInputs;
import org.dmg.pmml.naive_bayes.BayesOutput;
import org.dmg.pmml.naive_bayes.NaiveBayesModel;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.naive_bayes.TargetValueCount;
import org.dmg.pmml.naive_bayes.TargetValueCounts;
import org.dmg.pmml.naive_bayes.TargetValueStat;
import org.dmg.pmml.naive_bayes.TargetValueStats;
import org.dmg.pmml.nearest_neighbor.InstanceField;
import org.dmg.pmml.nearest_neighbor.InstanceFields;
import org.dmg.pmml.nearest_neighbor.KNNInput;
import org.dmg.pmml.nearest_neighbor.KNNInputs;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.dmg.pmml.nearest_neighbor.TrainingInstances;
import org.dmg.pmml.neural_network.Connection;
import org.dmg.pmml.neural_network.NeuralInput;
import org.dmg.pmml.neural_network.NeuralInputs;
import org.dmg.pmml.neural_network.NeuralLayer;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.neural_network.NeuralOutput;
import org.dmg.pmml.neural_network.NeuralOutputs;
import org.dmg.pmml.neural_network.Neuron;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.Regression;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.dmg.pmml.regression.Term;
import org.dmg.pmml.rule_set.CompoundRule;
import org.dmg.pmml.rule_set.Rule;
import org.dmg.pmml.rule_set.RuleSelectionMethod;
import org.dmg.pmml.rule_set.RuleSet;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.rule_set.SimpleRule;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.ComplexPartialScore;
import org.dmg.pmml.scorecard.Scorecard;
import org.dmg.pmml.sequence.AntecedentSequence;
import org.dmg.pmml.sequence.ConsequentSequence;
import org.dmg.pmml.sequence.Constraints;
import org.dmg.pmml.sequence.Delimiter;
import org.dmg.pmml.sequence.Sequence;
import org.dmg.pmml.sequence.SequenceModel;
import org.dmg.pmml.sequence.SequenceReference;
import org.dmg.pmml.sequence.SequenceRule;
import org.dmg.pmml.sequence.SetPredicate;
import org.dmg.pmml.sequence.SetReference;
import org.dmg.pmml.sequence.Time;
import org.dmg.pmml.support_vector_machine.Coefficient;
import org.dmg.pmml.support_vector_machine.Coefficients;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.LinearKernel;
import org.dmg.pmml.support_vector_machine.PolynomialKernel;
import org.dmg.pmml.support_vector_machine.SigmoidKernel;
import org.dmg.pmml.support_vector_machine.SupportVector;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.support_vector_machine.SupportVectors;
import org.dmg.pmml.support_vector_machine.VectorDictionary;
import org.dmg.pmml.support_vector_machine.VectorFields;
import org.dmg.pmml.support_vector_machine.VectorInstance;
import org.dmg.pmml.text.DocumentTermMatrix;
import org.dmg.pmml.text.TextCorpus;
import org.dmg.pmml.text.TextDictionary;
import org.dmg.pmml.text.TextDocument;
import org.dmg.pmml.text.TextModel;
import org.dmg.pmml.text.TextModelNormalization;
import org.dmg.pmml.text.TextModelSimiliarity;
import org.dmg.pmml.time_series.ARIMA;
import org.dmg.pmml.time_series.ExponentialSmoothing;
import org.dmg.pmml.time_series.Level;
import org.dmg.pmml.time_series.SeasonalTrendDecomposition;
import org.dmg.pmml.time_series.SeasonalityExpoSmooth;
import org.dmg.pmml.time_series.SpectralAnalysis;
import org.dmg.pmml.time_series.TimeAnchor;
import org.dmg.pmml.time_series.TimeCycle;
import org.dmg.pmml.time_series.TimeException;
import org.dmg.pmml.time_series.TimeSeries;
import org.dmg.pmml.time_series.TimeSeriesAlgorithm;
import org.dmg.pmml.time_series.TimeSeriesModel;
import org.dmg.pmml.time_series.TimeValue;
import org.dmg.pmml.time_series.TrendExpoSmooth;
import org.dmg.pmml.tree.ComplexNode;
import org.dmg.pmml.tree.DecisionTree;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;

public interface Visitor
    extends VisitContext
{


    /**
     * @see Visitable#accept(Visitor)
     * 
     */
    public void applyTo(Visitable visitable);

    public VisitorAction visit(Cell cell);

    public VisitorAction visit(ComparisonField<?> comparisonField);

    public VisitorAction visit(org.dmg.pmml.ContinuousDistribution continuousDistribution);

    public VisitorAction visit(DiscreteDistribution discreteDistribution);

    public VisitorAction visit(Distance distance);

    public VisitorAction visit(Distribution distribution);

    public VisitorAction visit(EmbeddedModel embeddedModel);

    public VisitorAction visit(Entity entity);

    public VisitorAction visit(Expression expression);

    public VisitorAction visit(Field<?> field);

    public VisitorAction visit(Kernel kernel);

    public VisitorAction visit(Measure measure);

    public VisitorAction visit(Model model);

    public VisitorAction visit(Node node);

    public VisitorAction visit(ParameterCell parameterCell);

    public VisitorAction visit(Predicate predicate);

    public VisitorAction visit(PredictorList predictorList);

    public VisitorAction visit(Rule rule);

    public VisitorAction visit(Similarity similarity);

    public VisitorAction visit(SparseArray<?> sparseArray);

    public VisitorAction visit(Term term);

    public VisitorAction visit(TimeSeriesAlgorithm timeSeriesAlgorithm);

    public VisitorAction visit(AbsoluteExponentialKernel absoluteExponentialKernel);

    public VisitorAction visit(Aggregate aggregate);

    public VisitorAction visit(Alternate alternate);

    public VisitorAction visit(Annotation annotation);

    public VisitorAction visit(Anova anova);

    public VisitorAction visit(AnovaRow anovaRow);

    public VisitorAction visit(AntecedentSequence antecedentSequence);

    public VisitorAction visit(AnyDistribution anyDistribution);

    public VisitorAction visit(Application application);

    public VisitorAction visit(Apply apply);

    public VisitorAction visit(ARDSquaredExponentialKernel ardSquaredExponentialKernel);

    public VisitorAction visit(ARIMA arima);

    public VisitorAction visit(Array array);

    public VisitorAction visit(AssociationModel associationModel);

    public VisitorAction visit(AssociationRule associationRule);

    public VisitorAction visit(Attribute attribute);

    public VisitorAction visit(BaseCumHazardTables baseCumHazardTables);

    public VisitorAction visit(Baseline baseline);

    public VisitorAction visit(BaselineCell baselineCell);

    public VisitorAction visit(BaselineModel baselineModel);

    public VisitorAction visit(BaselineStratum baselineStratum);

    public VisitorAction visit(BayesianNetworkModel bayesianNetworkModel);

    public VisitorAction visit(BayesianNetworkNodes bayesianNetworkNodes);

    public VisitorAction visit(BayesInput bayesInput);

    public VisitorAction visit(BayesInputs bayesInputs);

    public VisitorAction visit(BayesOutput bayesOutput);

    public VisitorAction visit(BinarySimilarity binarySimilarity);

    public VisitorAction visit(BlockIndicator blockIndicator);

    public VisitorAction visit(BoundaryValueMeans boundaryValueMeans);

    public VisitorAction visit(BoundaryValues boundaryValues);

    public VisitorAction visit(CategoricalPredictor categoricalPredictor);

    public VisitorAction visit(Categories categories);

    public VisitorAction visit(Category category);

    public VisitorAction visit(CenterFields centerFields);

    public VisitorAction visit(Characteristic characteristic);

    public VisitorAction visit(Characteristics characteristics);

    public VisitorAction visit(Chebychev chebychev);

    public VisitorAction visit(ChildParent childParent);

    public VisitorAction visit(CityBlock cityBlock);

    public VisitorAction visit(ClassLabels classLabels);

    public VisitorAction visit(Cluster cluster);

    public VisitorAction visit(ClusteringField clusteringField);

    public VisitorAction visit(ClusteringModel clusteringModel);

    public VisitorAction visit(ClusteringModelQuality clusteringModelQuality);

    public VisitorAction visit(Coefficient coefficient);

    public VisitorAction visit(Coefficients coefficients);

    public VisitorAction visit(ComparisonMeasure comparisonMeasure);

    public VisitorAction visit(Comparisons comparisons);

    public VisitorAction visit(ComplexNode complexNode);

    public VisitorAction visit(ComplexPartialScore complexPartialScore);

    public VisitorAction visit(CompoundPredicate compoundPredicate);

    public VisitorAction visit(CompoundRule compoundRule);

    public VisitorAction visit(ConfusionMatrix confusionMatrix);

    public VisitorAction visit(Connection connection);

    public VisitorAction visit(ConsequentSequence consequentSequence);

    public VisitorAction visit(Constant constant);

    public VisitorAction visit(Constraints constraints);

    public VisitorAction visit(ContinuousConditionalProbability continuousConditionalProbability);

    public VisitorAction visit(org.dmg.pmml.bayesian_network.ContinuousDistribution continuousDistribution);

    public VisitorAction visit(ContinuousNode continuousNode);

    public VisitorAction visit(ContStats contStats);

    public VisitorAction visit(CorrelationFields correlationFields);

    public VisitorAction visit(CorrelationMethods correlationMethods);

    public VisitorAction visit(Correlations correlations);

    public VisitorAction visit(CorrelationValues correlationValues);

    public VisitorAction visit(Counts counts);

    public VisitorAction visit(CountTable countTable);

    public VisitorAction visit(Covariances covariances);

    public VisitorAction visit(CovariateList covariateList);

    public VisitorAction visit(DataDictionary dataDictionary);

    public VisitorAction visit(DataField dataField);

    public VisitorAction visit(Decision decision);

    public VisitorAction visit(Decisions decisions);

    public VisitorAction visit(DecisionTree decisionTree);

    public VisitorAction visit(DefineFunction defineFunction);

    public VisitorAction visit(Delimiter delimiter);

    public VisitorAction visit(DerivedField derivedField);

    public VisitorAction visit(DiscreteConditionalProbability discreteConditionalProbability);

    public VisitorAction visit(DiscreteNode discreteNode);

    public VisitorAction visit(Discretize discretize);

    public VisitorAction visit(DiscretizeBin discretizeBin);

    public VisitorAction visit(DiscrStats discrStats);

    public VisitorAction visit(DocumentTermMatrix documentTermMatrix);

    public VisitorAction visit(Euclidean euclidean);

    public VisitorAction visit(EventValues eventValues);

    public VisitorAction visit(ExponentialSmoothing exponentialSmoothing);

    public VisitorAction visit(Extension extension);

    public VisitorAction visit(FactorList factorList);

    public VisitorAction visit(False _false);

    public VisitorAction visit(FieldColumnPair fieldColumnPair);

    public VisitorAction visit(FieldRef fieldRef);

    public VisitorAction visit(FieldValue fieldValue);

    public VisitorAction visit(FieldValueCount fieldValueCount);

    public VisitorAction visit(GaussianDistribution gaussianDistribution);

    public VisitorAction visit(GaussianProcessModel gaussianProcessModel);

    public VisitorAction visit(GeneralizedExponentialKernel generalizedExponentialKernel);

    public VisitorAction visit(GeneralRegressionModel generalRegressionModel);

    public VisitorAction visit(Header header);

    public VisitorAction visit(InlineTable inlineTable);

    public VisitorAction visit(InstanceField instanceField);

    public VisitorAction visit(InstanceFields instanceFields);

    public VisitorAction visit(Interval interval);

    public VisitorAction visit(IntSparseArray intSparseArray);

    public VisitorAction visit(Item item);

    public VisitorAction visit(ItemRef itemRef);

    public VisitorAction visit(Itemset itemset);

    public VisitorAction visit(Jaccard jaccard);

    public VisitorAction visit(KNNInput knnInput);

    public VisitorAction visit(KNNInputs knnInputs);

    public VisitorAction visit(KohonenMap kohonenMap);

    public VisitorAction visit(Lag lag);

    public VisitorAction visit(Lambda lambda);

    public VisitorAction visit(Level level);

    public VisitorAction visit(LiftData liftData);

    public VisitorAction visit(LiftGraph liftGraph);

    public VisitorAction visit(LinearKernel linearKernel);

    public VisitorAction visit(LinearNorm linearNorm);

    public VisitorAction visit(LocalTransformations localTransformations);

    public VisitorAction visit(LognormalDistribution lognormalDistribution);

    public VisitorAction visit(Lower lower);

    public VisitorAction visit(MapValues mapValues);

    public VisitorAction visit(MatCell matCell);

    public VisitorAction visit(Matrix matrix);

    public VisitorAction visit(Mean mean);

    public VisitorAction visit(MiningBuildTask miningBuildTask);

    public VisitorAction visit(MiningField miningField);

    public VisitorAction visit(MiningModel miningModel);

    public VisitorAction visit(MiningSchema miningSchema);

    public VisitorAction visit(Minkowski minkowski);

    public VisitorAction visit(MissingValueWeights missingValueWeights);

    public VisitorAction visit(ModelExplanation modelExplanation);

    public VisitorAction visit(ModelLiftGraph modelLiftGraph);

    public VisitorAction visit(ModelStats modelStats);

    public VisitorAction visit(ModelVerification modelVerification);

    public VisitorAction visit(MultivariateStat multivariateStat);

    public VisitorAction visit(MultivariateStats multivariateStats);

    public VisitorAction visit(NaiveBayesModel naiveBayesModel);

    public VisitorAction visit(NearestNeighborModel nearestNeighborModel);

    public VisitorAction visit(NeuralInput neuralInput);

    public VisitorAction visit(NeuralInputs neuralInputs);

    public VisitorAction visit(NeuralLayer neuralLayer);

    public VisitorAction visit(NeuralNetwork neuralNetwork);

    public VisitorAction visit(NeuralOutput neuralOutput);

    public VisitorAction visit(NeuralOutputs neuralOutputs);

    public VisitorAction visit(Neuron neuron);

    public VisitorAction visit(NormalDistribution normalDistribution);

    public VisitorAction visit(NormContinuous normContinuous);

    public VisitorAction visit(NormDiscrete normDiscrete);

    public VisitorAction visit(NumericInfo numericInfo);

    public VisitorAction visit(NumericPredictor numericPredictor);

    public VisitorAction visit(OptimumLiftGraph optimumLiftGraph);

    public VisitorAction visit(Output output);

    public VisitorAction visit(OutputField outputField);

    public VisitorAction visit(PairCounts pairCounts);

    public VisitorAction visit(Parameter parameter);

    public VisitorAction visit(ParameterField parameterField);

    public VisitorAction visit(ParameterList parameterList);

    public VisitorAction visit(ParamMatrix paramMatrix);

    public VisitorAction visit(ParentValue parentValue);

    public VisitorAction visit(Partition partition);

    public VisitorAction visit(PartitionFieldStats partitionFieldStats);

    public VisitorAction visit(PCell pCell);

    public VisitorAction visit(PCovCell pCovCell);

    public VisitorAction visit(PCovMatrix pCovMatrix);

    public VisitorAction visit(PMML pmml);

    public VisitorAction visit(PoissonDistribution poissonDistribution);

    public VisitorAction visit(PolynomialKernel polynomialKernel);

    public VisitorAction visit(PPCell ppCell);

    public VisitorAction visit(PPMatrix ppMatrix);

    public VisitorAction visit(PredictiveModelQuality predictiveModelQuality);

    public VisitorAction visit(Predictor predictor);

    public VisitorAction visit(PredictorTerm predictorTerm);

    public VisitorAction visit(Quantile quantile);

    public VisitorAction visit(org.dmg.pmml.gaussian_process.RadialBasisKernel radialBasisKernel);

    public VisitorAction visit(org.dmg.pmml.support_vector_machine.RadialBasisKernel radialBasisKernel);

    public VisitorAction visit(RandomLiftGraph randomLiftGraph);

    public VisitorAction visit(RealSparseArray realSparseArray);

    public VisitorAction visit(Regression regression);

    public VisitorAction visit(RegressionModel regressionModel);

    public VisitorAction visit(RegressionTable regressionTable);

    public VisitorAction visit(ResultField resultField);

    public VisitorAction visit(ROC roc);

    public VisitorAction visit(ROCGraph rocGraph);

    public VisitorAction visit(Row row);

    public VisitorAction visit(RuleSelectionMethod ruleSelectionMethod);

    public VisitorAction visit(RuleSet ruleSet);

    public VisitorAction visit(RuleSetModel ruleSetModel);

    public VisitorAction visit(Scorecard scorecard);

    public VisitorAction visit(ScoreDistribution scoreDistribution);

    public VisitorAction visit(SeasonalityExpoSmooth seasonalityExpoSmooth);

    public VisitorAction visit(SeasonalTrendDecomposition seasonalTrendDecomposition);

    public VisitorAction visit(Segment segment);

    public VisitorAction visit(Segmentation segmentation);

    public VisitorAction visit(Sequence sequence);

    public VisitorAction visit(SequenceModel sequenceModel);

    public VisitorAction visit(SequenceReference sequenceReference);

    public VisitorAction visit(SequenceRule sequenceRule);

    public VisitorAction visit(SetPredicate setPredicate);

    public VisitorAction visit(SetReference setReference);

    public VisitorAction visit(SigmoidKernel sigmoidKernel);

    public VisitorAction visit(SimpleMatching simpleMatching);

    public VisitorAction visit(SimplePredicate simplePredicate);

    public VisitorAction visit(SimpleRule simpleRule);

    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate);

    public VisitorAction visit(SpectralAnalysis spectralAnalysis);

    public VisitorAction visit(SquaredEuclidean squaredEuclidean);

    public VisitorAction visit(SupportVector supportVector);

    public VisitorAction visit(SupportVectorMachine supportVectorMachine);

    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel);

    public VisitorAction visit(SupportVectors supportVectors);

    public VisitorAction visit(TableLocator tableLocator);

    public VisitorAction visit(Tanimoto tanimoto);

    public VisitorAction visit(Target target);

    public VisitorAction visit(Targets targets);

    public VisitorAction visit(TargetValue targetValue);

    public VisitorAction visit(TargetValueCount targetValueCount);

    public VisitorAction visit(TargetValueCounts targetValueCounts);

    public VisitorAction visit(TargetValueStat targetValueStat);

    public VisitorAction visit(TargetValueStats targetValueStats);

    public VisitorAction visit(Taxonomy taxonomy);

    public VisitorAction visit(TestDistributions testDistributions);

    public VisitorAction visit(TextCorpus textCorpus);

    public VisitorAction visit(TextDictionary textDictionary);

    public VisitorAction visit(TextDocument textDocument);

    public VisitorAction visit(TextIndex textIndex);

    public VisitorAction visit(TextIndexNormalization textIndexNormalization);

    public VisitorAction visit(TextModel textModel);

    public VisitorAction visit(TextModelNormalization textModelNormalization);

    public VisitorAction visit(TextModelSimiliarity textModelSimiliarity);

    public VisitorAction visit(Time time);

    public VisitorAction visit(TimeAnchor timeAnchor);

    public VisitorAction visit(TimeCycle timeCycle);

    public VisitorAction visit(TimeException timeException);

    public VisitorAction visit(TimeSeries timeSeries);

    public VisitorAction visit(TimeSeriesModel timeSeriesModel);

    public VisitorAction visit(Timestamp timestamp);

    public VisitorAction visit(TimeValue timeValue);

    public VisitorAction visit(TrainingInstances trainingInstances);

    public VisitorAction visit(TransformationDictionary transformationDictionary);

    public VisitorAction visit(TreeModel treeModel);

    public VisitorAction visit(TrendExpoSmooth trendExpoSmooth);

    public VisitorAction visit(TriangularDistribution triangularDistribution);

    public VisitorAction visit(True _true);

    public VisitorAction visit(org.dmg.pmml.UniformDistribution uniformDistribution);

    public VisitorAction visit(org.dmg.pmml.bayesian_network.UniformDistribution uniformDistribution);

    public VisitorAction visit(UnivariateStats univariateStats);

    public VisitorAction visit(Upper upper);

    public VisitorAction visit(Value value);

    public VisitorAction visit(ValueProbability valueProbability);

    public VisitorAction visit(Variance variance);

    public VisitorAction visit(VectorDictionary vectorDictionary);

    public VisitorAction visit(VectorFields vectorFields);

    public VisitorAction visit(VectorInstance vectorInstance);

    public VisitorAction visit(VerificationField verificationField);

    public VisitorAction visit(VerificationFields verificationFields);

    public VisitorAction visit(XCoordinates xCoordinates);

    public VisitorAction visit(YCoordinates yCoordinates);

}
