
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "parentValues",
    "valueProbabilities"
})
@XmlRootElement(name = "DiscreteConditionalProbability", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "count",
    "extensions",
    "parentValues",
    "valueProbabilities"
})
public class DiscreteConditionalProbability
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<DiscreteConditionalProbability>
{

    @XmlAttribute(name = "count")
    @JsonProperty("count")
    private Double count;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ParentValue", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("ParentValue")
    private List<ParentValue> parentValues;
    @XmlElement(name = "ValueProbability", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("ValueProbability")
    private List<ValueProbability> valueProbabilities;
    private final static long serialVersionUID = 67305485L;

    public DiscreteConditionalProbability() {
    }

    public DiscreteConditionalProbability(
        @org.jpmml.model.annotations.Property("parentValues")
        List<ParentValue> parentValues,
        @org.jpmml.model.annotations.Property("valueProbabilities")
        List<ValueProbability> valueProbabilities) {
        this.parentValues = parentValues;
        this.valueProbabilities = valueProbabilities;
    }

    public Double getCount() {
        return count;
    }

    public DiscreteConditionalProbability setCount(
        @org.jpmml.model.annotations.Property("count")
        Double count) {
        this.count = count;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DiscreteConditionalProbability addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasParentValues() {
        return ((this.parentValues!= null)&&(this.parentValues.size()> 0));
    }

    public List<ParentValue> getParentValues() {
        if (parentValues == null) {
            parentValues = new ArrayList<ParentValue>();
        }
        return this.parentValues;
    }

    public DiscreteConditionalProbability addParentValues(ParentValue... parentValues) {
        getParentValues().addAll(Arrays.asList(parentValues));
        return this;
    }

    public boolean hasValueProbabilities() {
        return ((this.valueProbabilities!= null)&&(this.valueProbabilities.size()> 0));
    }

    public List<ValueProbability> getValueProbabilities() {
        if (valueProbabilities == null) {
            valueProbabilities = new ArrayList<ValueProbability>();
        }
        return this.valueProbabilities;
    }

    public DiscreteConditionalProbability addValueProbabilities(ValueProbability... valueProbabilities) {
        getValueProbabilities().addAll(Arrays.asList(valueProbabilities));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasParentValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getParentValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasValueProbabilities()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getValueProbabilities());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
