/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NonLocalControlFlowNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class NextNode
extends Node
implements NonLocalControlFlowNode {
    private final Node valueNode;

    public NextNode(ISourcePosition position, Node valueNode) {
        super(position, valueNode.containsVariableAssignment());
        assert (valueNode != null) : "valueNode is not null";
        this.valueNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.NEXTNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitNextNode(this);
    }

    @Override
    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public boolean hasValue() {
        return this.valueNode != NilImplicitNode.NIL;
    }

    @Override
    public List<Node> childNodes() {
        return NextNode.createList(this.valueNode);
    }
}

