/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.ObjectParameterInfo;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.DataConverters;
import org.jruby.ext.ffi.jffi.NativeDataConverter;
import org.jruby.ext.ffi.jffi.NativeInvoker;
import org.jruby.ext.ffi.jffi.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JITNativeInvoker
extends NativeInvoker {
    protected static final Invoker invoker = Invoker.getInstance();
    protected final Function function;
    protected final CallContext callContext;
    protected final long functionAddress;
    protected final Signature signature;
    protected final int arity;
    protected final NativeDataConverter resultConverter;
    protected final NativeDataConverter parameterConverter0;
    protected final NativeDataConverter parameterConverter1;
    protected final NativeDataConverter parameterConverter2;
    protected final NativeDataConverter parameterConverter3;
    protected final NativeDataConverter parameterConverter4;
    protected final NativeDataConverter parameterConverter5;
    protected final ObjectParameterInfo parameterInfo0;
    protected final ObjectParameterInfo parameterInfo1;
    protected final ObjectParameterInfo parameterInfo2;
    protected final ObjectParameterInfo parameterInfo3;
    protected final ObjectParameterInfo parameterInfo4;
    protected final ObjectParameterInfo parameterInfo5;

    public JITNativeInvoker(RubyModule implementationClass, Function function, Signature signature) {
        super(implementationClass, function, signature);
        this.arity = signature.getParameterCount();
        this.function = function;
        this.callContext = function.getCallContext();
        this.functionAddress = function.getFunctionAddress();
        this.signature = signature;
        this.resultConverter = DataConverters.getResultConverter(signature.getResultType());
        this.parameterConverter0 = JITNativeInvoker.getParameterConverter(signature, 0);
        this.parameterConverter1 = JITNativeInvoker.getParameterConverter(signature, 1);
        this.parameterConverter2 = JITNativeInvoker.getParameterConverter(signature, 2);
        this.parameterConverter3 = JITNativeInvoker.getParameterConverter(signature, 3);
        this.parameterConverter4 = JITNativeInvoker.getParameterConverter(signature, 4);
        this.parameterConverter5 = JITNativeInvoker.getParameterConverter(signature, 5);
        this.parameterInfo0 = JITNativeInvoker.getParameterInfo(signature, 0);
        this.parameterInfo1 = JITNativeInvoker.getParameterInfo(signature, 1);
        this.parameterInfo2 = JITNativeInvoker.getParameterInfo(signature, 2);
        this.parameterInfo3 = JITNativeInvoker.getParameterInfo(signature, 3);
        this.parameterInfo4 = JITNativeInvoker.getParameterInfo(signature, 4);
        this.parameterInfo5 = JITNativeInvoker.getParameterInfo(signature, 5);
    }

    private static NativeDataConverter getParameterConverter(Signature signature, int i2) {
        return signature.getParameterCount() > i2 ? DataConverters.getParameterConverter(signature.getParameterType(i2), signature.getEnums()) : null;
    }

    private static ObjectParameterInfo getParameterInfo(Signature signature, int i2) {
        if (signature.getParameterCount() <= i2) {
            return null;
        }
        Type type2 = signature.getParameterType(i2);
        int flags = 0;
        NativeType nativeType = type2 instanceof MappedType ? ((MappedType)type2).getRealType().getNativeType() : type2.getNativeType();
        switch (nativeType) {
            case BUFFER_IN: 
            case STRING: 
            case TRANSIENT_STRING: {
                flags |= 5;
                break;
            }
            case BUFFER_OUT: {
                flags |= 0x12;
                break;
            }
            case POINTER: 
            case BUFFER_INOUT: {
                flags |= 0x17;
                break;
            }
            default: {
                return null;
            }
        }
        return ObjectParameterInfo.create((int)i2, (ObjectParameterInfo.ObjectType)ObjectParameterInfo.ARRAY, (ObjectParameterInfo.ComponentType)ObjectParameterInfo.BYTE, (int)flags);
    }

    Signature getSignature() {
        return this.signature;
    }

    CallContext getCallContext() {
        return this.callContext;
    }

    long getFunctionAddress() {
        return this.functionAddress;
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2) {
        throw context.runtime.newArgumentError(0, this.arity);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1) {
        throw context.runtime.newArgumentError(1, this.arity);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2) {
        throw context.runtime.newArgumentError(2, this.arity);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        throw context.runtime.newArgumentError(3, this.arity);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        throw context.runtime.newArgumentError(4, this.arity);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        throw context.runtime.newArgumentError(5, this.arity);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6) {
        throw context.runtime.newArgumentError(6, this.arity);
    }

    public final IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        if (args2.length != this.arity) {
            throw context.runtime.newArgumentError(args2.length, this.arity);
        }
        switch (args2.length) {
            case 0: {
                return this.call(context, self, clazz, name2);
            }
            case 1: {
                return this.call(context, self, clazz, name2, args2[0]);
            }
            case 2: {
                return this.call(context, self, clazz, name2, args2[0], args2[1]);
            }
            case 3: {
                return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
            }
            case 4: {
                return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], args2[3]);
            }
            case 5: {
                return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], args2[3], args2[4]);
            }
            case 6: {
                return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5]);
            }
        }
        throw context.runtime.newArgumentError("too many arguments: " + args2.length);
    }
}

