/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class HMAC
extends RubyObject {
    private static final long serialVersionUID = 7602535792884680307L;
    private static ObjectAllocator HMAC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new HMAC(runtime, klass);
        }
    };
    private Mac mac;
    private byte[] key;
    private StringBuffer data = new StringBuffer();

    public static void createHMAC(Ruby runtime, RubyModule ossl) {
        RubyClass cHMAC = ossl.defineClassUnder("HMAC", runtime.getObject(), HMAC_ALLOCATOR);
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        ossl.defineClassUnder("HMACError", openSSLError, openSSLError.getAllocator());
        cHMAC.defineAnnotatedMethods(HMAC.class);
    }

    static Mac getMac(String algoName) throws NoSuchAlgorithmException {
        try {
            return Mac.getInstance("HMAC" + algoName.replaceAll("-", ""));
        }
        catch (NoSuchAlgorithmException nsae) {
            return Mac.getInstance("HMAC-" + algoName.replaceAll("-", ""));
        }
    }

    @JRubyMethod(name={"digest"}, meta=true)
    public static IRubyObject s_digest(IRubyObject recv2, IRubyObject digest2, IRubyObject kay, IRubyObject data2) {
        String algoName = HMAC.getDigestAlgorithmName(digest2);
        try {
            Mac mac = HMAC.getMac(algoName);
            byte[] key2 = kay.convertToString().getBytes();
            SecretKeySpec keysp = new SecretKeySpec(key2, mac.getAlgorithm());
            mac.init(keysp);
            return RubyString.newString(recv2.getRuntime(), mac.doFinal(data2.convertToString().getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw recv2.getRuntime().newNotImplementedError(e.getMessage());
        }
    }

    @JRubyMethod(name={"hexdigest"}, meta=true)
    public static IRubyObject s_hexdigest(IRubyObject recv2, IRubyObject digest2, IRubyObject kay, IRubyObject data2) {
        String algoName = HMAC.getDigestAlgorithmName(digest2);
        try {
            Mac mac = HMAC.getMac(algoName);
            byte[] key2 = kay.convertToString().getBytes();
            SecretKeySpec keysp = new SecretKeySpec(key2, mac.getAlgorithm());
            mac.init(keysp);
            return RubyString.newString(recv2.getRuntime(), ByteList.plain((CharSequence)Utils.toHex(mac.doFinal(data2.convertToString().getBytes()))));
        }
        catch (Exception e) {
            throw recv2.getRuntime().newNotImplementedError(e.getMessage());
        }
    }

    public HMAC(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod
    public IRubyObject initialize(IRubyObject kay, IRubyObject digest2) {
        String algoName = HMAC.getDigestAlgorithmName(digest2);
        try {
            this.mac = HMAC.getMac(algoName);
            this.key = kay.convertToString().getBytes();
            SecretKeySpec keysp = new SecretKeySpec(this.key, this.mac.getAlgorithm());
            this.mac.init(keysp);
        }
        catch (Exception e) {
            throw this.getRuntime().newNotImplementedError(e.getMessage());
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        String name2 = ((HMAC)obj).mac.getAlgorithm();
        try {
            this.mac = Mac.getInstance(name2);
            this.key = ((HMAC)obj).key;
            SecretKeySpec keysp = new SecretKeySpec(this.key, name2);
            this.mac.init(keysp);
        }
        catch (Exception e) {
            throw this.getRuntime().newNotImplementedError("Unsupported MAC algorithm (" + name2 + ")");
        }
        this.data = new StringBuffer(((HMAC)obj).data.toString());
        return this;
    }

    @JRubyMethod(name={"update", "<<"})
    public IRubyObject update(IRubyObject obj) {
        this.data.append(obj);
        return this;
    }

    @JRubyMethod
    public IRubyObject digest() {
        this.mac.reset();
        return RubyString.newString(this.getRuntime(), this.mac.doFinal(ByteList.plain((CharSequence)this.data)));
    }

    @JRubyMethod(name={"hexdigest", "inspect", "to_s"})
    public IRubyObject hexdigest() {
        this.mac.reset();
        return RubyString.newString(this.getRuntime(), ByteList.plain((CharSequence)Utils.toHex(this.mac.doFinal(ByteList.plain((CharSequence)this.data)))));
    }

    String getAlgorithm() {
        return this.mac.getAlgorithm();
    }

    private static String getDigestAlgorithmName(IRubyObject digest2) {
        String algoName = null;
        algoName = digest2 instanceof Digest ? ((Digest)digest2).getShortAlgorithm() : digest2.asString().toString();
        return algoName;
    }
}

