/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementProblem;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.PopFrameInstr;
import org.jruby.ir.instructions.PushBindingInstr;
import org.jruby.ir.instructions.PushFrameInstr;
import org.jruby.ir.instructions.ReceiveExceptionInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.passes.CFGBuilder;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCallProtocolInstructions
extends CompilerPass {
    boolean addedInstrs = false;
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = new ArrayList<Class<? extends CompilerPass>>(){
        {
            this.add(CFGBuilder.class);
        }
    };

    @Override
    public String getLabel() {
        return "Add Call Protocol Instructions (push/pop of dyn-scope, frame, impl-class values)";
    }

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Object execute(IRScope scope, Object ... data2) {
        StoreLocalVarPlacementProblem slvpp = (StoreLocalVarPlacementProblem)scope.getDataFlowSolution("Placement of local-var stores");
        boolean scopeHasLocalVarStores = false;
        boolean scopeHasUnrescuedExceptions = false;
        CFG cfg = scope.cfg();
        BasicBlock geb = cfg.getGlobalEnsureBB();
        if (slvpp != null) {
            scopeHasLocalVarStores = slvpp.scopeHasLocalVarStores();
            scopeHasUnrescuedExceptions = slvpp.scopeHasUnrescuedExceptions();
        } else {
            scopeHasLocalVarStores = true;
            scopeHasUnrescuedExceptions = false;
            for (BasicBlock bb : cfg.getBasicBlocks()) {
                if (cfg.getRescuerBBFor(bb) != null) continue;
                scopeHasUnrescuedExceptions = true;
                break;
            }
        }
        BasicBlock entryBB = cfg.getEntryBB();
        if (scope instanceof IRMethod || scope instanceof IRScriptBody || scope instanceof IRModuleBody) {
            if (scope.bindingHasEscaped() || scope.usesBackrefOrLastline() || scopeHasLocalVarStores || scopeHasUnrescuedExceptions) {
                entryBB.addInstr(new PushFrameInstr());
                entryBB.addInstr(new PushBindingInstr(scope));
                if (geb == null && (scopeHasLocalVarStores || scopeHasUnrescuedExceptions)) {
                    TemporaryVariable exc = scope.getNewTemporaryVariable();
                    geb = new BasicBlock(cfg, new Label("_GLOBAL_ENSURE_BLOCK"));
                    geb.addInstr(new ReceiveExceptionInstr(exc, false));
                    geb.addInstr(new ThrowExceptionInstr(exc));
                    cfg.addGlobalEnsureBB(geb);
                }
                BasicBlock exitBB = cfg.getExitBB();
                for (BasicBlock bb : cfg.getBasicBlocks()) {
                    ListIterator<Instr> instrs = bb.getInstrs().listIterator();
                    while (instrs.hasNext()) {
                        Instr i2 = instrs.next();
                        if ((bb == exitBB || !(i2 instanceof ReturnBase)) && !(i2 instanceof BreakInstr)) continue;
                        instrs.previous();
                        instrs.add(new PopBindingInstr());
                        instrs.add(new PopFrameInstr());
                        break;
                    }
                    if (bb == exitBB && !bb.isEmpty()) {
                        if (instrs.hasPrevious()) {
                            instrs.previous();
                        }
                        instrs.add(new PopBindingInstr());
                        instrs.add(new PopFrameInstr());
                    }
                    if (bb != geb) continue;
                    instrs.previous();
                    instrs.add(new PopBindingInstr());
                    instrs.add(new PopFrameInstr());
                }
            }
            scope.setExplicitCallProtocolFlag(true);
        }
        for (IRClosure c : scope.getClosures()) {
            this.execute(c, new Object[0]);
        }
        this.addedInstrs = true;
        return null;
    }

    @Override
    public Object previouslyRun(IRScope scope) {
        return this.addedInstrs ? new Object() : null;
    }

    @Override
    public void invalidate(IRScope scope) {
    }
}

