/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.JVM;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.Method;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class IRBytecodeAdapter {
    public SkinnyMethodAdapter adapter;
    private int variableCount = 0;
    private Map<Integer, Type> variableTypes = new HashMap<Integer, Type>();
    private Map<Integer, String> variableNames = new HashMap<Integer, String>();
    private int arity;
    private String[] params;

    public IRBytecodeAdapter(SkinnyMethodAdapter adapter, int arity2, String ... params2) {
        this.adapter = adapter;
        this.arity = arity2;
        this.params = params2;
    }

    public void startMethod() {
        this.adapter.start();
    }

    public void endMethod() {
        this.adapter.end(new Runnable(){

            public void run() {
                for (Map.Entry entry : IRBytecodeAdapter.this.variableTypes.entrySet()) {
                    int i2 = (Integer)entry.getKey();
                    String name2 = (String)IRBytecodeAdapter.this.variableNames.get(i2);
                    IRBytecodeAdapter.this.adapter.local(i2, name2, (Type)entry.getValue());
                }
            }
        });
    }

    public void push(Long l) {
        this.adapter.aload(0);
        this.adapter.invokedynamic("fixnum", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), Bootstrap.fixnum(), l);
    }

    public void push(ByteList bl) {
        this.adapter.aload(0);
        this.adapter.invokedynamic("string", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), Bootstrap.string(), new String(bl.bytes(), RubyEncoding.ISO), bl.getEncoding().getIndex());
    }

    public void push(String sym) {
        this.adapter.aload(0);
        this.adapter.invokedynamic("symbol", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), Bootstrap.symbol(), sym);
    }

    public void pushRuntime() {
        this.adapter.aload(0);
        this.adapter.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
    }

    public void loadLocal(int i2) {
        this.adapter.aload(i2);
    }

    public void loadContext() {
        this.adapter.aload(0);
    }

    public void loadStaticScope() {
        this.adapter.aload(1);
    }

    public void loadSelf() {
        this.adapter.aload(2);
    }

    public void storeLocal(int i2) {
        this.adapter.astore(i2);
    }

    public void invokeOther(String name2, int arity2) {
        this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2)), Bootstrap.invoke(), new Object[0]);
    }

    public void invokeSelf(String name2, int arity2) {
        this.adapter.invokedynamic("invokeSelf:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2)), Bootstrap.invokeSelf(), new Object[0]);
    }

    public void invokeSuper(String name2, int arity2) {
        this.adapter.invokedynamic("invokeSuper:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2)), new Handle(6, "dummy", "dummy", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;J)Ljava/lang/invoke/CallSite;"), new Object[0]);
    }

    public void invokeOtherBoolean(String name2, int arity2) {
        this.adapter.invokedynamic("invoke:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2)), new Handle(6, "dummy", "dummy", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;J)Ljava/lang/invoke/CallSite;"), new Object[0]);
    }

    public void invokeSelfBoolean(String name2, int arity2) {
        this.adapter.invokedynamic("invokeSelf:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2)), new Handle(6, "dummy", "dummy", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;J)Ljava/lang/invoke/CallSite;"), new Object[0]);
    }

    public void attrAssign(String name2) {
        this.adapter.invokedynamic("attrAssign:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, ThreadContext.class, JVM.OBJECT, JVM.OBJECT), Bootstrap.attrAssign(), new Object[0]);
    }

    public void invokeVirtual(Type type2, Method method2) {
        this.adapter.invokevirtual(type2.getInternalName(), method2.getName(), method2.getDescriptor());
    }

    public void invokeHelper(String name2, Class ... sig) {
        this.adapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), name2, CodegenUtils.sig(sig));
    }

    public void invokeHelper(String name2, String sig) {
        this.adapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), name2, sig);
    }

    public void searchConst(String name2) {
        this.adapter.invokedynamic("searchConst:" + name2, CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, StaticScope.class)), Bootstrap.searchConst(), new Object[0]);
    }

    public void inheritanceSearchConst(String name2) {
        this.adapter.invokedynamic("inheritanceSearchConst:" + name2, CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class)), Bootstrap.inheritanceSearchConst(), new Object[0]);
    }

    public void goTo(Label label) {
        this.adapter.go_to(label);
    }

    public void isTrue() {
        this.adapter.invokeinterface(CodegenUtils.p(IRubyObject.class), "isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
    }

    public void isNil() {
        this.adapter.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
    }

    public void bfalse(Label label) {
        this.adapter.iffalse(label);
    }

    public void btrue(Label label) {
        this.adapter.iftrue(label);
    }

    public void poll() {
        this.adapter.aload(0);
        this.adapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "pollThreadEvents", CodegenUtils.sig(Void.TYPE, new Class[0]));
    }

    public void pushNil() {
        this.adapter.aload(0);
        this.adapter.getfield(CodegenUtils.p(ThreadContext.class), "nil", CodegenUtils.ci(IRubyObject.class));
    }

    public void pushBoolean(boolean b) {
        this.adapter.aload(0);
        this.adapter.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        if (b) {
            this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "getTrue", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
        } else {
            this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "getFalse", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
        }
    }

    public void pushObjectClass() {
        this.adapter.aload(0);
        this.adapter.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.adapter.invokevirtual(CodegenUtils.p(Ruby.class), "getObject", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    public void pushUndefined() {
        this.adapter.getstatic(CodegenUtils.p(UndefinedValue.class), "UNDEFINED", CodegenUtils.ci(UndefinedValue.class));
    }

    public void pushHandle(String className, String methodName, int arity2) {
        this.adapter.getMethodVisitor().visitLdcInsn(new Handle(6, className, methodName, ClassData.SIGS[arity2]));
    }

    public void mark(Label label) {
        this.adapter.label(label);
    }

    public void putField(String name2) {
        this.adapter.invokedynamic("ivarSet:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(Void.TYPE, IRubyObject.class, IRubyObject.class), Bootstrap.ivar(), new Object[0]);
    }

    public void getField(String name2) {
        this.adapter.invokedynamic("ivarGet:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(JVM.OBJECT, IRubyObject.class), Bootstrap.ivar(), new Object[0]);
    }

    public void returnValue() {
        this.adapter.areturn();
    }

    public void array(int length2) {
        this.adapter.invokedynamic("array", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2)), Bootstrap.array(), new Object[0]);
    }

    public int newLocal(String name2, Type type2) {
        int index2 = this.variableCount++;
        this.variableTypes.put(index2, type2);
        this.variableNames.put(index2, name2);
        return index2;
    }

    public Label newLabel() {
        return new Label();
    }
}

