/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstAsgnNode
extends AssignableNode
implements INameNode {
    private String name;
    private RubyClass.VariableAccessor accessor = RubyClass.VariableAccessor.DUMMY_ACCESSOR;

    public InstAsgnNode(ISourcePosition position, String name2, Node valueNode) {
        super(position, valueNode);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.INSTASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitInstAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return InstAsgnNode.createList(this.getValueNode());
    }

    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyClass cls = self.getMetaClass().getRealClass();
        IRubyObject value2 = this.getValueNode().interpret(runtime, context, self, aBlock);
        this.verifyAccessor(cls).set(self, value2);
        return value2;
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value2, Block block, boolean checkArity) {
        RubyClass cls = self.getMetaClass().getRealClass();
        this.verifyAccessor(cls).set(self, value2);
        return runtime.getNil();
    }

    private RubyClass.VariableAccessor verifyAccessor(RubyClass cls) {
        RubyClass.VariableAccessor localAccessor = this.accessor;
        if (localAccessor.getClassId() != cls.hashCode()) {
            this.accessor = localAccessor = cls.getVariableAccessorForWrite(this.name);
        }
        return localAccessor;
    }
}

