/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.cert.CertificateEncodingException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Extensions;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class X509Cert
extends RubyObject {
    private static final long serialVersionUID = 5626619026058595493L;
    private static ObjectAllocator X509CERT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Cert(runtime, klass);
        }
    };
    private IRubyObject serial;
    private IRubyObject not_before;
    private IRubyObject not_after;
    private IRubyObject issuer;
    private IRubyObject subject;
    private IRubyObject public_key;
    private IRubyObject sig_alg;
    private IRubyObject version;
    private List<IRubyObject> extensions;
    private boolean changed = true;
    private X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
    private X509Certificate cert;
    private String public_key_algorithm;
    private byte[] public_key_encoded;

    public static void createX509Cert(Ruby runtime, RubyModule mX509) {
        RubyClass cX509Cert = mX509.defineClassUnder("Certificate", runtime.getObject(), X509CERT_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("CertificateError", openSSLError, openSSLError.getAllocator());
        cX509Cert.defineAnnotatedMethods(X509Cert.class);
    }

    public X509Cert(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    X509AuxCertificate getAuxCert() {
        if (null == this.cert) {
            return null;
        }
        if (this.cert instanceof X509AuxCertificate) {
            return (X509AuxCertificate)this.cert;
        }
        return new X509AuxCertificate(this.cert);
    }

    public static IRubyObject wrap(Ruby runtime, Certificate c) throws java.security.cert.CertificateEncodingException {
        RubyClass cr = Utils.getClassFromPath(runtime, "OpenSSL::X509::Certificate");
        return cr.callMethod(runtime.getCurrentContext(), "new", (IRubyObject)RubyString.newString(runtime, c.getEncoded()));
    }

    public static IRubyObject wrap(Ruby runtime, javax.security.cert.Certificate c) throws CertificateEncodingException {
        RubyClass cr = Utils.getClassFromPath(runtime, "OpenSSL::X509::Certificate");
        return cr.callMethod(runtime.getCurrentContext(), "new", (IRubyObject)RubyString.newString(runtime, c.getEncoded()));
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block unusedBlock) {
        Set<String> ncrit;
        Ruby runtime = context.runtime;
        this.extensions = new ArrayList<IRubyObject>();
        if (args2.length == 0) {
            return this;
        }
        byte[] bytes2 = OpenSSLImpl.readX509PEM(args2[0]);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes2);
        RubyModule ossl = runtime.getModule("OpenSSL");
        RubyModule x509 = (RubyModule)ossl.getConstant("X509");
        IRubyObject x509Name = x509.getConstant("Name");
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.cert = (X509Certificate)cf.generateCertificate(bis);
        }
        catch (CertificateException ex) {
            throw X509Cert.newCertificateError(runtime, ex);
        }
        if (this.cert == null) {
            throw X509Cert.newCertificateError(runtime, (String)null);
        }
        this.set_serial(RubyNumeric.str2inum(runtime, runtime.newString(this.cert.getSerialNumber().toString()), 10));
        this.set_not_before(RubyTime.newTime(runtime, this.cert.getNotBefore().getTime()));
        this.set_not_after(RubyTime.newTime(runtime, this.cert.getNotAfter().getTime()));
        this.set_subject(x509Name.callMethod(context, "new", RubyString.newString(runtime, this.cert.getSubjectX500Principal().getEncoded())));
        this.set_issuer(x509Name.callMethod(context, "new", RubyString.newString(runtime, this.cert.getIssuerX500Principal().getEncoded())));
        String algorithm = this.cert.getPublicKey().getAlgorithm();
        this.set_public_key(algorithm, this.cert.getPublicKey().getEncoded());
        IRubyObject extFact = ((RubyClass)x509.getConstant("ExtensionFactory")).callMethod(context, "new");
        extFact.callMethod(context, "subject_certificate=", this);
        Set<String> crit = this.cert.getCriticalExtensionOIDs();
        if (crit != null) {
            for (String critOid : crit) {
                byte[] value2 = this.cert.getExtensionValue(critOid);
                IRubyObject rValue = ASN1.decode(ossl.getConstant("ASN1"), runtime.newString(new ByteList(value2, false))).callMethod(context, "value");
                X509Extensions.Extension ext2 = (X509Extensions.Extension)x509.getConstant("Extension").callMethod(context, "new", new IRubyObject[]{runtime.newString(critOid), rValue, runtime.getTrue()});
                this.add_extension(ext2);
            }
        }
        if ((ncrit = this.cert.getNonCriticalExtensionOIDs()) != null) {
            for (String ncritOid : ncrit) {
                byte[] value3 = this.cert.getExtensionValue(ncritOid);
                if (value3 == null) continue;
                IRubyObject rValue = ASN1.decode(ossl.getConstant("ASN1"), runtime.newString(new ByteList(value3, false))).callMethod(context, "value");
                X509Extensions.Extension ext3 = (X509Extensions.Extension)x509.getConstant("Extension").callMethod(context, "new", new IRubyObject[]{runtime.newString(ncritOid), rValue, runtime.getFalse()});
                this.add_extension(ext3);
            }
        }
        this.changed = false;
        return this;
    }

    private void set_public_key(String algorithm, byte[] encoded) {
        this.public_key_algorithm = algorithm;
        this.public_key_encoded = encoded;
    }

    public static RaiseException newCertificateError(Ruby runtime, Exception ex) {
        return X509Cert.newCertificateError(runtime, ex.getMessage());
    }

    public static RaiseException newCertificateError(Ruby runtime, String message2) {
        throw Utils.newError(runtime, "OpenSSL::X509::CertificateError", message2);
    }

    @JRubyMethod
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        return this;
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return RubyString.newString(this.getRuntime(), this.cert.getEncoded());
        }
        catch (java.security.cert.CertificateEncodingException ex) {
            throw X509Cert.newCertificateError(this.getRuntime(), ex);
        }
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        try {
            StringWriter w = new StringWriter();
            PEMInputOutput.writeX509Certificate(w, this.getAuxCert());
            w.close();
            return this.getRuntime().newString(w.toString());
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
    }

    @JRubyMethod
    public IRubyObject to_text() {
        return this.getRuntime().newString(this.getAuxCert().toString());
    }

    @JRubyMethod
    public IRubyObject inspect() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject version() {
        return this.version;
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(IRubyObject arg2) {
        if (!arg2.equals(this.version)) {
            this.changed = true;
        }
        this.version = arg2;
        return arg2;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm() {
        return this.sig_alg;
    }

    @JRubyMethod
    public IRubyObject serial() {
        return this.serial;
    }

    @JRubyMethod(name={"serial="})
    public IRubyObject set_serial(IRubyObject num) {
        if (!num.equals(this.serial)) {
            this.changed = true;
        }
        this.serial = num;
        String s2 = this.serial.toString();
        BigInteger bi = s2.equals("0") ? BigInteger.ONE : new BigInteger(s2);
        this.generator.setSerialNumber(bi);
        return num;
    }

    @JRubyMethod
    public IRubyObject subject() {
        return this.subject;
    }

    @JRubyMethod(name={"subject="})
    public IRubyObject set_subject(IRubyObject arg2) {
        if (!arg2.equals(this.subject)) {
            this.changed = true;
        }
        this.subject = arg2;
        this.generator.setSubjectDN(((X509Name)this.subject).getRealName());
        return arg2;
    }

    @JRubyMethod
    public IRubyObject issuer() {
        return this.issuer;
    }

    @JRubyMethod(name={"issuer="})
    public IRubyObject set_issuer(IRubyObject arg2) {
        if (!arg2.equals(this.issuer)) {
            this.changed = true;
        }
        this.issuer = arg2;
        this.generator.setIssuerDN(((X509Name)this.issuer).getRealName());
        return arg2;
    }

    @JRubyMethod
    public IRubyObject not_before() {
        return this.not_before;
    }

    @JRubyMethod(name={"not_before="})
    public IRubyObject set_not_before(IRubyObject arg2) {
        this.changed = true;
        this.not_before = arg2.callMethod(this.getRuntime().getCurrentContext(), "getutc");
        ((RubyTime)this.not_before).setMicroseconds(0L);
        this.generator.setNotBefore(((RubyTime)this.not_before).getJavaDate());
        return arg2;
    }

    @JRubyMethod
    public IRubyObject not_after() {
        return this.not_after;
    }

    @JRubyMethod(name={"not_after="})
    public IRubyObject set_not_after(IRubyObject arg2) {
        this.changed = true;
        this.not_after = arg2.callMethod(this.getRuntime().getCurrentContext(), "getutc");
        ((RubyTime)this.not_after).setMicroseconds(0L);
        this.generator.setNotAfter(((RubyTime)this.not_after).getJavaDate());
        return arg2;
    }

    @JRubyMethod
    public IRubyObject public_key() {
        if (this.public_key == null) {
            this.lazyInitializePublicKey();
        }
        return this.public_key.callMethod(this.getRuntime().getCurrentContext(), "public_key");
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject arg2) {
        Utils.checkKind(this.getRuntime(), arg2, "OpenSSL::PKey::PKey");
        if (!arg2.equals(this.public_key)) {
            this.changed = true;
        }
        this.public_key = arg2;
        this.generator.setPublicKey(((PKey)this.public_key).getPublicKey());
        return arg2;
    }

    private void lazyInitializePublicKey() {
        if (this.public_key_encoded == null || this.public_key_algorithm == null) {
            throw new IllegalStateException("lazy public key initialization failed");
        }
        RubyModule ossl = this.getRuntime().getModule("OpenSSL");
        RubyModule pkey = (RubyModule)ossl.getConstant("PKey");
        ThreadContext tc = this.getRuntime().getCurrentContext();
        boolean backupChanged = this.changed;
        if ("RSA".equalsIgnoreCase(this.public_key_algorithm)) {
            this.set_public_key(pkey.getConstant("RSA").callMethod(tc, "new", RubyString.newString(this.getRuntime(), this.public_key_encoded)));
        } else if ("DSA".equalsIgnoreCase(this.public_key_algorithm)) {
            this.set_public_key(pkey.getConstant("DSA").callMethod(tc, "new", RubyString.newString(this.getRuntime(), this.public_key_encoded)));
        } else {
            throw X509Cert.newCertificateError(this.getRuntime(), "The algorithm " + this.public_key_algorithm + " is unsupported for public keys");
        }
        this.changed = backupChanged;
    }

    @JRubyMethod
    public IRubyObject sign(ThreadContext context, final IRubyObject key2, IRubyObject digest2) {
        Ruby runtime = context.runtime;
        String keyAlg = ((PKey)key2).getAlgorithm();
        String digAlg = ((Digest)digest2).getShortAlgorithm();
        String digName = ((Digest)digest2).name().toString();
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(digName)) {
            throw X509Cert.newCertificateError(runtime, "signature_algorithm not supported");
        }
        for (X509Extensions.Extension extension : this.extensions) {
            try {
                byte[] bytes2 = extension.getRealValueBytes();
                this.generator.addExtension(extension.getRealOid(), extension.getRealCritical(), bytes2);
            }
            catch (IOException ioe) {
                throw runtime.newIOErrorFromException(ioe);
            }
        }
        this.generator.setSignatureAlgorithm(digAlg + "WITH" + keyAlg);
        if (this.public_key == null) {
            this.lazyInitializePublicKey();
        }
        try {
            OpenSSLReal.doWithBCProvider(new OpenSSLReal.Runnable(){

                public void run() throws GeneralSecurityException {
                    X509Cert.this.cert = X509Cert.this.generator.generate(((PKey)key2).getPrivateKey(), "BC");
                }
            });
        }
        catch (GeneralSecurityException gse) {
            throw X509Cert.newCertificateError(this.getRuntime(), gse.getMessage());
        }
        if (this.cert == null) {
            throw X509Cert.newCertificateError(runtime, (String)null);
        }
        String name2 = ASN1Registry.o2a(this.cert.getSigAlgOID());
        if (name2 == null) {
            name2 = this.cert.getSigAlgOID();
        }
        this.sig_alg = runtime.newString(name2);
        this.changed = false;
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(IRubyObject key2) {
        if (this.changed) {
            return this.getRuntime().getFalse();
        }
        try {
            this.cert.verify(((PKey)key2).getPublicKey());
            return this.getRuntime().getTrue();
        }
        catch (CertificateException ce) {
            throw X509Cert.newCertificateError(this.getRuntime(), ce);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw X509Cert.newCertificateError(this.getRuntime(), nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw X509Cert.newCertificateError(this.getRuntime(), nspe);
        }
        catch (SignatureException se) {
            throw X509Cert.newCertificateError(this.getRuntime(), se);
        }
        catch (InvalidKeyException e) {
            return this.getRuntime().getFalse();
        }
    }

    @JRubyMethod
    public IRubyObject check_private_key(IRubyObject arg2) {
        PKey key2 = (PKey)arg2;
        PublicKey pkey = key2.getPublicKey();
        PublicKey certPubKey = this.getAuxCert().getPublicKey();
        if (certPubKey.equals(pkey)) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod
    public IRubyObject extensions() {
        return this.getRuntime().newArray(this.extensions);
    }

    @JRubyMethod(name={"extensions="})
    public IRubyObject set_extensions(IRubyObject arg2) {
        this.extensions = new ArrayList<IRubyObject>(((RubyArray)arg2).getList());
        return arg2;
    }

    @JRubyMethod
    public IRubyObject add_extension(IRubyObject arg2) {
        this.changed = true;
        DERObjectIdentifier oid2 = ((X509Extensions.Extension)arg2).getRealOid();
        if (oid2.equals((Object)new DERObjectIdentifier("2.5.29.17"))) {
            boolean one = true;
            for (X509Extensions.Extension extension : this.extensions) {
                if (!extension.getRealOid().equals((Object)new DERObjectIdentifier("2.5.29.17"))) continue;
                ASN1EncodableVector v1 = new ASN1EncodableVector();
                try {
                    GeneralName[] n1 = GeneralNames.getInstance((Object)new ASN1InputStream(extension.getRealValueBytes()).readObject()).getNames();
                    GeneralName[] n2 = GeneralNames.getInstance((Object)new ASN1InputStream(((X509Extensions.Extension)arg2).getRealValueBytes()).readObject()).getNames();
                    for (int i2 = 0; i2 < n1.length; ++i2) {
                        v1.add((DEREncodable)n1[i2]);
                    }
                    for (int i2 = 0; i2 < n2.length; ++i2) {
                        v1.add((DEREncodable)n2[i2]);
                    }
                }
                catch (IOException ex) {
                    throw this.getRuntime().newIOErrorFromException(ex);
                }
                extension.setRealValue(new String(ByteList.plain((byte[])new GeneralNames((ASN1Sequence)new DERSequence(v1)).getDEREncoded())));
                one = false;
                break;
            }
            if (one) {
                this.extensions.add(arg2);
            }
        } else {
            this.extensions.add(arg2);
        }
        return arg2;
    }
}

