/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.GZIPInputStream;
import com.jcraft.jzlib.Inflater;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.zlib.RubyGzipFile;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingOption;
import org.jruby.util.io.Stream;

@JRubyClass(name={"Zlib::GzipReader"}, parent="Zlib::GzipFile", include={"Enumerable"})
public class JZlibRubyGzipReader
extends RubyGzipFile {
    protected static final ObjectAllocator GZIPREADER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new JZlibRubyGzipReader(runtime, klass);
        }
    };
    private int line;
    private long position;
    private GZIPInputStream io;
    private InputStream bufferedStream;
    private static final int BUFF_SIZE = 4096;

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static JZlibRubyGzipReader newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        JZlibRubyGzipReader result2 = (JZlibRubyGzipReader)klass.allocate();
        result2.callInit(args2, block);
        return result2;
    }

    @JRubyMethod(name={"open"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject open18(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = recv2.getRuntime();
        IRubyObject io2 = RuntimeHelpers.invoke(context, (IRubyObject)runtime.getFile(), "open", args2[0], (IRubyObject)runtime.newString("rb"));
        JZlibRubyGzipReader gzio = JZlibRubyGzipReader.newInstance(recv2, new IRubyObject[]{io2}, block);
        return RubyGzipFile.wrapBlock(context, gzio, block);
    }

    @JRubyMethod(name={"open"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = recv2.getRuntime();
        IRubyObject io2 = RuntimeHelpers.invoke(context, (IRubyObject)runtime.getFile(), "open", args2[0], (IRubyObject)runtime.newString("rb"));
        JZlibRubyGzipReader gzio = JZlibRubyGzipReader.newInstance(recv2, JZlibRubyGzipReader.argsWithIo(io2, args2), block);
        return RubyGzipFile.wrapBlock(context, gzio, block);
    }

    public JZlibRubyGzipReader(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject stream) {
        this.realIo = stream;
        this.line = 0;
        this.position = 0L;
        try {
            this.io = new GZIPInputStream((InputStream)new IOInputStream(this.realIo), 512, false);
            this.io.readHeader();
        }
        catch (IOException e) {
            byte[] input;
            RaiseException re = RubyZlib.newGzipFileError(this.getRuntime(), "not in gzip format");
            if (this.getRuntime().is1_9() && (input = this.io.getAvailIn()) != null && input.length > 0) {
                ByteList i2 = new ByteList(input, 0, input.length);
                RubyException rubye = re.getException();
                rubye.setInstanceVariable("@input", RubyString.newString(this.getRuntime(), i2));
            }
            throw re;
        }
        this.bufferedStream = new BufferedInputStream((InputStream)this.io);
        return this;
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(IRubyObject[] args2) {
        EncodingOption enc;
        IRubyObject opt;
        IRubyObject obj = this.initialize(args2[0]);
        if (args2.length > 1 && !(opt = TypeConverter.checkHashType(this.getRuntime(), args2[args2.length - 1])).isNil() && (enc = EncodingOption.getEncodingOptionFromObject(opt)) != null) {
            this.readEncoding = enc.getExternalEncoding();
            this.writeEncoding = enc.getInternalEncoding();
        }
        if (this.realIo.respondsTo("path")) {
            obj.getSingletonClass().defineMethod("path", new Callback(){

                public IRubyObject execute(IRubyObject recv2, IRubyObject[] args2, Block block) {
                    return ((JZlibRubyGzipReader)recv2).realIo.callMethod(recv2.getRuntime().getCurrentContext(), "path");
                }

                public Arity getArity() {
                    return Arity.NO_ARGUMENTS;
                }
            });
        }
        return obj;
    }

    private long internalPosition() {
        Inflater inflater = this.io.getInflater();
        return inflater.getTotalIn() + (long)inflater.getAvailIn();
    }

    @JRubyMethod
    public IRubyObject rewind() {
        Ruby rt = this.getRuntime();
        this.realIo.callMethod(rt.getCurrentContext(), "seek", new IRubyObject[]{rt.newFixnum(-this.internalPosition()), rt.newFixnum(1)});
        this.initialize(this.realIo);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.line);
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context) {
        IRubyObject dst = this.gets_18(context, new IRubyObject[0]);
        if (dst.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return dst;
    }

    private IRubyObject internalGets(IRubyObject[] args2) throws IOException {
        ByteList sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
        int limit2 = -1;
        switch (args2.length) {
            case 0: {
                break;
            }
            case 1: {
                if (args2[0].isNil()) {
                    return this.readAll();
                }
                IRubyObject tmp = args2[0].checkStringType();
                if (tmp.isNil()) {
                    limit2 = RubyNumeric.fix2int(args2[0]);
                    break;
                }
                sep = tmp.convertToString().getByteList();
                break;
            }
            default: {
                limit2 = RubyNumeric.fix2int(args2[1]);
                if (args2[0].isNil()) {
                    return this.readAll(limit2);
                }
                sep = args2[0].convertToString().getByteList();
            }
        }
        return this.internalSepGets(sep, limit2);
    }

    private IRubyObject internalSepGets(ByteList sep) throws IOException {
        return this.internalSepGets(sep, -1);
    }

    private ByteList newReadByteList() {
        ByteList byteList = new ByteList();
        if (this.readEncoding != null) {
            byteList.setEncoding(this.readEncoding);
        }
        return byteList;
    }

    private ByteList newReadByteList(int size2) {
        ByteList byteList = new ByteList(size2);
        if (this.readEncoding != null) {
            byteList.setEncoding(this.readEncoding);
        }
        return byteList;
    }

    private IRubyObject internalSepGets(ByteList sep, int limit2) throws IOException {
        ByteList result2 = this.newReadByteList();
        if (sep.getRealSize() == 0) {
            sep = Stream.PARAGRAPH_SEPARATOR;
        }
        int ce = -1;
        while (result2.indexOf(sep) == -1 && (ce = this.bufferedStream.read()) != -1) {
            result2.append(ce);
            if (limit2 <= 0 || result2.length() < limit2) continue;
        }
        if (0 == result2.length() && -1 == ce) {
            return this.getRuntime().getNil();
        }
        ++this.line;
        this.position = result2.length();
        return this.newStr(this.getRuntime(), result2);
    }

    @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gets_18(ThreadContext context, IRubyObject[] args2) {
        return this.gets(context, args2);
    }

    @JRubyMethod(name={"gets"}, optional=2, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        try {
            IRubyObject result2 = this.internalGets(args2);
            if (!result2.isNil()) {
                context.getCurrentScope().setLastLine(result2);
            }
            return result2;
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"read"}, optional=1)
    public IRubyObject read(IRubyObject[] args2) {
        try {
            if (args2.length == 0 || args2[0].isNil()) {
                return this.readAll();
            }
            int len = RubyNumeric.fix2int(args2[0]);
            if (len < 0) {
                throw this.getRuntime().newArgumentError("negative length " + len + " given");
            }
            if (len > 0) {
                ByteList buf = this.readSize(len);
                if (buf == null) {
                    return this.getRuntime().getNil();
                }
                return this.newStr(this.getRuntime(), buf);
            }
            return RubyString.newEmptyString(this.getRuntime());
        }
        catch (IOException ioe) {
            String m = ioe.getMessage();
            if (m.startsWith("Unexpected end of ZLIB input stream")) {
                throw RubyZlib.newGzipFileError(this.getRuntime(), ioe.getMessage());
            }
            if (m.startsWith("footer is not found")) {
                throw RubyZlib.newNoFooter(this.getRuntime(), "footer is not found");
            }
            if (m.startsWith("incorrect data check")) {
                throw RubyZlib.newCRCError(this.getRuntime(), "invalid compressed data -- crc error");
            }
            if (m.startsWith("incorrect length check")) {
                throw RubyZlib.newLengthError(this.getRuntime(), "invalid compressed data -- length error");
            }
            throw RubyZlib.newDataError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(IRubyObject[] args2) {
        try {
            int len = RubyNumeric.fix2int(args2[0]);
            if (len < 0) {
                throw this.getRuntime().newArgumentError("negative length " + len + " given");
            }
            if (args2.length > 1) {
                if (!(args2[1] instanceof RubyString)) {
                    throw this.getRuntime().newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected String)");
                }
                return this.readPartial(len, (RubyString)args2[1]);
            }
            return this.readPartial(len, null);
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private IRubyObject readPartial(int len, RubyString outbuf) throws IOException {
        ByteList val = this.newReadByteList(10);
        byte[] buffer = new byte[len];
        int read2 = this.bufferedStream.read(buffer, 0, len);
        if (read2 == -1) {
            return this.getRuntime().getNil();
        }
        val.append(buffer, 0, read2);
        this.position += (long)val.length();
        if (outbuf != null) {
            outbuf.view(val);
        }
        return this.newStr(this.getRuntime(), val);
    }

    private IRubyObject readAll() throws IOException {
        return this.readAll(-1);
    }

    private IRubyObject readAll(int limit2) throws IOException {
        int read2;
        ByteList val = this.newReadByteList(10);
        int rest2 = limit2 == -1 ? 4096 : limit2;
        byte[] buffer = new byte[rest2];
        while (rest2 > 0 && (read2 = this.bufferedStream.read(buffer, 0, rest2)) != -1) {
            val.append(buffer, 0, read2);
            if (limit2 == -1) continue;
            rest2 -= read2;
        }
        this.position += (long)val.length();
        return this.newStr(this.getRuntime(), val);
    }

    private ByteList readSize(int length2) throws IOException {
        byte[] buffer = new byte[length2];
        int toRead = length2;
        int offset2 = 0;
        while (toRead > 0) {
            int read2 = this.bufferedStream.read(buffer, offset2, toRead);
            if (read2 == -1) {
                if (offset2 != 0) break;
                return null;
            }
            toRead -= read2;
            offset2 += read2;
        }
        this.position += (long)buffer.length;
        return new ByteList(buffer, 0, length2 - toRead, false);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(IRubyObject lineArg) {
        this.line = RubyNumeric.fix2int(lineArg);
        return lineArg;
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos() {
        return RubyNumeric.int2fix(this.getRuntime(), this.position);
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        try {
            int value2 = this.bufferedStream.read();
            if (value2 == -1) {
                throw this.getRuntime().newEOFError();
            }
            ++this.position;
            return this.getRuntime().newFixnum(value2);
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"getc", "getbyte"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject getc() {
        try {
            int value2 = this.bufferedStream.read();
            if (value2 == -1) {
                return this.getRuntime().getNil();
            }
            ++this.position;
            return this.getRuntime().newFixnum(value2);
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"getbyte"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getbyte() {
        return this.getc();
    }

    @JRubyMethod(name={"getc"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getc_19() {
        try {
            int value2 = this.bufferedStream.read();
            if (value2 == -1) {
                return this.getRuntime().getNil();
            }
            ++this.position;
            return this.getRuntime().newString("" + (char)(value2 & 0xFF));
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private boolean isEof() throws IOException {
        if (this.bufferedStream.available() == 0) {
            return true;
        }
        this.bufferedStream.mark(16);
        this.bufferedStream.read();
        this.bufferedStream.reset();
        return this.bufferedStream.available() == 0;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        if (!this.closed) {
            try {
                this.bufferedStream.close();
                if (this.realIo.respondsTo("close")) {
                    this.realIo.callMethod(this.realIo.getRuntime().getCurrentContext(), "close");
                }
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }
        this.closed = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"eof"})
    public IRubyObject eof() {
        try {
            return this.isEof() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod(name={"eof?"})
    public IRubyObject eof_p() {
        return this.eof();
    }

    @JRubyMethod
    public IRubyObject unused() {
        byte[] tmp = this.io.getAvailIn();
        if (tmp == null) {
            return this.getRuntime().getNil();
        }
        return RubyString.newString(this.getRuntime(), tmp);
    }

    @JRubyMethod
    public IRubyObject crc() {
        long crc2 = 0L;
        try {
            crc2 = this.io.getCRC();
        }
        catch (GZIPException gZIPException) {
            // empty catch block
        }
        return this.getRuntime().newFixnum(crc2);
    }

    @JRubyMethod
    public IRubyObject os_code() {
        int os = this.io.getOS();
        if (os == 255) {
            os = 11;
        }
        return this.getRuntime().newFixnum(os & 0xFF);
    }

    @JRubyMethod
    public IRubyObject orig_name() {
        String name2 = this.io.getName();
        this.nullFreeOrigName = this.getRuntime().newString(name2);
        return super.orig_name();
    }

    @JRubyMethod
    public IRubyObject comment() {
        String comment2 = this.io.getComment();
        this.nullFreeComment = this.getRuntime().newString(comment2);
        return super.comment();
    }

    @JRubyMethod(optional=1)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        ByteList sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
        if (args2.length > 0 && !args2[0].isNil()) {
            sep = args2[0].convertToString().getByteList();
        }
        try {
            IRubyObject result2 = this.internalSepGets(sep);
            while (!result2.isNil()) {
                block.yield(context, result2);
                result2 = this.internalSepGets(sep);
            }
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(optional=1)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.each(context, args2, block);
    }

    @JRubyMethod
    public IRubyObject ungetc(IRubyObject arg2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(optional=1)
    public IRubyObject readlines(IRubyObject[] args2) {
        ArrayList<IRubyObject> array = new ArrayList<IRubyObject>();
        if (args2.length != 0 && args2[0].isNil()) {
            array.add(this.read(new IRubyObject[0]));
        } else {
            ByteList sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
            if (args2.length > 0) {
                sep = args2[0].convertToString().getByteList();
            }
            try {
                IRubyObject result2 = this.internalSepGets(sep);
                while (!result2.isNil()) {
                    array.add(result2);
                    result2 = this.internalSepGets(sep);
                }
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }
        return this.getRuntime().newArray(array);
    }

    @JRubyMethod
    public IRubyObject each_byte(ThreadContext context, Block block) {
        try {
            int value2 = this.bufferedStream.read();
            while (value2 != -1) {
                ++this.position;
                block.yield(context, this.getRuntime().newFixnum(value2));
                value2 = this.bufferedStream.read();
            }
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
        return this.getRuntime().getNil();
    }

    @JRubyClass(name={"Zlib::GzipReader::Error"}, parent="Zlib::GzipReader")
    public static class Error {
    }
}

