/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.DataFlowVar;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.util.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveVariableNode
extends FlowGraphNode {
    private BitSet in;
    private BitSet out;
    private int setSize;

    public LiveVariableNode(DataFlowProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this.setSize = this.problem.getDFVarsCount();
        this.out = new BitSet(this.setSize);
    }

    private void addDFVar(Variable v) {
        LiveVariablesProblem lvp = (LiveVariablesProblem)this.problem;
        if (!lvp.dfVarExists(v)) {
            lvp.addDFVar(v);
        }
    }

    @Override
    public void buildDataFlowVars(Instr i2) {
        if (i2 instanceof ResultInstr) {
            this.addDFVar(((ResultInstr)((Object)i2)).getResult());
        }
        for (Variable x : i2.getUsedVariables()) {
            this.addDFVar(x);
        }
    }

    @Override
    public void initSolnForNode() {
        Collection<LocalVariable> lv;
        LiveVariablesProblem p2 = (LiveVariablesProblem)this.problem;
        this.in = new BitSet(this.setSize);
        if (this.basicBlock == p2.getScope().cfg().getExitBB() && (lv = p2.getVarsLiveOnScopeExit()) != null && !lv.isEmpty()) {
            for (LocalVariable v : lv) {
                this.in.set(p2.getDFVar(v).getId());
            }
        }
    }

    @Override
    public void compute_MEET(Edge e, BasicBlock source2, FlowGraphNode pred2) {
        this.in.or(((LiveVariableNode)pred2).out);
    }

    private void markAllVariablesLive(LiveVariablesProblem lvp, BitSet living, Collection<? extends Variable> variableList) {
        for (Variable variable : variableList) {
            this.markVariableLive(lvp, living, variable);
        }
    }

    private void markVariableLive(LiveVariablesProblem lvp, BitSet living, Variable x) {
        DataFlowVar dv = lvp.getDFVar(x);
        if (dv != null) {
            living.set(dv.getId());
        }
    }

    @Override
    public boolean applyTransferFunction() {
        LiveVariablesProblem lvp = (LiveVariablesProblem)this.problem;
        boolean scopeBindingHasEscaped = lvp.getScope().bindingHasEscaped();
        BitSet living = (BitSet)this.in.clone();
        List<Instr> instrs = this.basicBlock.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            Instr i2 = it.previous();
            if (i2 instanceof ResultInstr) {
                Variable v = ((ResultInstr)((Object)i2)).getResult();
                living.clear(lvp.getDFVar(v).getId());
            }
            if (i2 instanceof CallBase) {
                CallBase c = (CallBase)i2;
                Operand o = c.getClosureArg(null);
                if (o != null && o instanceof WrappedIRClosure) {
                    List<Variable> liveOnEntryAfter;
                    boolean changed;
                    IRClosure cl = ((WrappedIRClosure)o).getClosure();
                    LiveVariablesProblem cl_lvp = (LiveVariablesProblem)cl.getDataFlowSolution("Live Variables Analysis");
                    if (cl_lvp == null) {
                        cl_lvp = new LiveVariablesProblem(cl, lvp.getNonSelfLocalVars());
                        cl.setDataFlowSolution(cl_lvp.getName(), cl_lvp);
                    }
                    HashSet<LocalVariable> liveVars = new HashSet<LocalVariable>();
                    for (int j = 0; j < living.size(); ++j) {
                        Variable v;
                        if (!living.get(j) || !((v = lvp.getVariable(j)) instanceof LocalVariable)) continue;
                        liveVars.add((LocalVariable)v);
                    }
                    List<Variable> liveOnEntryBefore = cl_lvp.getVarsLiveOnScopeEntry();
                    for (Variable y : liveOnEntryBefore) {
                        if (!(y instanceof LocalVariable)) continue;
                        liveVars.add((LocalVariable)y);
                    }
                    if (c.canRaiseException()) {
                        BitSet etOut = ((LiveVariableNode)this.getExceptionTargetNode()).out;
                        for (int k = 0; k < etOut.size(); ++k) {
                            Variable v;
                            if (!etOut.get(k) || !((v = lvp.getVariable(k)) instanceof LocalVariable)) continue;
                            liveVars.add((LocalVariable)v);
                        }
                    }
                    cl_lvp.setVarsLiveOnScopeExit(liveVars);
                    cl_lvp.compute_MOP_Solution();
                    do {
                        changed = false;
                        liveOnEntryAfter = cl_lvp.getVarsLiveOnScopeEntry();
                        for (Variable y : liveOnEntryAfter) {
                            LocalVariable ly;
                            if (!(y instanceof LocalVariable) || liveVars.contains(ly = (LocalVariable)y)) continue;
                            changed = true;
                            liveVars.add(ly);
                        }
                        if (!changed) continue;
                        cl_lvp.setVarsLiveOnScopeExit(liveVars);
                        cl_lvp.compute_MOP_Solution();
                    } while (changed);
                    this.markAllVariablesLive(lvp, living, liveOnEntryAfter);
                }
                if (scopeBindingHasEscaped || c.targetRequiresCallersBinding()) {
                    for (LocalVariable x : lvp.getNonSelfLocalVars()) {
                        if (x.isImplicitBlockArg()) continue;
                        living.set(lvp.getDFVar(x).getId());
                    }
                } else if (c.canRaiseException()) {
                    this.makeOutExceptionVariablesLiving(living);
                }
            } else if (i2.canRaiseException()) {
                this.makeOutExceptionVariablesLiving(living);
            }
            this.markAllVariablesLive(lvp, living, i2.getUsedVariables());
        }
        if (living.equals(this.out)) {
            return false;
        }
        this.out = living;
        return true;
    }

    private void makeOutExceptionVariablesLiving(BitSet living) {
        BitSet etOut = ((LiveVariableNode)this.getExceptionTargetNode()).out;
        for (int i2 = 0; i2 < etOut.size(); ++i2) {
            if (!etOut.get(i2)) continue;
            living.set(i2);
        }
    }

    public String toString() {
        int i2;
        StringBuilder buf = new StringBuilder();
        buf.append("\tVars Live on Entry: ");
        int count2 = 0;
        for (i2 = 0; i2 < this.in.size(); ++i2) {
            if (!this.in.get(i2)) continue;
            buf.append(' ').append(i2);
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        buf.append("\n\tVars Live on Exit: ");
        count2 = 0;
        for (i2 = 0; i2 < this.out.size(); ++i2) {
            if (!this.out.get(i2)) continue;
            buf.append(' ').append(i2);
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        return buf.append('\n').toString();
    }

    void markDeadInstructions() {
        LiveVariablesProblem lvp = (LiveVariablesProblem)this.problem;
        IRScope scope = lvp.getScope();
        boolean scopeBindingHasEscaped = scope.bindingHasEscaped();
        if (this.in == null) {
            for (Instr i2 : this.basicBlock.getInstrs()) {
                i2.markDead();
            }
            return;
        }
        BitSet living = (BitSet)this.in.clone();
        List<Instr> instrs = this.basicBlock.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            Instr i3 = it.previous();
            if (i3 instanceof ResultInstr) {
                Variable v = ((ResultInstr)((Object)i3)).getResult();
                DataFlowVar dv = lvp.getDFVar(v);
                if (living.get(dv.getId())) {
                    living.clear(dv.getId());
                } else if (i3.canBeDeleted(scope)) {
                    i3.markDead();
                    it.remove();
                    if (v.isImplicitBlockArg()) {
                        lvp.getScope().markUnusedImplicitBlockArg();
                    }
                }
            } else if (i3.canBeDeleted(scope)) {
                i3.markDead();
                it.remove();
            }
            if (i3 instanceof CallBase) {
                CallBase c = (CallBase)i3;
                Operand o = c.getClosureArg(null);
                if (o != null && o instanceof WrappedIRClosure) {
                    IRClosure cl = ((WrappedIRClosure)o).getClosure();
                    LiveVariablesProblem cl_lvp = (LiveVariablesProblem)cl.getDataFlowSolution(lvp.getName());
                    this.markAllVariablesLive(lvp, living, cl_lvp.getVarsLiveOnScopeEntry());
                } else if (scopeBindingHasEscaped || c.targetRequiresCallersBinding()) {
                    for (LocalVariable x : lvp.getNonSelfLocalVars()) {
                        if (x.isImplicitBlockArg()) continue;
                        living.set(lvp.getDFVar(x).getId());
                    }
                } else if (c.canRaiseException()) {
                    this.makeOutExceptionVariablesLiving(living);
                }
            } else if (i3.canRaiseException()) {
                this.makeOutExceptionVariablesLiving(living);
            }
            if (i3.isDead()) continue;
            this.markAllVariablesLive(lvp, living, i3.getUsedVariables());
        }
    }

    BitSet getLiveInBitSet() {
        return this.in;
    }

    BitSet getLiveOutBitSet() {
        return this.out;
    }
}

