/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class ReceiveExceptionInstr
extends Instr
implements ResultInstr {
    private Variable result;
    private boolean checkType;

    public ReceiveExceptionInstr(Variable result2, boolean checkType) {
        super(Operation.RECV_EXCEPTION);
        assert (result2 != null) : "ResultExceptionInstr result is null";
        this.result = result2;
        this.checkType = checkType;
    }

    public ReceiveExceptionInstr(Variable result2) {
        this(result2, true);
    }

    public Operand[] getOperands() {
        return EMPTY_OPERANDS;
    }

    public Variable getResult() {
        return this.result;
    }

    public void updateResult(Variable v) {
        this.result = v;
    }

    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + (this.hasUnusedResult() ? "[DEAD-RESULT]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + (!this.checkType ? " [no-typecheck]" : "");
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new ReceiveExceptionInstr(ii.getRenamedVariable(this.result));
    }

    public void visit(IRVisitor visitor) {
        visitor.ReceiveExceptionInstr(this);
    }
}

