/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.controller;

import java.util.List;
import org.jsondoc.core.pojo.JSONDoc;
import org.jsondoc.core.scanner.JSONDocScanner;
import org.jsondoc.springmvc.scanner.Spring3JSONDocScanner;
import org.jsondoc.springmvc.scanner.Spring4JSONDocScanner;
import org.springframework.core.SpringVersion;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class JSONDocController {
    private String version;
    private String basePath;
    private List<String> packages;
    private JSONDocScanner jsondocScanner;
    private boolean playgroundEnabled = true;
    private JSONDoc.MethodDisplay displayMethodAs = JSONDoc.MethodDisplay.URI;
    public static final String JSONDOC_DEFAULT_PATH = "/jsondoc";
    private static final Integer SPRING_VERSION_3_X = 3;

    public JSONDocController(String version, String basePath, List<String> packages) {
        this.version = version;
        this.basePath = basePath;
        this.packages = packages;
        String springVersion = SpringVersion.getVersion();
        if (springVersion != null && !springVersion.isEmpty()) {
            Integer majorSpringVersion = Integer.parseInt(springVersion.split("\\.")[0]);
            this.jsondocScanner = majorSpringVersion > SPRING_VERSION_3_X ? new Spring4JSONDocScanner() : new Spring3JSONDocScanner();
        } else {
            try {
                Class.forName("org.springframework.web.bind.annotation.RestController");
                this.jsondocScanner = new Spring4JSONDocScanner();
            }
            catch (ClassNotFoundException e) {
                this.jsondocScanner = new Spring3JSONDocScanner();
            }
        }
    }

    public boolean isPlaygroundEnabled() {
        return this.playgroundEnabled;
    }

    public void setPlaygroundEnabled(boolean playgroundEnabled) {
        this.playgroundEnabled = playgroundEnabled;
    }

    public JSONDoc.MethodDisplay getDisplayMethodAs() {
        return this.displayMethodAs;
    }

    public void setDisplayMethodAs(JSONDoc.MethodDisplay displayMethodAs) {
        this.displayMethodAs = displayMethodAs;
    }

    @RequestMapping(value={"/jsondoc"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JSONDoc getApi() {
        return this.jsondocScanner.getJSONDoc(this.version, this.basePath, this.packages, this.playgroundEnabled, this.displayMethodAs);
    }
}

