/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.ant;

import org.jsonschema2pojo.AbstractRuleLogger;
import org.jsonschema2pojo.ant.Jsonschema2PojoTask;

public class AntRuleLogger
extends AbstractRuleLogger {
    private static final String LEVEL_PREFIX = "[";
    private static final String LEVEL_SUFFIX = "] ";
    private static final String DEBUG_LEVEL_PREFIX = "[DEBUG] ";
    private static final String ERROR_LEVEL_PREFIX = "[ERROR] ";
    private static final String INFO_LEVEL_PREFIX = "[INFO] ";
    private static final String TRACE_LEVEL_PREFIX = "[TRACE] ";
    private static final String WARN_LEVEL_PREFIX = "[WARN] ";
    private final Jsonschema2PojoTask task;

    public AntRuleLogger(Jsonschema2PojoTask jsonschema2PojoTask) {
        this.task = jsonschema2PojoTask;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    protected void doDebug(String msg) {
        this.log(msg, null, 4, DEBUG_LEVEL_PREFIX);
    }

    protected void doError(String msg, Throwable e) {
        this.log(msg, e, 0, ERROR_LEVEL_PREFIX);
    }

    protected void doInfo(String msg) {
        this.log(msg, null, 2, INFO_LEVEL_PREFIX);
    }

    protected void doTrace(String msg) {
        this.log(msg, null, 3, TRACE_LEVEL_PREFIX);
    }

    protected void doWarn(String msg, Throwable e) {
        this.log(msg, null, 1, WARN_LEVEL_PREFIX);
    }

    private void log(String msg, Throwable e, int level, String levelPrefix) {
        if (this.task != null && this.task.getProject() != null) {
            if (e != null) {
                this.task.getProject().log(msg, e, level);
            } else {
                this.task.getProject().log(msg, level);
            }
        } else {
            System.err.println(levelPrefix + msg);
            if (e != null) {
                e.printStackTrace(System.err);
            }
        }
    }
}

