/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.TreeNode;
import org.junit.platform.console.tasks.TreePrinter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class TreePrintingListener
implements TestExecutionListener {
    private final Deque<TreeNode> stack;
    private final TreePrinter treePrinter;

    TreePrintingListener(PrintWriter out, boolean disableAnsiColors, Theme theme) {
        this.treePrinter = new TreePrinter(out, theme, disableAnsiColors);
        this.stack = new ArrayDeque<TreeNode>();
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.stack.push(new TreeNode(testPlan.toString()));
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.treePrinter.print(this.stack.pop());
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        TreeNode node = new TreeNode(testIdentifier);
        this.stack.peek().addChild(node);
        this.stack.push(node);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.stack.pop().setResult(testExecutionResult);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.stack.peek().addChild(new TreeNode(testIdentifier, reason));
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.stack.peek().addReportEntry(entry);
    }
}

