/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.IOException;
import java.io.Writer;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.console.options.AvailableOptions;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.CommandLineOptionsParser;
import org.junit.platform.console.shadow.picocli.CommandLine;

@API(status=API.Status.INTERNAL, since="1.0")
public class PicocliCommandLineOptionsParser
implements CommandLineOptionsParser {
    @Override
    public CommandLineOptions parse(String ... arguments) {
        AvailableOptions availableOptions = this.getAvailableOptions();
        CommandLine parser = availableOptions.getParser();
        try {
            CommandLine.ParseResult detectedOptions = parser.parseArgs(arguments);
            return availableOptions.toCommandLineOptions(detectedOptions);
        }
        catch (Exception e) {
            throw new JUnitException("Error parsing command-line arguments: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void printHelp(Writer writer) {
        try {
            writer.write(this.getAvailableOptions().getParser().getUsageMessage());
        }
        catch (IOException e) {
            throw new JUnitException("Error printing help", (Throwable)e);
        }
    }

    private AvailableOptions getAvailableOptions() {
        return new AvailableOptions();
    }
}

