/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.lang.reflect.Method;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;

@API(value=API.Usage.Experimental)
public class MethodSelector
implements DiscoverySelector {
    private final String className;
    private final String methodName;
    private final String methodParameterTypes;
    private Class<?> javaClass;
    private Method javaMethod;

    MethodSelector(String className, String methodName) {
        this(className, methodName, null);
    }

    MethodSelector(String className, String methodName, String methodParameterTypes) {
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    MethodSelector(Class<?> javaClass, String methodName) {
        this(javaClass, methodName, null);
    }

    public MethodSelector(Class<?> javaClass, String methodName, String methodParameterTypes) {
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    MethodSelector(Class<?> javaClass, Method method) {
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.javaMethod = method;
        this.methodName = method.getName();
        this.methodParameterTypes = null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodParameterTypes() {
        return this.methodParameterTypes;
    }

    public Class<?> getJavaClass() {
        this.lazyLoadJavaClass();
        return this.javaClass;
    }

    public Method getJavaMethod() {
        this.lazyLoadJavaMethod();
        return this.javaMethod;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("className", (Object)this.className).append("methodName", (Object)this.methodName).append("methodParameterTypes", (Object)this.methodParameterTypes).toString();
    }

    private void lazyLoadJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = (Class)ReflectionUtils.loadClass((String)this.className).orElseThrow(() -> new PreconditionViolationException("Could not load class with name: " + this.className));
        }
    }

    private void lazyLoadJavaMethod() {
        this.lazyLoadJavaClass();
        if (this.javaMethod == null) {
            this.javaMethod = StringUtils.isNotBlank((String)this.methodParameterTypes) ? (Method)ReflectionUtils.findMethod(this.javaClass, (String)this.methodName, (String)this.methodParameterTypes).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] and parameter types [%s] in class [%s].", this.methodName, this.methodParameterTypes, this.javaClass.getName()))) : (Method)ReflectionUtils.findMethod(this.javaClass, (String)this.methodName, (Class[])new Class[0]).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] in class [%s].", this.methodName, this.javaClass.getName())));
        }
    }
}

