/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.inheritance.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.GenericVisitor;
import japa.parser.ast.visitor.GenericVisitorAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeToJTypeConvertingVisitor
extends GenericVisitorAdapter<JType, JCodeModel> {
    private final Map<String, JClass> knownClasses;

    public TypeToJTypeConvertingVisitor(Map<String, JClass> knownClasses) {
        Validate.notNull(knownClasses);
        this.knownClasses = knownClasses;
    }

    public JType visit(VoidType type, JCodeModel codeModel) {
        return codeModel.VOID;
    }

    public JType visit(PrimitiveType type, JCodeModel codeModel) {
        switch (type.getType()) {
            case Boolean: {
                return codeModel.BOOLEAN;
            }
            case Char: {
                return codeModel.CHAR;
            }
            case Byte: {
                return codeModel.BYTE;
            }
            case Short: {
                return codeModel.SHORT;
            }
            case Int: {
                return codeModel.INT;
            }
            case Long: {
                return codeModel.LONG;
            }
            case Float: {
                return codeModel.FLOAT;
            }
            case Double: {
                return codeModel.DOUBLE;
            }
        }
        throw new AssertionError((Object)("Unknown primitive type [" + type.getType() + "]"));
    }

    public JType visit(ReferenceType type, JCodeModel codeModel) {
        JType referencedType;
        JType referencedTypeArray = referencedType = (JType)type.getType().accept((GenericVisitor)this, (Object)codeModel);
        for (int index = 0; index < type.getArrayCount(); ++index) {
            referencedTypeArray = referencedTypeArray.array();
        }
        return referencedTypeArray;
    }

    public JType visit(WildcardType type, JCodeModel codeModel) {
        if (type.getExtends() != null) {
            ReferenceType _extends = type.getExtends();
            JType boundType = (JType)_extends.accept((GenericVisitor)this, (Object)codeModel);
            if (!(boundType instanceof JClass)) {
                throw new IllegalArgumentException("Bound type [" + _extends + "]in the wildcard type must be class.");
            }
            JClass boundClass = (JClass)boundType;
            return boundClass.wildcard();
        }
        if (type.getSuper() != null) {
            throw new IllegalArgumentException("Wildcard types with super clause are not supported at the moment.");
        }
        throw new IllegalArgumentException("Wildcard type must have either extends or super clause.");
    }

    public JType visit(ClassOrInterfaceType type, JCodeModel codeModel) {
        String name = this.getName(type);
        JClass knownClass = this.knownClasses.get(name);
        JClass jclass = knownClass != null ? knownClass : codeModel.ref(name);
        List typeArgs = type.getTypeArgs();
        if (typeArgs == null || typeArgs.isEmpty()) {
            return jclass;
        }
        ArrayList<JClass> jtypeArgs = new ArrayList<JClass>(typeArgs.size());
        for (Type typeArg : typeArgs) {
            JType jtype = (JType)typeArg.accept((GenericVisitor)this, (Object)codeModel);
            if (!(jtype instanceof JClass)) {
                throw new IllegalArgumentException("Type argument [" + typeArg.toString() + "] is not a class.");
            }
            jtypeArgs.add((JClass)jtype);
        }
        return jclass.narrow(jtypeArgs);
    }

    private String getName(ClassOrInterfaceType type) {
        String name = type.getName();
        ClassOrInterfaceType scope = type.getScope();
        if (scope == null) {
            return name;
        }
        return this.getName(scope) + "." + name;
    }
}

