/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PublicKey;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.EnvUtil;
import org.keycloak.PemUtils;
import org.keycloak.RealmConfiguration;
import org.keycloak.ResourceMetadata;
import org.keycloak.adapters.config.ManagedResourceConfig;
import org.keycloak.representations.idm.PublishedRealmRepresentation;

public class ManagedResourceConfigLoader {
    protected ManagedResourceConfig remoteSkeletonKeyConfig;
    protected ResourceMetadata resourceMetadata;
    protected KeyStore clientCertKeystore;
    protected KeyStore truststore;
    protected ResteasyClient client;
    protected RealmConfiguration realmConfiguration;

    public ManagedResourceConfigLoader() {
    }

    public ManagedResourceConfigLoader(InputStream is) {
        this.loadConfig(is);
    }

    public static KeyStore loadKeyStore(String filename, String password) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File truststoreFile = new File(filename);
        FileInputStream trustStream = new FileInputStream(truststoreFile);
        trustStore.load(trustStream, password.toCharArray());
        trustStream.close();
        return trustStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean setupClient) {
        String realm;
        String truststorePath = this.remoteSkeletonKeyConfig.getTruststore();
        if (truststorePath != null) {
            truststorePath = EnvUtil.replace(truststorePath);
            String truststorePassword = this.remoteSkeletonKeyConfig.getTruststorePassword();
            truststorePath = null;
            try {
                this.truststore = ManagedResourceConfigLoader.loadKeyStore(truststorePath, truststorePassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load truststore", e);
            }
        }
        String clientKeystore = this.remoteSkeletonKeyConfig.getClientKeystore();
        String clientKeyPassword = null;
        if (clientKeystore != null) {
            clientKeystore = EnvUtil.replace(clientKeystore);
            String clientKeystorePassword = this.remoteSkeletonKeyConfig.getClientKeystorePassword();
            this.clientCertKeystore = null;
            try {
                this.clientCertKeystore = ManagedResourceConfigLoader.loadKeyStore(clientKeystore, clientKeystorePassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load keystore", e);
            }
        }
        this.initClient();
        if (this.remoteSkeletonKeyConfig.getRealmUrl() != null) {
            PublishedRealmRepresentation rep = null;
            try {
                rep = (PublishedRealmRepresentation)this.client.target(this.remoteSkeletonKeyConfig.getRealmUrl()).request().get(PublishedRealmRepresentation.class);
            }
            finally {
                if (!setupClient) {
                    this.client.close();
                }
            }
            this.remoteSkeletonKeyConfig.setRealm(rep.getRealm());
            this.remoteSkeletonKeyConfig.setAuthUrl(rep.getAuthorizationUrl());
            this.remoteSkeletonKeyConfig.setCodeUrl(rep.getCodeUrl());
            this.remoteSkeletonKeyConfig.setRealmKey(rep.getPublicKeyPem());
            this.remoteSkeletonKeyConfig.setAdminRole(rep.getAdminRole());
        }
        if (this.remoteSkeletonKeyConfig.getAdminRole() == null) {
            this.remoteSkeletonKeyConfig.setAdminRole("$REALM-ADMIN$");
        }
        if ((realm = this.remoteSkeletonKeyConfig.getRealm()) == null) {
            throw new RuntimeException("Must set 'realm' in config");
        }
        String resource = this.remoteSkeletonKeyConfig.getResource();
        if (resource == null) {
            throw new RuntimeException("Must set 'resource' in config");
        }
        String realmKeyPem = this.remoteSkeletonKeyConfig.getRealmKey();
        if (realmKeyPem == null) {
            throw new IllegalArgumentException("You must set the realm-public-key");
        }
        PublicKey realmKey = null;
        try {
            realmKey = PemUtils.decodePublicKey(realmKeyPem);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.resourceMetadata = new ResourceMetadata();
        this.resourceMetadata.setRealm(realm);
        this.resourceMetadata.setResourceName(resource);
        this.resourceMetadata.setRealmKey(realmKey);
        this.resourceMetadata.setClientKeystore(this.clientCertKeystore);
        clientKeyPassword = this.remoteSkeletonKeyConfig.getClientKeyPassword();
        this.resourceMetadata.setClientKeyPassword(clientKeyPassword);
        this.resourceMetadata.setTruststore(this.truststore);
        if (!setupClient || this.remoteSkeletonKeyConfig.isBearerOnly()) {
            return;
        }
        this.realmConfiguration = new RealmConfiguration();
        String authUrl = this.remoteSkeletonKeyConfig.getAuthUrl();
        if (authUrl == null) {
            throw new RuntimeException("You must specify auth-url");
        }
        String tokenUrl = this.remoteSkeletonKeyConfig.getCodeUrl();
        if (tokenUrl == null) {
            throw new RuntimeException("You mut specify code-url");
        }
        this.realmConfiguration.setMetadata(this.resourceMetadata);
        this.realmConfiguration.setSslRequired(!this.remoteSkeletonKeyConfig.isSslNotRequired());
        for (Map.Entry<String, String> entry : this.getRemoteSkeletonKeyConfig().getCredentials().entrySet()) {
            this.realmConfiguration.getResourceCredentials().param(entry.getKey(), entry.getValue());
        }
        ResteasyClient client = this.getClient();
        this.realmConfiguration.setClient(client);
        this.realmConfiguration.setAuthUrl(UriBuilder.fromUri((String)authUrl).queryParam("client_id", new Object[]{this.resourceMetadata.getResourceName()}));
        this.realmConfiguration.setCodeUrl(client.target(tokenUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClient() {
        int size = 10;
        if (this.remoteSkeletonKeyConfig.getConnectionPoolSize() > 0) {
            size = this.remoteSkeletonKeyConfig.getConnectionPoolSize();
        }
        ResteasyClientBuilder.HostnameVerificationPolicy policy = ResteasyClientBuilder.HostnameVerificationPolicy.WILDCARD;
        if (this.remoteSkeletonKeyConfig.isAllowAnyHostname()) {
            policy = ResteasyClientBuilder.HostnameVerificationPolicy.ANY;
        }
        ResteasyProviderFactory providerFactory = new ResteasyProviderFactory();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ManagedResourceConfigLoader.class.getClassLoader());
        try {
            ResteasyProviderFactory.getInstance();
            RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        ResteasyClientBuilder builder = new ResteasyClientBuilder().providerFactory(providerFactory).connectionPoolSize(size).hostnameVerification(policy).keyStore(this.clientCertKeystore, this.remoteSkeletonKeyConfig.getClientKeyPassword());
        if (this.remoteSkeletonKeyConfig.isDisableTrustManager()) {
            builder.disableTrustManager();
        } else {
            builder.trustStore(this.truststore);
        }
        this.client = builder.build();
    }

    public ManagedResourceConfig getRemoteSkeletonKeyConfig() {
        return this.remoteSkeletonKeyConfig;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    public ResteasyClient getClient() {
        return this.client;
    }

    public KeyStore getClientCertKeystore() {
        return this.clientCertKeystore;
    }

    public KeyStore getTruststore() {
        return this.truststore;
    }

    public RealmConfiguration getRealmConfiguration() {
        return this.realmConfiguration;
    }

    protected void loadConfig(InputStream is) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        this.remoteSkeletonKeyConfig = null;
        try {
            this.remoteSkeletonKeyConfig = (ManagedResourceConfig)mapper.readValue(is, ManagedResourceConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

