/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.keycloak.util.MultivaluedHashMap;

public class UriUtils {
    private static final Pattern originPattern = Pattern.compile("(http://|https://)[\\w-]+(\\.[\\w-]+)*(:[\\d]{2,5})?");

    public static String getOrigin(URI uri) {
        return UriUtils.getOrigin(uri.toString());
    }

    public static String getOrigin(String uri) {
        String u = uri.toString();
        int e = u.indexOf(47, 8);
        return e != -1 ? u.substring(0, u.indexOf(47, 8)) : u;
    }

    public static boolean isOrigin(String url) {
        return originPattern.matcher(url).matches();
    }

    public static MultivaluedHashMap<String, String> decodeQueryString(String queryString) {
        String[] params;
        MultivaluedHashMap<String, String> map = new MultivaluedHashMap<String, String>();
        if (queryString == null || queryString.equals("")) {
            return map;
        }
        for (String param : params = queryString.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=", 2);
                try {
                    String name = URLDecoder.decode(nv[0], "UTF-8");
                    String val = nv.length > 1 ? nv[1] : "";
                    map.add(name, URLDecoder.decode(val, "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String name = URLDecoder.decode(param, "UTF-8");
                map.add(name, "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    public static String stripQueryParam(String url, String name) {
        return url.replaceFirst("[\\?&]" + name + "=[^&]*$|" + name + "=[^&]*&", "");
    }
}

