/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.VerificationException;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.sdjwt.SdJws;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.TestSettings;

public abstract class SdJwsTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();
    static TestSettings testSettings = TestSettings.getInstance();

    private JsonNode createPayload() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("sub", "test");
        node.put("exp", Instant.now().plus(1L, ChronoUnit.HOURS).getEpochSecond());
        node.put("name", "Test User");
        return node;
    }

    @Test
    public void testVerifySignature_Positive() throws Exception {
        SdJws sdJws = new SdJws(this.createPayload(), SdJwsTest.testSettings.holderSigContext, "jwt"){};
        sdJws.verifySignature(SdJwsTest.testSettings.holderVerifierContext);
    }

    @Test
    public void testVerifySignature_WrongPublicKey() {
        SdJws sdJws = new SdJws(this.createPayload(), SdJwsTest.testSettings.holderSigContext, "jwt"){};
        Assert.assertThrows(VerificationException.class, () -> sdJws.verifySignature(SdJwsTest.testSettings.issuerVerifierContext));
    }

    @Test
    public void testVerifyExpClaim_ExpiredJWT() {
        JsonNode payload = this.createPayload();
        ((ObjectNode)payload).put("exp", Instant.now().minus(1L, ChronoUnit.HOURS).getEpochSecond());
        SdJws sdJws = new SdJws(payload){};
        Assert.assertThrows(VerificationException.class, () -> ((SdJws)sdJws).verifyExpClaim());
    }

    @Test
    public void testVerifyExpClaim_Positive() throws Exception {
        JsonNode payload = this.createPayload();
        ((ObjectNode)payload).put("exp", Instant.now().plus(1L, ChronoUnit.HOURS).getEpochSecond());
        SdJws sdJws = new SdJws(payload){};
        sdJws.verifyExpClaim();
    }

    @Test
    public void testVerifyNotBeforeClaim_Negative() {
        JsonNode payload = this.createPayload();
        ((ObjectNode)payload).put("nbf", Instant.now().plus(1L, ChronoUnit.HOURS).getEpochSecond());
        SdJws sdJws = new SdJws(payload){};
        Assert.assertThrows(VerificationException.class, () -> ((SdJws)sdJws).verifyNotBeforeClaim());
    }

    @Test
    public void testVerifyNotBeforeClaim_Positive() throws Exception {
        JsonNode payload = this.createPayload();
        ((ObjectNode)payload).put("nbf", Instant.now().minus(1L, ChronoUnit.HOURS).getEpochSecond());
        SdJws sdJws = new SdJws(payload){};
        sdJws.verifyNotBeforeClaim();
    }

    @Test
    public void testPayloadJwsConstruction() {
        SdJws sdJws = new SdJws(this.createPayload()){};
        Assert.assertNotNull((Object)sdJws.getPayload());
    }

    @Test(expected=IllegalStateException.class)
    public void testUnsignedJwsConstruction() {
        SdJws sdJws = new SdJws(this.createPayload()){};
        sdJws.toJws();
    }

    @Test
    public void testSignedJwsConstruction() {
        SdJws sdJws = new SdJws(this.createPayload(), SdJwsTest.testSettings.holderSigContext, "jwt"){};
        Assert.assertNotNull((Object)sdJws.toJws());
    }

    @Test
    public void testVerifyIssClaim_Negative() {
        List<String> allowedIssuers = Arrays.asList("issuer1@sdjwt.com", "issuer2@sdjwt.com");
        JsonNode payload = this.createPayload();
        ((ObjectNode)payload).put("iss", "unknown-issuer@sdjwt.com");
        SdJws sdJws = new SdJws(payload){};
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJws.verifyIssClaim(allowedIssuers));
        Assert.assertEquals((Object)"Unknown 'iss' claim value: unknown-issuer@sdjwt.com", (Object)exception.getMessage());
    }

    @Test
    public void testVerifyIssClaim_Positive() throws VerificationException {
        List<String> allowedIssuers = Arrays.asList("issuer1@sdjwt.com", "issuer2@sdjwt.com");
        JsonNode payload = this.createPayload();
        ((ObjectNode)payload).put("iss", "issuer1@sdjwt.com");
        SdJws sdJws = new SdJws(payload){};
        sdJws.verifyIssClaim(allowedIssuers);
    }

    @Test
    public void testVerifyVctClaim_Negative() {
        JsonNode payload = this.createPayload();
        ((ObjectNode)payload).put("vct", "IdentityCredential");
        SdJws sdJws = new SdJws(payload){};
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJws.verifyVctClaim(Collections.singletonList("PassportCredential")));
        Assert.assertEquals((Object)"Unknown 'vct' claim value: IdentityCredential", (Object)exception.getMessage());
    }

    @Test
    public void testVerifyVctClaim_Positive() throws VerificationException {
        JsonNode payload = this.createPayload();
        ((ObjectNode)payload).put("vct", "IdentityCredential");
        SdJws sdJws = new SdJws(payload){};
        sdJws.verifyVctClaim(Collections.singletonList("IdentityCredential"));
    }

    @Test
    public void shouldValidateAgeSinceIssued() throws VerificationException {
        long now = Instant.now().getEpochSecond();
        SdJws sdJws = this.exampleSdJws(now);
        sdJws.verifyAge(180);
    }

    @Test
    public void shouldValidateAgeSinceIssued_IfJwtIsTooOld() {
        long now = Instant.now().getEpochSecond();
        SdJws sdJws = this.exampleSdJws(now - 1000L);
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> sdJws.verifyAge(180));
        Assert.assertEquals((Object)"jwt is too old", (Object)exception.getMessage());
    }

    private SdJws exampleSdJws(long iat) {
        ObjectNode payload = SdJwtUtils.mapper.createObjectNode();
        payload.set("iat", SdJwtUtils.mapper.valueToTree((Object)iat));
        return new SdJws((JsonNode)payload){};
    }
}

