/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.sdjwtvp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.keycloak.common.util.Base64Url;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.vp.SdJwtVP;

public class TestCompareSdJwt {
    public static void compare(SdJwtVP expectedSdJwt, SdJwtVP actualSdJwt) {
        try {
            TestCompareSdJwt.compareIssuerSignedJWT(expectedSdJwt.getIssuerSignedJWT(), actualSdJwt.getIssuerSignedJWT());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        TestCompareSdJwt.compareDisclosures(expectedSdJwt, actualSdJwt);
    }

    private static void compareIssuerSignedJWT(IssuerSignedJWT e, IssuerSignedJWT a) throws JsonMappingException, JsonProcessingException {
        Assert.assertEquals((Object)e.getPayload(), (Object)a.getPayload());
        List<String> expectedJwsStrings = Arrays.asList(e.toJws().split("\\."));
        List<String> actualJwsStrings = Arrays.asList(a.toJws().split("\\."));
        Assert.assertEquals((Object)TestCompareSdJwt.toJsonNode(expectedJwsStrings.get(0)), (Object)TestCompareSdJwt.toJsonNode(actualJwsStrings.get(0)));
        Assert.assertEquals((Object)TestCompareSdJwt.toJsonNode(expectedJwsStrings.get(1)), (Object)TestCompareSdJwt.toJsonNode(actualJwsStrings.get(1)));
    }

    private static void compareDisclosures(SdJwtVP expectedSdJwt, SdJwtVP actualSdJwt) {
        Set expectedDisclosures = expectedSdJwt.getDisclosuresString().stream().map(TestCompareSdJwt::toJsonNode).collect(Collectors.toSet());
        Set actualDisclosures = actualSdJwt.getDisclosuresString().stream().map(TestCompareSdJwt::toJsonNode).collect(Collectors.toSet());
        Assert.assertEquals((long)expectedDisclosures.size(), (long)actualDisclosures.size());
        boolean foundEqualPair = false;
        block0: for (JsonNode a : expectedDisclosures) {
            for (JsonNode b : actualDisclosures) {
                if (!a.equals((Object)b)) continue;
                foundEqualPair = true;
                continue block0;
            }
        }
        Assert.assertTrue((String)"The set should contain equal elements", (boolean)foundEqualPair);
    }

    private static JsonNode toJsonNode(String base64EncodedString) {
        try {
            return SdJwtUtils.mapper.readTree(Base64Url.decode((String)base64EncodedString));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

