/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.io.IOException;
import java.security.PublicKey;
import java.util.List;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.PasswordToken;
import org.keycloak.util.Time;

public class CredentialValidation {
    private static int hashIterations(RealmModel realm) {
        PasswordPolicy policy = realm.getPasswordPolicy();
        if (policy != null) {
            return policy.getHashIterations();
        }
        return -1;
    }

    public static boolean validPassword(RealmModel realm, UserModel user, String password) {
        UserCredentialValueModel passwordCred = null;
        for (UserCredentialValueModel cred : user.getCredentialsDirectly()) {
            if (!cred.getType().equals("password")) continue;
            passwordCred = cred;
        }
        if (passwordCred == null) {
            return false;
        }
        return CredentialValidation.validateHashedCredential(realm, user, password, passwordCred);
    }

    public static boolean validateHashedCredential(RealmModel realm, UserModel user, String unhashedCredValue, UserCredentialValueModel credential) {
        int iterations;
        boolean validated = new Pbkdf2PasswordEncoder(credential.getSalt()).verify(unhashedCredValue, credential.getValue(), credential.getHashIterations());
        if (validated && (iterations = CredentialValidation.hashIterations(realm)) > -1 && iterations != credential.getHashIterations()) {
            UserCredentialValueModel newCred = new UserCredentialValueModel();
            newCred.setType(credential.getType());
            newCred.setDevice(credential.getDevice());
            newCred.setSalt(credential.getSalt());
            newCred.setHashIterations(iterations);
            newCred.setValue(new Pbkdf2PasswordEncoder(newCred.getSalt()).encode(unhashedCredValue, iterations));
            user.updateCredentialDirectly(newCred);
        }
        return validated;
    }

    public static boolean validPasswordToken(RealmModel realm, UserModel user, String encodedPasswordToken) {
        JWSInput jws = new JWSInput(encodedPasswordToken);
        if (!RSAProvider.verify((JWSInput)jws, (PublicKey)realm.getPublicKey())) {
            return false;
        }
        try {
            PasswordToken passwordToken = (PasswordToken)jws.readJsonContent(PasswordToken.class);
            if (!passwordToken.getRealm().equals(realm.getName())) {
                return false;
            }
            if (!passwordToken.getUser().equals(user.getId())) {
                return false;
            }
            return Time.currentTime() - passwordToken.getTimestamp() <= realm.getAccessCodeLifespanUserAction();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean validHOTP(RealmModel realm, UserModel user, String otp) {
        Object passwordCred = null;
        OTPPolicy policy = realm.getOTPPolicy();
        HmacOTP validator = new HmacOTP(policy.getDigits(), policy.getAlgorithm(), policy.getLookAheadWindow());
        for (UserCredentialValueModel cred : user.getCredentialsDirectly()) {
            if (!cred.getType().equals("hotp")) continue;
            int counter = validator.validateHOTP(otp, cred.getValue(), cred.getCounter());
            if (counter < 0) {
                return false;
            }
            cred.setCounter(counter);
            user.updateCredentialDirectly(cred);
            return true;
        }
        return false;
    }

    public static boolean validOTP(RealmModel realm, String token, String secret) {
        OTPPolicy policy = realm.getOTPPolicy();
        if (policy.getType().equals("totp")) {
            TimeBasedOTP validator = new TimeBasedOTP(policy.getAlgorithm(), policy.getDigits(), policy.getPeriod(), policy.getLookAheadWindow());
            return validator.validateTOTP(token, secret.getBytes());
        }
        HmacOTP validator = new HmacOTP(policy.getDigits(), policy.getAlgorithm(), policy.getLookAheadWindow());
        int c = validator.validateHOTP(token, secret, policy.getInitialCounter());
        return c > -1;
    }

    public static boolean validTOTP(RealmModel realm, UserModel user, String otp) {
        Object passwordCred = null;
        OTPPolicy policy = realm.getOTPPolicy();
        TimeBasedOTP validator = new TimeBasedOTP(policy.getAlgorithm(), policy.getDigits(), policy.getPeriod(), policy.getLookAheadWindow());
        for (UserCredentialValueModel cred : user.getCredentialsDirectly()) {
            if (!cred.getType().equals("totp") || !validator.validateTOTP(otp, cred.getValue().getBytes())) continue;
            return true;
        }
        return false;
    }

    public static boolean validSecret(RealmModel realm, UserModel user, String secret) {
        for (UserCredentialValueModel cred : user.getCredentialsDirectly()) {
            if (!cred.getType().equals("secret") || !cred.getValue().equals(secret)) continue;
            return true;
        }
        return false;
    }

    public static boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> credentials) {
        for (UserCredentialModel credential : credentials) {
            if (CredentialValidation.validCredential(realm, user, credential)) continue;
            return false;
        }
        return true;
    }

    public static boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... credentials) {
        for (UserCredentialModel credential : credentials) {
            if (CredentialValidation.validCredential(realm, user, credential)) continue;
            return false;
        }
        return true;
    }

    private static boolean validCredential(RealmModel realm, UserModel user, UserCredentialModel credential) {
        if (credential.getType().equals("password")) {
            if (!CredentialValidation.validPassword(realm, user, credential.getValue())) {
                return false;
            }
        } else if (credential.getType().equals("password-token")) {
            if (!CredentialValidation.validPasswordToken(realm, user, credential.getValue())) {
                return false;
            }
        } else if (credential.getType().equals("totp")) {
            if (!CredentialValidation.validTOTP(realm, user, credential.getValue())) {
                return false;
            }
        } else if (credential.getType().equals("hotp")) {
            if (!CredentialValidation.validHOTP(realm, user, credential.getValue())) {
                return false;
            }
        } else if (credential.getType().equals("secret")) {
            if (!CredentialValidation.validSecret(realm, user, credential.getValue())) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

