/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CachedObject;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.cache.infinispan.ClearCacheEvent;
import org.keycloak.models.cache.infinispan.UserAdapter;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.entities.CachedFederatedIdentityLinks;
import org.keycloak.models.cache.infinispan.entities.CachedUser;
import org.keycloak.models.cache.infinispan.entities.CachedUserConsent;
import org.keycloak.models.cache.infinispan.entities.CachedUserConsents;
import org.keycloak.models.cache.infinispan.entities.UserListQuery;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheRealmInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserConsentsUpdatedEvent;
import org.keycloak.models.cache.infinispan.events.UserFederationLinkRemovedEvent;
import org.keycloak.models.cache.infinispan.events.UserFederationLinkUpdatedEvent;
import org.keycloak.models.cache.infinispan.events.UserFullInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserUpdatedEvent;
import org.keycloak.models.cache.infinispan.stream.InIdentityProviderPredicate;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ReadOnlyUserModelDelegate;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.client.ClientStorageProvider;

public class UserCacheSession
implements UserCache.Streams {
    protected static final Logger logger = Logger.getLogger(UserCacheSession.class);
    protected UserCacheManager cache;
    protected KeycloakSession session;
    protected UserProvider delegate;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected final long startupRevision;
    protected Set<String> invalidations = new HashSet<String>();
    protected Set<String> realmInvalidations = new HashSet<String>();
    protected Set<InvalidationEvent> invalidationEvents = new HashSet<InvalidationEvent>();
    protected Map<String, UserModel> managedUsers = new HashMap<String, UserModel>();

    public UserCacheSession(UserCacheManager cache, KeycloakSession session) {
        this.cache = cache;
        this.session = session;
        this.startupRevision = cache.getCurrentCounter();
        session.getTransactionManager().enlistAfterCompletion(this.getTransaction());
    }

    public void clear() {
        this.cache.clear();
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify("USER_CLEAR_CACHE_EVENTS", (ClusterEvent)new ClearCacheEvent(), true, ClusterProvider.DCNotify.ALL_DCS);
    }

    public UserProvider getDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = this.session.userStorageManager();
        return this.delegate;
    }

    public void registerUserInvalidation(RealmModel realm, CachedUser user) {
        this.cache.userUpdatedInvalidations(user.getId(), user.getUsername(), user.getEmail(), user.getRealm(), this.invalidations);
        this.invalidationEvents.add(UserUpdatedEvent.create(user.getId(), user.getUsername(), user.getEmail(), user.getRealm()));
    }

    public void evict(RealmModel realm, UserModel user) {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot call evict() without a transaction");
        }
        this.getDelegate();
        if (user instanceof CachedUserModel) {
            ((CachedUserModel)user).invalidate();
        } else {
            this.cache.userUpdatedInvalidations(user.getId(), user.getUsername(), user.getEmail(), realm.getId(), this.invalidations);
            this.invalidationEvents.add(UserUpdatedEvent.create(user.getId(), user.getUsername(), user.getEmail(), realm.getId()));
        }
    }

    public void evict(RealmModel realm) {
        this.addRealmInvalidation(realm.getId());
    }

    protected void runInvalidations() {
        for (String realmId : this.realmInvalidations) {
            this.cache.invalidateRealmUsers(realmId, this.invalidations);
        }
        for (String invalidation : this.invalidations) {
            this.cache.invalidateObject(invalidation);
        }
        this.cache.sendInvalidationEvents(this.session, this.invalidationEvents, "USER_INVALIDATION_EVENTS");
    }

    private KeycloakTransaction getTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                UserCacheSession.this.transactionActive = true;
            }

            public void commit() {
                UserCacheSession.this.runInvalidations();
                UserCacheSession.this.transactionActive = false;
            }

            public void rollback() {
                UserCacheSession.this.setRollbackOnly = true;
                UserCacheSession.this.runInvalidations();
                UserCacheSession.this.transactionActive = false;
            }

            public void setRollbackOnly() {
                UserCacheSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return UserCacheSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return UserCacheSession.this.transactionActive;
            }
        };
    }

    private boolean isRegisteredForInvalidation(RealmModel realm, String userId) {
        return this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(userId);
    }

    public UserModel getUserById(String id, RealmModel realm) {
        logger.tracev("getuserById {0}", (Object)id);
        if (this.isRegisteredForInvalidation(realm, id)) {
            logger.trace((Object)"registered for invalidation return delegate");
            return this.getDelegate().getUserById(id, realm);
        }
        if (this.managedUsers.containsKey(id)) {
            logger.trace((Object)"return managedusers");
            return this.managedUsers.get(id);
        }
        CachedUser cached = this.cache.get(id, CachedUser.class);
        if (cached != null && !cached.getRealm().equals(realm.getId())) {
            cached = null;
        }
        UserModel adapter = null;
        if (cached == null) {
            logger.trace((Object)"not cached");
            Long loaded = this.cache.getCurrentRevision(id);
            UserModel delegate = this.getDelegate().getUserById(id, realm);
            if (delegate == null) {
                logger.trace((Object)"delegate returning null");
                return null;
            }
            adapter = this.cacheUser(realm, delegate, loaded);
        } else {
            adapter = this.validateCache(realm, cached);
        }
        this.managedUsers.put(id, adapter);
        return adapter;
    }

    static String getUserByUsernameCacheKey(String realmId, String username) {
        return realmId + ".username." + username;
    }

    static String getUserByEmailCacheKey(String realmId, String email) {
        return realmId + ".email." + email;
    }

    private static String getUserByFederatedIdentityCacheKey(String realmId, FederatedIdentityModel socialLink) {
        return UserCacheSession.getUserByFederatedIdentityCacheKey(realmId, socialLink.getIdentityProvider(), socialLink.getUserId());
    }

    static String getUserByFederatedIdentityCacheKey(String realmId, String identityProvider, String socialUserId) {
        return realmId + ".idp." + identityProvider + "." + socialUserId;
    }

    static String getFederatedIdentityLinksCacheKey(String userId) {
        return userId + ".idplinks";
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        logger.tracev("getUserByUsername: {0}", (Object)username);
        username = username.toLowerCase();
        if (this.realmInvalidations.contains(realm.getId())) {
            logger.tracev("realmInvalidations", new Object[0]);
            return this.getDelegate().getUserByUsername(username, realm);
        }
        String cacheKey = UserCacheSession.getUserByUsernameCacheKey(realm.getId(), username);
        if (this.invalidations.contains(cacheKey)) {
            logger.tracev("invalidations", new Object[0]);
            return this.getDelegate().getUserByUsername(username, realm);
        }
        UserListQuery query = this.cache.get(cacheKey, UserListQuery.class);
        String userId = null;
        if (query == null) {
            logger.tracev("query null", new Object[0]);
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            UserModel model = this.getDelegate().getUserByUsername(username, realm);
            if (model == null) {
                logger.tracev("model from delegate null", new Object[0]);
                return null;
            }
            userId = model.getId();
            if (this.invalidations.contains(userId)) {
                return model;
            }
            if (this.managedUsers.containsKey(userId)) {
                logger.tracev("return managed user", new Object[0]);
                return this.managedUsers.get(userId);
            }
            UserModel adapter = this.getUserAdapter(realm, userId, loaded, model);
            if (adapter instanceof UserAdapter) {
                query = new UserListQuery(loaded, cacheKey, realm, model.getId());
                this.cache.addRevisioned(query, this.startupRevision);
            }
            this.managedUsers.put(userId, adapter);
            return adapter;
        }
        userId = query.getUsers().iterator().next();
        if (this.invalidations.contains(userId)) {
            logger.tracev("invalidated cache return delegate", new Object[0]);
            return this.getDelegate().getUserByUsername(username, realm);
        }
        logger.trace((Object)"return getUserById");
        return this.getUserById(userId, realm);
    }

    protected UserModel getUserAdapter(RealmModel realm, String userId, Long loaded, UserModel delegate) {
        CachedUser cached = this.cache.get(userId, CachedUser.class);
        if (cached == null) {
            return this.cacheUser(realm, delegate, loaded);
        }
        return this.validateCache(realm, cached);
    }

    protected UserModel validateCache(RealmModel realm, CachedUser cached) {
        ComponentModel component;
        CacheableStorageProviderModel model;
        StorageId storageId;
        if (!realm.getId().equals(cached.getRealm())) {
            return null;
        }
        StorageId storageId2 = storageId = cached.getFederationLink() != null ? new StorageId(cached.getFederationLink(), cached.getId()) : new StorageId(cached.getId());
        if (!storageId.isLocal() && (model = new CacheableStorageProviderModel(component = realm.getComponent(storageId.getProviderId()))).shouldInvalidate((CachedObject)cached)) {
            this.registerUserInvalidation(realm, cached);
            return this.getDelegate().getUserById(cached.getId(), realm);
        }
        return new UserAdapter(cached, this, this.session, realm);
    }

    protected UserModel cacheUser(RealmModel realm, UserModel delegate, Long revision) {
        int notBefore = this.getDelegate().getNotBeforeOfUser(realm, delegate);
        StorageId storageId = delegate.getFederationLink() != null ? new StorageId(delegate.getFederationLink(), delegate.getId()) : new StorageId(delegate.getId());
        CachedUser cached = null;
        UserAdapter adapter = null;
        if (!storageId.isLocal()) {
            ComponentModel component = realm.getComponent(storageId.getProviderId());
            UserStorageProviderModel model = new UserStorageProviderModel(component);
            if (!model.isEnabled()) {
                return new ReadOnlyUserModelDelegate(delegate){

                    public boolean isEnabled() {
                        return false;
                    }
                };
            }
            CacheableStorageProviderModel.CachePolicy policy = model.getCachePolicy();
            if (policy != null && policy == CacheableStorageProviderModel.CachePolicy.NO_CACHE) {
                return delegate;
            }
            cached = new CachedUser(revision, realm, delegate, notBefore);
            adapter = new UserAdapter(cached, this, this.session, realm);
            this.onCache(realm, adapter, delegate);
            long lifespan = model.getLifespan();
            if (lifespan > 0L) {
                this.cache.addRevisioned(cached, this.startupRevision, lifespan);
            } else {
                this.cache.addRevisioned(cached, this.startupRevision);
            }
        } else {
            cached = new CachedUser(revision, realm, delegate, notBefore);
            adapter = new UserAdapter(cached, this, this.session, realm);
            this.onCache(realm, adapter, delegate);
            this.cache.addRevisioned(cached, this.startupRevision);
        }
        return adapter;
    }

    private void onCache(RealmModel realm, UserAdapter adapter, UserModel delegate) {
        ((OnUserCache)this.getDelegate()).onCache(realm, (CachedUserModel)adapter, delegate);
        ((OnUserCache)this.session.userCredentialManager()).onCache(realm, (CachedUserModel)adapter, delegate);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        if (email == null) {
            return null;
        }
        email = email.toLowerCase();
        if (this.realmInvalidations.contains(realm.getId())) {
            return this.getDelegate().getUserByEmail(email, realm);
        }
        String cacheKey = UserCacheSession.getUserByEmailCacheKey(realm.getId(), email);
        if (this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getUserByEmail(email, realm);
        }
        UserListQuery query = this.cache.get(cacheKey, UserListQuery.class);
        String userId = null;
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            UserModel model = this.getDelegate().getUserByEmail(email, realm);
            if (model == null) {
                return null;
            }
            userId = model.getId();
            if (this.invalidations.contains(userId)) {
                return model;
            }
            if (this.managedUsers.containsKey(userId)) {
                return this.managedUsers.get(userId);
            }
            UserModel adapter = this.getUserAdapter(realm, userId, loaded, model);
            if (adapter instanceof UserAdapter) {
                query = new UserListQuery(loaded, cacheKey, realm, model.getId());
                this.cache.addRevisioned(query, this.startupRevision);
            }
            this.managedUsers.put(userId, adapter);
            return adapter;
        }
        userId = query.getUsers().iterator().next();
        if (this.invalidations.contains(userId)) {
            return this.getDelegate().getUserByEmail(email, realm);
        }
        return this.getUserById(userId, realm);
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        if (socialLink == null) {
            return null;
        }
        if (!realm.isIdentityFederationEnabled()) {
            return null;
        }
        if (this.realmInvalidations.contains(realm.getId())) {
            return this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
        }
        String cacheKey = UserCacheSession.getUserByFederatedIdentityCacheKey(realm.getId(), socialLink);
        if (this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
        }
        UserListQuery query = this.cache.get(cacheKey, UserListQuery.class);
        String userId = null;
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            UserModel model = this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
            if (model == null) {
                return null;
            }
            userId = model.getId();
            if (this.invalidations.contains(userId)) {
                return model;
            }
            if (this.managedUsers.containsKey(userId)) {
                return this.managedUsers.get(userId);
            }
            UserModel adapter = this.getUserAdapter(realm, userId, loaded, model);
            if (adapter instanceof UserAdapter) {
                query = new UserListQuery(loaded, cacheKey, realm, model.getId());
                this.cache.addRevisioned(query, this.startupRevision);
            }
            this.managedUsers.put(userId, adapter);
            return adapter;
        }
        userId = query.getUsers().iterator().next();
        if (this.invalidations.contains(userId)) {
            this.invalidations.add(cacheKey);
            return this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
        }
        return this.getUserById(userId, realm);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        return this.getDelegate().getGroupMembersStream(realm, group, firstResult, maxResults);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
        return this.getDelegate().getGroupMembersStream(realm, group);
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        return this.getDelegate().getRoleMembersStream(realm, role, firstResult, maxResults);
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role) {
        return this.getDelegate().getRoleMembersStream(realm, role);
    }

    public UserModel getServiceAccount(ClientModel client) {
        UserModel user = this.findServiceAccount(client);
        if (user != null && user.getServiceAccountClientLink() != null && user.getServiceAccountClientLink().equals(client.getId())) {
            return user;
        }
        return this.getDelegate().getServiceAccount(client);
    }

    public UserModel findServiceAccount(ClientModel client) {
        String username = "service-account-" + client.getClientId();
        logger.tracev("getServiceAccount: {0}", (Object)username);
        username = username.toLowerCase();
        RealmModel realm = client.getRealm();
        if (this.realmInvalidations.contains(realm.getId())) {
            logger.tracev("realmInvalidations", new Object[0]);
            return this.getDelegate().getServiceAccount(client);
        }
        String cacheKey = UserCacheSession.getUserByUsernameCacheKey(realm.getId(), username);
        if (this.invalidations.contains(cacheKey)) {
            logger.tracev("invalidations", new Object[0]);
            return this.getDelegate().getServiceAccount(client);
        }
        UserListQuery query = this.cache.get(cacheKey, UserListQuery.class);
        String userId = null;
        if (query == null) {
            logger.tracev("query null", new Object[0]);
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            UserModel model = this.getDelegate().getServiceAccount(client);
            if (model == null) {
                logger.tracev("model from delegate null", new Object[0]);
                return null;
            }
            userId = model.getId();
            if (this.invalidations.contains(userId)) {
                return model;
            }
            if (this.managedUsers.containsKey(userId)) {
                logger.tracev("return managed user", new Object[0]);
                return this.managedUsers.get(userId);
            }
            UserModel adapter = this.getUserAdapter(realm, userId, loaded, model);
            if (adapter instanceof UserAdapter) {
                query = new UserListQuery(loaded, cacheKey, realm, model.getId());
                this.cache.addRevisioned(query, this.startupRevision);
            }
            this.managedUsers.put(userId, adapter);
            return adapter;
        }
        userId = query.getUsers().iterator().next();
        if (this.invalidations.contains(userId)) {
            logger.tracev("invalidated cache return delegate", new Object[0]);
            return this.getDelegate().getUserByUsername(username, realm);
        }
        logger.trace((Object)"return getUserById");
        return this.getUserById(userId, realm);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, boolean includeServiceAccounts) {
        return this.getDelegate().getUsersStream(realm, includeServiceAccounts);
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        return this.getDelegate().getUsersCount(realm, includeServiceAccount);
    }

    public int getUsersCount(RealmModel realm) {
        return this.getUsersCount(realm, false);
    }

    public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        return this.getDelegate().getUsersCount(realm, groupIds);
    }

    public int getUsersCount(String search, RealmModel realm) {
        return this.getDelegate().getUsersCount(search, realm);
    }

    public int getUsersCount(String search, RealmModel realm, Set<String> groupIds) {
        return this.getDelegate().getUsersCount(search, realm, groupIds);
    }

    public int getUsersCount(Map<String, String> params, RealmModel realm) {
        return this.getDelegate().getUsersCount(params, realm);
    }

    public int getUsersCount(Map<String, String> params, RealmModel realm, Set<String> groupIds) {
        return this.getDelegate().getUsersCount(params, realm, groupIds);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults, boolean includeServiceAccounts) {
        return this.getDelegate().getUsersStream(realm, firstResult, maxResults, includeServiceAccounts);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm) {
        return this.getUsersStream(realm, false);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, int firstResult, int maxResults) {
        return this.getUsersStream(realm, firstResult, maxResults, false);
    }

    public Stream<UserModel> searchForUserStream(String search, RealmModel realm) {
        return this.getDelegate().searchForUserStream(search, realm);
    }

    public Stream<UserModel> searchForUserStream(String search, RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.getDelegate().searchForUserStream(search, realm, firstResult, maxResults);
    }

    public Stream<UserModel> searchForUserStream(Map<String, String> attributes, RealmModel realm) {
        return this.getDelegate().searchForUserStream(attributes, realm);
    }

    public Stream<UserModel> searchForUserStream(Map<String, String> attributes, RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.getDelegate().searchForUserStream(attributes, realm, firstResult, maxResults);
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(String attrName, String attrValue, RealmModel realm) {
        return this.getDelegate().searchForUserByUserAttributeStream(attrName, attrValue, realm);
    }

    public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(UserModel user, RealmModel realm) {
        logger.tracev("getFederatedIdentities: {0}", (Object)user.getUsername());
        String cacheKey = UserCacheSession.getFederatedIdentityLinksCacheKey(user.getId());
        if (this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(user.getId()) || this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getFederatedIdentitiesStream(user, realm);
        }
        CachedFederatedIdentityLinks cachedLinks = this.cache.get(cacheKey, CachedFederatedIdentityLinks.class);
        if (cachedLinks == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            Set<FederatedIdentityModel> federatedIdentities = this.getDelegate().getFederatedIdentitiesStream(user, realm).collect(Collectors.toSet());
            cachedLinks = new CachedFederatedIdentityLinks(loaded, cacheKey, realm, federatedIdentities);
            this.cache.addRevisioned(cachedLinks, this.startupRevision);
            return federatedIdentities.stream();
        }
        return cachedLinks.getFederatedIdentities().stream();
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        logger.tracev("getFederatedIdentity: {0} {1}", (Object)user.getUsername(), (Object)socialProvider);
        String cacheKey = UserCacheSession.getFederatedIdentityLinksCacheKey(user.getId());
        if (this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(user.getId()) || this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getFederatedIdentity(user, socialProvider, realm);
        }
        return this.getFederatedIdentitiesStream(user, realm).filter(socialLink -> Objects.equals(socialLink.getIdentityProvider(), socialProvider)).findFirst().orElse(null);
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.invalidateConsent(userId);
        this.getDelegate().updateConsent(realm, userId, consent);
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        this.invalidateConsent(userId);
        return this.getDelegate().revokeConsentForClient(realm, userId, clientInternalId);
    }

    static String getConsentCacheKey(String userId) {
        return userId + ".consents";
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.invalidateConsent(userId);
        this.getDelegate().addConsent(realm, userId, consent);
    }

    private void invalidateConsent(String userId) {
        this.cache.consentInvalidation(userId, this.invalidations);
        this.invalidationEvents.add(UserConsentsUpdatedEvent.create(userId));
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientId) {
        CachedUserConsent cachedConsent;
        logger.tracev("getConsentByClient: {0}", (Object)userId);
        String cacheKey = UserCacheSession.getConsentCacheKey(userId);
        if (this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(userId) || this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getConsentByClient(realm, userId, clientId);
        }
        CachedUserConsents cached = this.cache.get(cacheKey, CachedUserConsents.class);
        if (cached == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            List<UserConsentModel> consents = this.getDelegate().getConsentsStream(realm, userId).collect(Collectors.toList());
            cached = new CachedUserConsents(loaded, cacheKey, realm, consents);
            this.cache.addRevisioned(cached, this.startupRevision);
        }
        if ((cachedConsent = cached.getConsents().get(clientId)) == null) {
            return null;
        }
        return this.toConsentModel(realm, cachedConsent);
    }

    public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        logger.tracev("getConsents: {0}", (Object)userId);
        String cacheKey = UserCacheSession.getConsentCacheKey(userId);
        if (this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(userId) || this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getConsentsStream(realm, userId);
        }
        CachedUserConsents cached = this.cache.get(cacheKey, CachedUserConsents.class);
        if (cached == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            List<UserConsentModel> consents = this.getDelegate().getConsentsStream(realm, userId).collect(Collectors.toList());
            cached = new CachedUserConsents(loaded, cacheKey, realm, consents);
            this.cache.addRevisioned(cached, this.startupRevision);
            return consents.stream();
        }
        return cached.getConsents().values().stream().map(cachedConsent -> this.toConsentModel(realm, (CachedUserConsent)cachedConsent)).filter(Objects::nonNull);
    }

    private UserConsentModel toConsentModel(RealmModel realm, CachedUserConsent cachedConsent) {
        ClientModel client = this.session.clients().getClientById(realm, cachedConsent.getClientDbId());
        if (client == null) {
            return null;
        }
        UserConsentModel consentModel = new UserConsentModel(client);
        consentModel.setCreatedDate(cachedConsent.getCreatedDate());
        consentModel.setLastUpdatedDate(cachedConsent.getLastUpdatedDate());
        for (String clientScopeId : cachedConsent.getClientScopeIds()) {
            ClientScopeModel clientScope = KeycloakModelUtils.findClientScopeById((RealmModel)realm, (ClientModel)client, (String)clientScopeId);
            if (clientScope == null) continue;
            consentModel.addGrantedClientScope(clientScope);
        }
        return consentModel;
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        UserModel foundUser;
        if (!this.isRegisteredForInvalidation(realm, user.getId()) && (foundUser = this.getUserById(user.getId(), realm)) instanceof UserAdapter) {
            ((UserAdapter)foundUser).invalidate();
        }
        this.getDelegate().setNotBeforeForUser(realm, user, notBefore);
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        if (this.isRegisteredForInvalidation(realm, user.getId())) {
            return this.getDelegate().getNotBeforeOfUser(realm, user);
        }
        UserModel foundUser = this.getUserById(user.getId(), realm);
        if (foundUser instanceof UserAdapter) {
            return ((UserAdapter)foundUser).cached.getNotBefore();
        }
        return this.getDelegate().getNotBeforeOfUser(realm, user);
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        UserModel user = this.getDelegate().addUser(realm, id, username, addDefaultRoles, addDefaultRoles);
        this.fullyInvalidateUser(realm, user);
        this.managedUsers.put(user.getId(), user);
        return user;
    }

    public UserModel addUser(RealmModel realm, String username) {
        UserModel user = this.getDelegate().addUser(realm, username);
        this.fullyInvalidateUser(realm, user);
        this.managedUsers.put(user.getId(), user);
        return user;
    }

    protected void fullyInvalidateUser(RealmModel realm, UserModel user) {
        Stream<FederatedIdentityModel> federatedIdentities = realm.isIdentityFederationEnabled() ? this.getFederatedIdentitiesStream(user, realm) : Stream.empty();
        UserFullInvalidationEvent event = UserFullInvalidationEvent.create(user.getId(), user.getUsername(), user.getEmail(), realm.getId(), realm.isIdentityFederationEnabled(), federatedIdentities);
        this.cache.fullUserInvalidation(user.getId(), user.getUsername(), user.getEmail(), realm.getId(), realm.isIdentityFederationEnabled(), event.getFederatedIdentities(), this.invalidations);
        this.invalidationEvents.add(event);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        this.fullyInvalidateUser(realm, user);
        return this.getDelegate().removeUser(realm, user);
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        this.invalidateFederationLink(user.getId());
        this.getDelegate().addFederatedIdentity(realm, user, socialLink);
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        this.invalidateFederationLink(federatedUser.getId());
        this.getDelegate().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
    }

    private void invalidateFederationLink(String userId) {
        this.cache.federatedIdentityLinkUpdatedInvalidation(userId, this.invalidations);
        this.invalidationEvents.add(UserFederationLinkUpdatedEvent.create(userId));
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        FederatedIdentityModel socialLink = this.getFederatedIdentity(user, socialProvider, realm);
        UserFederationLinkRemovedEvent event = UserFederationLinkRemovedEvent.create(user.getId(), realm.getId(), socialLink);
        this.cache.federatedIdentityLinkRemovedInvalidation(user.getId(), realm.getId(), event.getIdentityProviderId(), event.getSocialUserId(), this.invalidations);
        this.invalidationEvents.add(event);
        return this.getDelegate().removeFederatedIdentity(realm, user, socialProvider);
    }

    public void preRemove(RealmModel realm, IdentityProviderModel provider) {
        this.cache.addInvalidations(InIdentityProviderPredicate.create().provider(provider.getAlias()), this.invalidations);
        this.getDelegate().preRemove(realm, provider);
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        this.addRealmInvalidation(realm.getId());
        this.getDelegate().grantToAllUsers(realm, role);
    }

    public void preRemove(RealmModel realm) {
        this.addRealmInvalidation(realm.getId());
        this.getDelegate().preRemove(realm);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.addRealmInvalidation(realm.getId());
        this.getDelegate().preRemove(realm, role);
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.addRealmInvalidation(realm.getId());
        this.getDelegate().preRemove(realm, group);
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.addRealmInvalidation(realm.getId());
        this.getDelegate().preRemove(realm, client);
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.getDelegate().preRemove(protocolMapper);
    }

    public void preRemove(ClientScopeModel clientScope) {
        this.getDelegate().preRemove(clientScope);
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        if (!component.getProviderType().equals(UserStorageProvider.class.getName()) && !component.getProviderType().equals(ClientStorageProvider.class.getName())) {
            return;
        }
        this.addRealmInvalidation(realm.getId());
        this.getDelegate().preRemove(realm, component);
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        this.getDelegate().removeImportedUsers(realm, storageProviderId);
        this.clear();
        this.addRealmInvalidation(realm.getId());
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        this.getDelegate().unlinkUsers(realm, storageProviderId);
        this.clear();
        this.addRealmInvalidation(realm.getId());
    }

    private void addRealmInvalidation(String realmId) {
        this.realmInvalidations.add(realmId);
        this.invalidationEvents.add(UserCacheRealmInvalidationEvent.create(realmId));
    }
}

