/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.models.KeycloakTransaction;

public class InfinispanKeycloakTransaction
implements KeycloakTransaction {
    private static final Logger log = Logger.getLogger(InfinispanKeycloakTransaction.class);
    private boolean active;
    private boolean rollback;
    private final Map<Object, CacheTask> tasks = new LinkedHashMap<Object, CacheTask>();

    public void begin() {
        this.active = true;
    }

    public void commit() {
        if (this.rollback) {
            throw new RuntimeException("Rollback only!");
        }
        this.tasks.values().forEach(CacheTask::execute);
    }

    public void rollback() {
        this.tasks.clear();
    }

    public void setRollbackOnly() {
        this.rollback = true;
    }

    public boolean getRollbackOnly() {
        return this.rollback;
    }

    public boolean isActive() {
        return this.active;
    }

    public <K, V> void put(final Cache<K, V> cache, final K key, V value) {
        log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.ADD, key);
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        if (this.tasks.containsKey(taskKey)) {
            throw new IllegalStateException("Can't add session: task in progress for session");
        }
        this.tasks.put(taskKey, new CacheTaskWithValue<V>(value){

            @Override
            public void execute() {
                InfinispanKeycloakTransaction.decorateCache(cache).put(key, this.value);
            }

            public String toString() {
                return String.format("CacheTaskWithValue: Operation 'put' for key %s", key);
            }
        });
    }

    public <K, V> void put(final Cache<K, V> cache, final K key, V value, final long lifespan, final TimeUnit lifespanUnit) {
        log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.ADD_WITH_LIFESPAN, key);
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        if (this.tasks.containsKey(taskKey)) {
            throw new IllegalStateException("Can't add session: task in progress for session");
        }
        this.tasks.put(taskKey, new CacheTaskWithValue<V>(value){

            @Override
            public void execute() {
                InfinispanKeycloakTransaction.decorateCache(cache).put(key, this.value, lifespan, lifespanUnit);
            }

            public String toString() {
                return String.format("CacheTaskWithValue: Operation 'put' for key %s, lifespan %d TimeUnit %s", new Object[]{key, lifespan, lifespanUnit});
            }
        });
    }

    public <K, V> void putIfAbsent(final Cache<K, V> cache, final K key, V value) {
        log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.ADD_IF_ABSENT, key);
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        if (this.tasks.containsKey(taskKey)) {
            throw new IllegalStateException("Can't add session: task in progress for session");
        }
        this.tasks.put(taskKey, new CacheTaskWithValue<V>(value){

            @Override
            public void execute() {
                Object existing = cache.putIfAbsent(key, this.value);
                if (existing != null) {
                    throw new IllegalStateException("There is already existing value in cache for key " + key);
                }
            }

            public String toString() {
                return String.format("CacheTaskWithValue: Operation 'putIfAbsent' for key %s", key);
            }
        });
    }

    public <K, V> void replace(final Cache<K, V> cache, final K key, V value, final long lifespan, final TimeUnit lifespanUnit) {
        log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REPLACE, key);
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        CacheTask current = this.tasks.get(taskKey);
        if (current != null) {
            if (current instanceof CacheTaskWithValue) {
                ((CacheTaskWithValue)current).setValue(value);
            }
        } else {
            this.tasks.put(taskKey, new CacheTaskWithValue<V>(value){

                @Override
                public void execute() {
                    InfinispanKeycloakTransaction.decorateCache(cache).replace(key, this.value, lifespan, lifespanUnit);
                }

                public String toString() {
                    return String.format("CacheTaskWithValue: Operation 'replace' for key %s, lifespan %d TimeUnit %s", new Object[]{key, lifespan, lifespanUnit});
                }
            });
        }
    }

    public <K, V> void notify(ClusterProvider clusterProvider, String taskKey, ClusterEvent event, boolean ignoreSender) {
        log.tracev("Adding cache operation SEND_EVENT: {0}", (Object)event);
        String theTaskKey = taskKey;
        int i = 1;
        while (this.tasks.containsKey(theTaskKey)) {
            theTaskKey = taskKey + "-" + i++;
        }
        this.tasks.put(taskKey, () -> clusterProvider.notify(taskKey, event, ignoreSender, ClusterProvider.DCNotify.ALL_DCS));
    }

    public <K, V> void remove(final Cache<K, V> cache, final K key) {
        log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REMOVE, key);
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        this.tasks.put(taskKey, new CacheTask(){

            @Override
            public void execute() {
                InfinispanKeycloakTransaction.decorateCache(cache).remove(key);
            }

            public String toString() {
                return String.format("CacheTask: Operation 'remove' for key %s", key);
            }
        });
    }

    public <K, V> V get(Cache<K, V> cache, K key) {
        Object taskKey = InfinispanKeycloakTransaction.getTaskKey(cache, key);
        CacheTask current = this.tasks.get(taskKey);
        if (current != null && current instanceof CacheTaskWithValue) {
            return ((CacheTaskWithValue)current).getValue();
        }
        return (V)cache.get(key);
    }

    private static <K, V> Object getTaskKey(Cache<K, V> cache, K key) {
        if (key instanceof String) {
            return cache.getName() + "::" + key;
        }
        return key;
    }

    private static <K, V> Cache<K, V> decorateCache(Cache<K, V> cache) {
        return cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_REMOTE_LOOKUP});
    }

    public abstract class CacheTaskWithValue<V>
    implements CacheTask {
        protected V value;

        public CacheTaskWithValue(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }

    public static interface CacheTask {
        public void execute();
    }

    public static enum CacheOperation {
        ADD,
        ADD_WITH_LIFESPAN,
        REMOVE,
        REPLACE,
        ADD_IF_ABSENT;

    }
}

