/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.entities.GroupNameQuery;
import org.keycloak.models.cache.infinispan.entities.Revisioned;

@SerializeWith(value=ExternalizerImpl.class)
public class InGroupPredicate
implements Predicate<Map.Entry<String, Revisioned>>,
Serializable {
    private String group;

    public static InGroupPredicate create() {
        return new InGroupPredicate();
    }

    public InGroupPredicate group(String id) {
        this.group = id;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, Revisioned> entry) {
        Revisioned value = entry.getValue();
        if (value == null) {
            return false;
        }
        if (!(value instanceof GroupNameQuery)) {
            return false;
        }
        return this.group.equals(((GroupNameQuery)value).getGroupId());
    }

    public static class ExternalizerImpl
    implements Externalizer<InGroupPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, InGroupPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.group, (ObjectOutput)output);
        }

        public InGroupPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public InGroupPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            InGroupPredicate res = new InGroupPredicate();
            res.group = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

