/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.JpaKeycloakTransaction;
import org.keycloak.models.jpa.RealmAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.OAuthClientEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.utils.KeycloakSessionUtils;

public class JpaKeycloakSession
implements KeycloakSession {
    protected EntityManager em;

    public JpaKeycloakSession(EntityManager em) {
        this.em = em;
    }

    public KeycloakTransaction getTransaction() {
        return new JpaKeycloakTransaction(this.em);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakSessionUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        RealmEntity realm = new RealmEntity();
        realm.setName(name);
        realm.setId(id);
        this.em.persist((Object)realm);
        this.em.flush();
        return new RealmAdapter(this.em, realm);
    }

    public RealmModel getRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this.em, realm);
    }

    public List<RealmModel> getRealms(UserModel admin) {
        TypedQuery query = this.em.createNamedQuery("getAllRealms", RealmEntity.class);
        List entities = query.getResultList();
        ArrayList<RealmModel> realms = new ArrayList<RealmModel>();
        for (RealmEntity entity : entities) {
            realms.add(new RealmAdapter(this.em, entity));
        }
        return realms;
    }

    public RealmModel getRealmByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmByName", RealmEntity.class);
        query.setParameter("name", (Object)name);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        if (entities.size() > 1) {
            throw new IllegalStateException("Should not be more than one realm with same name");
        }
        RealmEntity realm = (RealmEntity)query.getResultList().get(0);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this.em, realm);
    }

    public boolean removeRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return false;
        }
        RealmAdapter adapter = new RealmAdapter(this.em, realm);
        for (ApplicationEntity a : new LinkedList<ApplicationEntity>(realm.getApplications())) {
            adapter.removeApplication(a.getId());
        }
        for (UserEntity u : this.em.createQuery("from UserEntity", UserEntity.class).getResultList()) {
            adapter.removeUser(u.getLoginName());
        }
        this.em.createQuery("delete from " + OAuthClientEntity.class.getSimpleName() + " where realm = :realm").setParameter("realm", (Object)realm).executeUpdate();
        this.em.remove((Object)realm);
        return true;
    }

    public void close() {
        if (this.em.getTransaction().isActive()) {
            this.em.getTransaction().rollback();
        }
        if (this.em.isOpen()) {
            this.em.close();
        }
    }
}

