/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeGroupMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;

public final class AttributeMetadata {
    public static final Predicate<AttributeContext> ALWAYS_TRUE = context -> true;
    public static final Predicate<AttributeContext> ALWAYS_FALSE = context -> false;
    private final String attributeName;
    private String attributeDisplayName;
    private AttributeGroupMetadata attributeGroupMetadata;
    private final Predicate<AttributeContext> selector;
    private final List<Predicate<AttributeContext>> writeAllowed = new ArrayList<Predicate<AttributeContext>>();
    private final Predicate<AttributeContext> required;
    private final List<Predicate<AttributeContext>> readAllowed = new ArrayList<Predicate<AttributeContext>>();
    private List<AttributeValidatorMetadata> validators;
    private Map<String, Object> annotations;
    private int guiOrder;

    AttributeMetadata(String attributeName, int guiOrder) {
        this(attributeName, guiOrder, ALWAYS_TRUE, ALWAYS_TRUE, ALWAYS_TRUE, ALWAYS_TRUE);
    }

    AttributeMetadata(String attributeName, int guiOrder, Predicate<AttributeContext> writeAllowed, Predicate<AttributeContext> required) {
        this(attributeName, guiOrder, ALWAYS_TRUE, writeAllowed, required, ALWAYS_TRUE);
    }

    AttributeMetadata(String attributeName, int guiOrder, Predicate<AttributeContext> selector) {
        this(attributeName, guiOrder, selector, ALWAYS_FALSE, ALWAYS_TRUE, ALWAYS_TRUE);
    }

    AttributeMetadata(String attributeName, int guiOrder, List<String> scopes, Predicate<AttributeContext> writeAllowed, Predicate<AttributeContext> required) {
        this(attributeName, guiOrder, (AttributeContext context) -> {
            KeycloakSession session = context.getSession();
            AuthenticationSessionModel authSession = session.getContext().getAuthenticationSession();
            if (authSession == null) {
                return false;
            }
            ClientScopeProvider clientScopes = session.clientScopes();
            RealmModel realm = session.getContext().getRealm();
            if (authSession.getClientScopes().stream().anyMatch(scopes::contains)) {
                return true;
            }
            return authSession.getClientScopes().stream().map(id -> clientScopes.getClientScopeById(realm, id).getName()).anyMatch(scopes::contains);
        }, writeAllowed, required, ALWAYS_TRUE);
    }

    AttributeMetadata(String attributeName, int guiOrder, Predicate<AttributeContext> selector, Predicate<AttributeContext> writeAllowed, Predicate<AttributeContext> required, Predicate<AttributeContext> readAllowed) {
        this.attributeName = attributeName;
        this.guiOrder = guiOrder;
        this.selector = selector;
        this.addWriteCondition(writeAllowed);
        this.required = required;
        this.addReadCondition(readAllowed);
    }

    AttributeMetadata(String attributeName, int guiOrder, Predicate<AttributeContext> selector, List<Predicate<AttributeContext>> writeAllowed, Predicate<AttributeContext> required, List<Predicate<AttributeContext>> readAllowed) {
        this.attributeName = attributeName;
        this.guiOrder = guiOrder;
        this.selector = selector;
        this.writeAllowed.addAll(writeAllowed);
        this.required = required;
        this.readAllowed.addAll(readAllowed);
    }

    public String getName() {
        return this.attributeName;
    }

    public int getGuiOrder() {
        return this.guiOrder;
    }

    public AttributeMetadata setGuiOrder(int guiOrder) {
        this.guiOrder = guiOrder;
        return this;
    }

    public AttributeGroupMetadata getAttributeGroupMetadata() {
        return this.attributeGroupMetadata;
    }

    public boolean isSelected(AttributeContext context) {
        return this.selector.test(context);
    }

    private boolean allConditionsMet(List<Predicate<AttributeContext>> predicates, AttributeContext context) {
        return predicates.stream().allMatch(p -> p.test(context));
    }

    public AttributeMetadata addReadCondition(Predicate<AttributeContext> readAllowed) {
        this.readAllowed.add(readAllowed);
        return this;
    }

    public AttributeMetadata addWriteCondition(Predicate<AttributeContext> writeAllowed) {
        this.writeAllowed.add(writeAllowed);
        return this;
    }

    public boolean isReadOnly(AttributeContext context) {
        return !this.canEdit(context);
    }

    public boolean canView(AttributeContext context) {
        return this.allConditionsMet(this.readAllowed, context);
    }

    public boolean canEdit(AttributeContext context) {
        return this.allConditionsMet(this.writeAllowed, context);
    }

    public boolean isRequired(AttributeContext context) {
        return this.required == null || this.required.test(context);
    }

    public List<AttributeValidatorMetadata> getValidators() {
        return this.validators;
    }

    public AttributeMetadata addValidator(List<AttributeValidatorMetadata> validators) {
        if (this.validators == null) {
            this.validators = new ArrayList<AttributeValidatorMetadata>();
        }
        this.validators.removeIf(validators::contains);
        this.validators.addAll(validators.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        return this;
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public AttributeMetadata addAnnotations(Map<String, Object> annotations) {
        if (annotations != null) {
            if (this.annotations == null) {
                this.annotations = new HashMap<String, Object>();
            }
            this.annotations.putAll(annotations);
        }
        return this;
    }

    public AttributeMetadata clone() {
        AttributeMetadata cloned = new AttributeMetadata(this.attributeName, this.guiOrder, this.selector, this.writeAllowed, this.required, this.readAllowed);
        if (this.validators != null) {
            cloned.addValidator(this.validators);
        }
        if (this.annotations != null) {
            cloned.addAnnotations(this.annotations);
        }
        cloned.setAttributeDisplayName(this.attributeDisplayName);
        if (this.attributeGroupMetadata != null) {
            cloned.setAttributeGroupMetadata(this.attributeGroupMetadata.clone());
        }
        return cloned;
    }

    public String getAttributeDisplayName() {
        if (this.attributeDisplayName == null || this.attributeDisplayName.trim().isEmpty()) {
            return this.attributeName;
        }
        return this.attributeDisplayName;
    }

    public AttributeMetadata setAttributeDisplayName(String attributeDisplayName) {
        if (attributeDisplayName != null) {
            this.attributeDisplayName = attributeDisplayName;
        }
        return this;
    }

    public AttributeMetadata setAttributeGroupMetadata(AttributeGroupMetadata attributeGroupMetadata) {
        if (attributeGroupMetadata != null) {
            this.attributeGroupMetadata = attributeGroupMetadata;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AttributeMetadata)) {
            return false;
        }
        AttributeMetadata that = (AttributeMetadata)o;
        return that.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.attributeName.hashCode();
    }
}

