/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.PolicyEvaluator;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;

public class DefaultPolicyEvaluator
implements PolicyEvaluator {
    @Override
    public void evaluate(ResourcePermission permission, AuthorizationProvider authorizationProvider, EvaluationContext executionContext, Decision decision, Map<Policy, Map<Object, Decision.Effect>> decisionCache) {
        Collection<Scope> scopes;
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        ResourceServer resourceServer = permission.getResourceServer();
        PolicyEnforcementMode enforcementMode = resourceServer.getPolicyEnforcementMode();
        if (PolicyEnforcementMode.DISABLED.equals((Object)enforcementMode)) {
            this.grantAndComplete(permission, authorizationProvider, executionContext, decision);
            return;
        }
        if (permission.isGranted()) {
            this.grantAndComplete(permission, authorizationProvider, executionContext, decision);
            return;
        }
        AtomicBoolean verified = new AtomicBoolean();
        Consumer<Policy> policyConsumer = this.createPolicyEvaluator(permission, authorizationProvider, executionContext, decision, verified, decisionCache);
        Resource resource = permission.getResource();
        if (resource != null) {
            policyStore.findByResource(resourceServer, resource, policyConsumer);
            if (resource.getType() != null) {
                policyStore.findByResourceType(resourceServer, resource.getType(), policyConsumer);
                if (!resource.getOwner().equals(resourceServer.getClientId())) {
                    for (Resource typedResource : resourceStore.findByType(resourceServer, resource.getType())) {
                        policyStore.findByResource(resourceServer, typedResource, policyConsumer);
                    }
                }
            }
        }
        if (!(scopes = permission.getScopes()).isEmpty()) {
            policyStore.findByScopes(resourceServer, null, new LinkedList<Scope>(scopes), policyConsumer);
        }
        if (verified.get()) {
            decision.onComplete(permission);
            return;
        }
        if (PolicyEnforcementMode.PERMISSIVE.equals((Object)enforcementMode)) {
            this.grantAndComplete(permission, authorizationProvider, executionContext, decision);
        }
    }

    private void grantAndComplete(ResourcePermission permission, AuthorizationProvider authorizationProvider, EvaluationContext executionContext, Decision decision) {
        DefaultEvaluation evaluation = new DefaultEvaluation(permission, executionContext, decision, authorizationProvider);
        evaluation.grant();
        decision.onComplete(permission);
    }

    private Consumer<Policy> createPolicyEvaluator(ResourcePermission permission, AuthorizationProvider authorizationProvider, EvaluationContext executionContext, Decision decision, AtomicBoolean verified, Map<Policy, Map<Object, Decision.Effect>> decisionCache) {
        return parentPolicy -> {
            Object policyProvider = authorizationProvider.getProvider(parentPolicy.getType());
            if (policyProvider == null) {
                throw new RuntimeException("Unknown parentPolicy provider for type [" + parentPolicy.getType() + "].");
            }
            policyProvider.evaluate(new DefaultEvaluation(permission, executionContext, (Policy)parentPolicy, decision, authorizationProvider, decisionCache));
            verified.compareAndSet(false, true);
        };
    }
}

