/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.LinkedList;
import org.jboss.logging.Logger;
import org.keycloak.audit.Audit;
import org.keycloak.audit.AuditListener;
import org.keycloak.audit.AuditProvider;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.services.ClientConnection;

public class AuditManager {
    private Logger log = Logger.getLogger(AuditManager.class);
    private RealmModel realm;
    private ProviderSession providers;
    private ClientConnection clientConnection;

    public AuditManager(RealmModel realm, ProviderSession providers, ClientConnection clientConnection) {
        this.realm = realm;
        this.providers = providers;
        this.clientConnection = clientConnection;
    }

    public Audit createAudit() {
        LinkedList<Object> listeners = new LinkedList<Object>();
        if (this.realm.isAuditEnabled()) {
            AuditProvider auditProvider = (AuditProvider)this.providers.getProvider(AuditProvider.class);
            if (auditProvider != null) {
                listeners.add(auditProvider);
            } else {
                this.log.error((Object)"Audit enabled, but no audit provider configured");
            }
        }
        if (this.realm.getAuditListeners() != null) {
            for (String id : this.realm.getAuditListeners()) {
                AuditListener listener = (AuditListener)this.providers.getProvider(AuditListener.class, id);
                if (listener != null) {
                    listeners.add(listener);
                    continue;
                }
                this.log.error((Object)("Audit listener '" + id + "' registered, but not found"));
            }
        }
        return new Audit(listeners, this.realm, this.clientConnection.getRemoteAddr());
    }
}

