/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.core.Context;
import org.keycloak.Version;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.social.SocialProvider;
import org.keycloak.util.ProviderLoader;

public class ServerInfoAdminResource {
    @Context
    private KeycloakSession session;

    @GET
    public ServerInfoRepresentation getInfo() {
        ServerInfoRepresentation info = new ServerInfoRepresentation();
        info.setVersion(Version.VERSION);
        this.setSocialProviders(info);
        this.setThemes(info);
        this.setEventListeners(info);
        return info;
    }

    private void setThemes(ServerInfoRepresentation info) {
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        info.themes = new HashMap();
        for (Theme.Type type : Theme.Type.values()) {
            LinkedList themes = new LinkedList(themeProvider.nameSet(type));
            Collections.sort(themes);
            info.themes.put(type.toString().toLowerCase(), themes);
        }
    }

    private void setSocialProviders(ServerInfoRepresentation info) {
        info.socialProviders = new LinkedList();
        for (SocialProvider p : ProviderLoader.load(SocialProvider.class)) {
            info.socialProviders.add(p.getId());
        }
        Collections.sort(info.socialProviders);
    }

    private void setEventListeners(ServerInfoRepresentation info) {
        info.eventListeners = new LinkedList();
        Set providers = this.session.listProviderIds(EventListenerProvider.class);
        if (providers != null) {
            info.eventListeners.addAll(providers);
        }
    }

    public static class ServerInfoRepresentation {
        private String version;
        private Map<String, List<String>> themes;
        private List<String> socialProviders;
        private List<String> eventListeners;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Map<String, List<String>> getThemes() {
            return this.themes;
        }

        public List<String> getSocialProviders() {
            return this.socialProviders;
        }

        public List<String> getEventListeners() {
            return this.eventListeners;
        }
    }
}

