/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.offlineconfig;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.UserFederationManager;
import org.keycloak.models.UserModel;
import org.keycloak.offlineconfig.OfflineConfigException;
import org.keycloak.services.managers.ApplianceBootstrap;

public class AdminRecovery {
    private static final Logger log = Logger.getLogger(AdminRecovery.class);
    public static final String RECOVER_ADMIN_ACCOUNT = "keycloak.recover-admin";
    public static final String TEMP_ADMIN_PASSWORD = "keycloak.temp-admin-password";

    private AdminRecovery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recover(KeycloakSessionFactory sessionFactory) {
        if (!AdminRecovery.needRecovery()) {
            return;
        }
        KeycloakSession session = sessionFactory.create();
        session.getTransaction().begin();
        try {
            AdminRecovery.doRecover(session, AdminRecovery.getTempAdminPassword());
            session.getTransaction().commit();
            log.info((Object)"*******************************");
            log.info((Object)"Recovered Master Admin account.");
            log.info((Object)"*******************************");
        }
        finally {
            session.close();
            System.clearProperty(RECOVER_ADMIN_ACCOUNT);
            System.clearProperty(TEMP_ADMIN_PASSWORD);
        }
    }

    private static boolean needRecovery() {
        String strNeedRecovery = System.getProperty(RECOVER_ADMIN_ACCOUNT, "false");
        return Boolean.parseBoolean(strNeedRecovery);
    }

    private static String getTempAdminPassword() {
        String tempAdminPassword = System.getProperty(TEMP_ADMIN_PASSWORD);
        if (tempAdminPassword == null || tempAdminPassword.isEmpty()) {
            throw new OfflineConfigException("Must provide temporary admin password to recover admin account.");
        }
        return tempAdminPassword;
    }

    private static void doRecover(KeycloakSession session, String tempAdminPassword) {
        String adminRealmName;
        RealmModel realm;
        RealmProvider realmProvider = session.realms();
        UserFederationManager userProvider = session.users();
        UserModel adminUser = userProvider.getUserByUsername("admin", realm = realmProvider.getRealmByName(adminRealmName = Config.getAdminRealm()));
        if (adminUser == null) {
            adminUser = userProvider.addUser(realm, "admin");
        }
        ApplianceBootstrap.setupAdminUser(session, realm, adminUser, tempAdminPassword);
    }
}

