/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.keycloak.partialimport.Action;
import org.keycloak.partialimport.ResourceType;

public class PartialImportResult {
    private final Action action;
    private final ResourceType resourceType;
    private final String resourceName;
    private final String id;
    private final Object representation;

    private PartialImportResult(Action action, ResourceType resourceType, String resourceName, String id, Object representation) {
        this.action = action;
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.id = id;
        this.representation = representation;
    }

    public static PartialImportResult skipped(ResourceType resourceType, String resourceName, String id, Object representation) {
        return new PartialImportResult(Action.SKIPPED, resourceType, resourceName, id, representation);
    }

    public static PartialImportResult added(ResourceType resourceType, String resourceName, String id, Object representation) {
        return new PartialImportResult(Action.ADDED, resourceType, resourceName, id, representation);
    }

    public static PartialImportResult overwritten(ResourceType resourceType, String resourceName, String id, Object representation) {
        return new PartialImportResult(Action.OVERWRITTEN, resourceType, resourceName, id, representation);
    }

    public Action getAction() {
        return this.action;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public Object getRepresentation() {
        return this.representation;
    }
}

