/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.common.Version;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.ThemeResource;

public class Urls {
    public static URI accountApplicationsPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "applicationsPage").build(new Object[]{realmId});
    }

    public static UriBuilder accountBase(URI baseUri) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getAccountService");
    }

    public static URI accountPage(URI baseUri, String realmId) {
        return Urls.accountPageBuilder(baseUri).build(new Object[]{realmId});
    }

    public static UriBuilder accountPageBuilder(URI baseUri) {
        return Urls.accountBase(baseUri).path(AccountService.class, "accountPage");
    }

    public static URI accountPasswordPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "passwordPage").build(new Object[]{realmId});
    }

    public static URI accountFederatedIdentityPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "federatedIdentityPage").build(new Object[]{realmId});
    }

    public static URI accountFederatedIdentityUpdate(URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountService.class, "processFederatedIdentityUpdate").build(new Object[]{realmName});
    }

    public static URI identityProviderAuthnResponse(URI baseUri, String providerId, String realmName) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "getEndpoint").build(new Object[]{realmName, providerId});
    }

    public static URI identityProviderAuthnRequest(URI baseUri, String providerId, String realmName, String accessCode) {
        UriBuilder uriBuilder = Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "performLogin");
        if (accessCode != null) {
            uriBuilder.replaceQueryParam("code", new Object[]{accessCode});
        }
        return uriBuilder.build(new Object[]{realmName, providerId});
    }

    public static URI identityProviderRetrieveToken(URI baseUri, String providerId, String realmName) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "retrieveToken").build(new Object[]{realmName, providerId});
    }

    public static URI identityProviderAuthnRequest(URI baseURI, String providerId, String realmName) {
        return Urls.identityProviderAuthnRequest(baseURI, providerId, realmName, null);
    }

    public static URI identityProviderAfterFirstBrokerLogin(URI baseUri, String realmName, String accessCode) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "afterFirstBrokerLogin").replaceQueryParam("code", new Object[]{accessCode}).build(new Object[]{realmName});
    }

    public static URI identityProviderAfterPostBrokerLogin(URI baseUri, String realmName, String accessCode) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "afterPostBrokerLoginFlow").replaceQueryParam("code", new Object[]{accessCode}).build(new Object[]{realmName});
    }

    public static URI accountTotpPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "totpPage").build(new Object[]{realmId});
    }

    public static URI accountTotpRemove(URI baseUri, String realmId, String stateChecker) {
        return Urls.accountBase(baseUri).path(AccountService.class, "processTotpRemove").queryParam("stateChecker", new Object[]{stateChecker}).build(new Object[]{realmId});
    }

    public static URI accountLogPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "logPage").build(new Object[]{realmId});
    }

    public static URI accountSessionsPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "sessionsPage").build(new Object[]{realmId});
    }

    public static URI accountSessionsLogoutPage(URI baseUri, String realmId, String stateChecker) {
        return Urls.accountBase(baseUri).path(AccountService.class, "processSessionsLogout").queryParam("stateChecker", new Object[]{stateChecker}).build(new Object[]{realmId});
    }

    public static URI accountRevokeClientPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "processRevokeGrant").build(new Object[]{realmId});
    }

    public static URI accountLogout(URI baseUri, URI redirectUri, String realmId) {
        return Urls.realmLogout(baseUri).queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[]{realmId});
    }

    public static URI loginActionUpdatePassword(URI baseUri, String realmId) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "updatePassword").build(new Object[]{realmId});
    }

    public static URI loginActionUpdateTotp(URI baseUri, String realmId) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "updateTotp").build(new Object[]{realmId});
    }

    public static UriBuilder requiredActionBase(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "requiredAction");
    }

    public static URI loginActionUpdateProfile(URI baseUri, String realmId) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "updateProfile").build(new Object[]{realmId});
    }

    public static URI loginActionEmailVerification(URI baseUri, String realmId) {
        return Urls.loginActionEmailVerificationBuilder(baseUri).build(new Object[]{realmId});
    }

    public static UriBuilder loginActionEmailVerificationBuilder(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "emailVerification");
    }

    public static URI loginResetCredentials(URI baseUri, String realmId) {
        return Urls.loginResetCredentialsBuilder(baseUri).build(new Object[]{realmId});
    }

    public static UriBuilder executeActionsBuilder(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "executeActions");
    }

    public static UriBuilder loginResetCredentialsBuilder(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path("reset-credentials");
    }

    public static URI loginUsernameReminder(URI baseUri, String realmId) {
        return Urls.loginUsernameReminderBuilder(baseUri).build(new Object[]{realmId});
    }

    public static UriBuilder loginUsernameReminderBuilder(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "usernameReminder");
    }

    public static String realmIssuer(URI baseUri, String realmId) {
        return Urls.realmBase(baseUri).path("{realm}").build(new Object[]{realmId}).toString();
    }

    public static UriBuilder realmBase(URI baseUri) {
        return UriBuilder.fromUri((URI)baseUri).path(RealmsResource.class);
    }

    public static URI realmLoginPage(URI baseUri, String realmId) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "authenticate").build(new Object[]{realmId});
    }

    private static UriBuilder realmLogout(URI baseUri) {
        return Urls.tokenBase(baseUri).path(OIDCLoginProtocolService.class, "logout");
    }

    public static URI realmRegisterAction(URI baseUri, String realmId) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "processRegister").build(new Object[]{realmId});
    }

    public static URI realmRegisterPage(URI baseUri, String realmId) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "registerPage").build(new Object[]{realmId});
    }

    public static URI realmInstalledAppUrnCallback(URI baseUri, String realmId) {
        return Urls.tokenBase(baseUri).path(OIDCLoginProtocolService.class, "installedAppUrnCallback").build(new Object[]{realmId});
    }

    public static URI realmOauthAction(URI baseUri, String realmId) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "processConsent").build(new Object[]{realmId});
    }

    public static URI firstBrokerLoginProcessor(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "firstBrokerLoginGet").build(new Object[]{realmName});
    }

    public static String localeCookiePath(URI baseUri, String realmName) {
        return Urls.realmBase(baseUri).path(realmName).build(new Object[0]).getRawPath();
    }

    public static URI themeRoot(URI baseUri) {
        return Urls.themeBase(baseUri).path(Version.RESOURCES_VERSION).build(new Object[0]);
    }

    private static UriBuilder loginActionsBase(URI baseUri) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getLoginActionsService");
    }

    private static UriBuilder tokenBase(URI baseUri) {
        return Urls.realmBase(baseUri).path("{realm}/protocol/openid-connect");
    }

    private static UriBuilder themeBase(URI baseUri) {
        return UriBuilder.fromUri((URI)baseUri).path(ThemeResource.class);
    }
}

