/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import org.keycloak.models.AuthenticatorConfigModel;

public class X509AuthenticatorConfigModel
extends AuthenticatorConfigModel {
    private static final long serialVersionUID = 1L;

    public X509AuthenticatorConfigModel(AuthenticatorConfigModel model) {
        this.setAlias(model.getAlias());
        this.setId(model.getId());
        this.setConfig(model.getConfig());
    }

    public X509AuthenticatorConfigModel() {
    }

    public boolean getCRLEnabled() {
        return Boolean.parseBoolean((String)this.getConfig().get("x509-cert-auth.crl-checking-enabled"));
    }

    public X509AuthenticatorConfigModel setCRLEnabled(boolean value) {
        this.getConfig().put("x509-cert-auth.crl-checking-enabled", Boolean.toString(value));
        return this;
    }

    public boolean getOCSPEnabled() {
        return Boolean.parseBoolean((String)this.getConfig().get("x509-cert-auth.ocsp-checking-enabled"));
    }

    public X509AuthenticatorConfigModel setOCSPEnabled(boolean value) {
        this.getConfig().put("x509-cert-auth.ocsp-checking-enabled", Boolean.toString(value));
        return this;
    }

    public boolean getOCSPFailOpen() {
        return Boolean.parseBoolean(this.getConfig().getOrDefault("x509-cert-auth.ocsp-fail-open", Boolean.toString(false)));
    }

    public X509AuthenticatorConfigModel setOCSPFailOpen(boolean value) {
        this.getConfig().put("x509-cert-auth.ocsp-fail-open", Boolean.toString(value));
        return this;
    }

    public boolean getCRLDistributionPointEnabled() {
        return Boolean.parseBoolean((String)this.getConfig().get("x509-cert-auth.crldp-checking-enabled"));
    }

    public X509AuthenticatorConfigModel setCRLDistributionPointEnabled(boolean value) {
        this.getConfig().put("x509-cert-auth.crldp-checking-enabled", Boolean.toString(value));
        return this;
    }

    public String getCRLRelativePath() {
        return this.getConfig().getOrDefault("x509-cert-auth.crl-relative-path", null);
    }

    public X509AuthenticatorConfigModel setCRLRelativePath(String path) {
        if (path != null) {
            this.getConfig().put("x509-cert-auth.crl-relative-path", path);
        } else {
            this.getConfig().remove("x509-cert-auth.crl-relative-path");
        }
        return this;
    }

    public String getOCSPResponder() {
        return this.getConfig().getOrDefault("x509-cert-auth.ocsp-responder-uri", null);
    }

    public X509AuthenticatorConfigModel setOCSPResponder(String responderUri) {
        if (responderUri != null) {
            this.getConfig().put("x509-cert-auth.ocsp-responder-uri", responderUri);
        } else {
            this.getConfig().remove("x509-cert-auth.ocsp-responder-uri");
        }
        return this;
    }

    public String getOCSPResponderCertificate() {
        return this.getConfig().getOrDefault("x509-cert-auth.ocsp-responder-certificate", null);
    }

    public X509AuthenticatorConfigModel setOCSPResponderCertificate(String responderCert) {
        if (responderCert != null) {
            this.getConfig().put("x509-cert-auth.ocsp-responder-certificate", responderCert);
        } else {
            this.getConfig().remove("x509-cert-auth.ocsp-responder-certificate");
        }
        return this;
    }

    public MappingSourceType getMappingSourceType() {
        return MappingSourceType.parse(this.getConfig().getOrDefault("x509-cert-auth.mapping-source-selection", "Match SubjectDN using regular expression"));
    }

    public X509AuthenticatorConfigModel setMappingSourceType(MappingSourceType value) {
        this.getConfig().put("x509-cert-auth.mapping-source-selection", value.getName());
        return this;
    }

    public IdentityMapperType getUserIdentityMapperType() {
        return IdentityMapperType.parse(this.getConfig().getOrDefault("x509-cert-auth.mapper-selection", "Username or Email"));
    }

    public X509AuthenticatorConfigModel setUserIdentityMapperType(IdentityMapperType value) {
        this.getConfig().put("x509-cert-auth.mapper-selection", value.getName());
        return this;
    }

    public String getRegularExpression() {
        return this.getConfig().getOrDefault("x509-cert-auth.regular-expression", "(.*?)(?:$)");
    }

    public X509AuthenticatorConfigModel setRegularExpression(String value) {
        if (value != null) {
            this.getConfig().put("x509-cert-auth.regular-expression", value);
        } else {
            this.getConfig().remove("x509-cert-auth.regular-expression");
        }
        return this;
    }

    public String getCustomAttributeName() {
        return this.getConfig().getOrDefault("x509-cert-auth.mapper-selection.user-attribute-name", "usercertificate");
    }

    public X509AuthenticatorConfigModel setCustomAttributeName(String value) {
        if (value != null) {
            this.getConfig().put("x509-cert-auth.mapper-selection.user-attribute-name", value);
        } else {
            this.getConfig().remove("x509-cert-auth.mapper-selection.user-attribute-name");
        }
        return this;
    }

    public String getKeyUsage() {
        return this.getConfig().getOrDefault("x509-cert-auth.keyusage", null);
    }

    public X509AuthenticatorConfigModel setKeyUsage(String value) {
        if (value != null) {
            this.getConfig().put("x509-cert-auth.keyusage", value);
        } else {
            this.getConfig().remove("x509-cert-auth.keyusage");
        }
        return this;
    }

    public String getExtendedKeyUsage() {
        return this.getConfig().getOrDefault("x509-cert-auth.extendedkeyusage", null);
    }

    public X509AuthenticatorConfigModel setExtendedKeyUsage(String value) {
        if (value != null) {
            this.getConfig().put("x509-cert-auth.extendedkeyusage", value);
        } else {
            this.getConfig().remove("x509-cert-auth.extendedkeyusage");
        }
        return this;
    }

    public String getCertificatePolicy() {
        return this.getConfig().getOrDefault("x509-cert-auth.certificate-policy", null);
    }

    public X509AuthenticatorConfigModel setCertificatePolicy(String value) {
        if (value != null) {
            this.getConfig().put("x509-cert-auth.certificate-policy", value);
        } else {
            this.getConfig().remove("x509-cert-auth.certificate-policy");
        }
        return this;
    }

    public CertificatePolicyModeType getCertificatePolicyMode() {
        return CertificatePolicyModeType.parse(this.getConfig().getOrDefault("x509-cert-auth.certificate-policy-mode", "All"));
    }

    public X509AuthenticatorConfigModel setCertificatePolicyMode(CertificatePolicyModeType value) {
        this.getConfig().put("x509-cert-auth.certificate-policy-mode", value.getMode());
        return this;
    }

    public boolean getConfirmationPageDisallowed() {
        return Boolean.parseBoolean((String)this.getConfig().get("x509-cert-auth.confirmation-page-disallowed"));
    }

    public boolean getConfirmationPageAllowed() {
        return !Boolean.parseBoolean((String)this.getConfig().get("x509-cert-auth.confirmation-page-disallowed"));
    }

    public X509AuthenticatorConfigModel setConfirmationPageDisallowed(boolean value) {
        this.getConfig().put("x509-cert-auth.confirmation-page-disallowed", Boolean.toString(value));
        return this;
    }

    public X509AuthenticatorConfigModel setConfirmationPageAllowed(boolean value) {
        this.getConfig().put("x509-cert-auth.confirmation-page-disallowed", Boolean.toString(!value));
        return this;
    }

    public boolean isCanonicalDnEnabled() {
        return Boolean.parseBoolean((String)this.getConfig().get("x509-cert-auth.canonical-dn-enabled"));
    }

    public X509AuthenticatorConfigModel setCanonicalDnEnabled(boolean value) {
        this.getConfig().put("x509-cert-auth.canonical-dn-enabled", Boolean.toString(value));
        return this;
    }

    public boolean isCertValidationEnabled() {
        return Boolean.parseBoolean((String)this.getConfig().get("x509-cert-auth.timestamp-validation-enabled"));
    }

    public X509AuthenticatorConfigModel setCertValidationEnabled(boolean value) {
        this.getConfig().put("x509-cert-auth.timestamp-validation-enabled", Boolean.toString(value));
        return this;
    }

    public boolean isSerialnumberHex() {
        return Boolean.parseBoolean((String)this.getConfig().get("x509-cert-auth.serialnumber-hex-enabled"));
    }

    public X509AuthenticatorConfigModel setSerialnumberHex(boolean value) {
        this.getConfig().put("x509-cert-auth.serialnumber-hex-enabled", Boolean.toString(value));
        return this;
    }

    public boolean getRevalidateCertificateEnabled() {
        return Boolean.parseBoolean((String)this.getConfig().get("x509-cert-auth.revalidate-certificate-enabled"));
    }

    public X509AuthenticatorConfigModel setRevalidateCertificateEnabled(boolean value) {
        this.getConfig().put("x509-cert-auth.revalidate-certificate-enabled", Boolean.toString(value));
        return this;
    }

    public static enum CertificatePolicyModeType {
        ALL("All"),
        ANY("Any");

        private String mode;

        private CertificatePolicyModeType(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public static CertificatePolicyModeType parse(String mode) throws IllegalArgumentException, IndexOutOfBoundsException {
            if (mode == null || mode.trim().length() == 0) {
                throw new IllegalArgumentException("mode");
            }
            for (CertificatePolicyModeType value : CertificatePolicyModeType.values()) {
                if (!value.getMode().equalsIgnoreCase(mode)) continue;
                return value;
            }
            throw new IndexOutOfBoundsException("mode");
        }
    }

    public static enum MappingSourceType {
        SERIALNUMBER("Certificate Serial Number"),
        ISSUERDN("Match IssuerDN using regular expression"),
        SUBJECTDN_CN("Subject's Common Name"),
        SUBJECTDN_EMAIL("Subject's e-mail"),
        SUBJECTALTNAME_EMAIL("Subject's Alternative Name E-mail"),
        SUBJECTALTNAME_OTHERNAME("Subject's Alternative Name otherName (UPN)"),
        SUBJECTDN("Match SubjectDN using regular expression"),
        SHA256_THUMBPRINT("SHA-256 Thumbprint"),
        SERIALNUMBER_ISSUERDN("Certificate Serial Number and IssuerDN"),
        CERTIFICATE_PEM("Full Certificate in PEM format");

        private String name;

        private MappingSourceType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static MappingSourceType parse(String name) throws IllegalArgumentException, IndexOutOfBoundsException {
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException("name");
            }
            for (MappingSourceType value : MappingSourceType.values()) {
                if (!value.getName().equalsIgnoreCase(name)) continue;
                return value;
            }
            throw new IndexOutOfBoundsException("name");
        }
    }

    public static enum IdentityMapperType {
        USER_ATTRIBUTE("Custom Attribute Mapper"),
        USERNAME_EMAIL("Username or Email");

        private String name;

        private IdentityMapperType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static IdentityMapperType parse(String name) throws IllegalArgumentException, IndexOutOfBoundsException {
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException("name");
            }
            for (IdentityMapperType value : IdentityMapperType.values()) {
                if (!value.getName().equalsIgnoreCase(name)) continue;
                return value;
            }
            throw new IndexOutOfBoundsException("name");
        }
    }
}

