/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.dir;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.platform.Platform;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.util.JsonSerialization;

public class DirImportProvider
implements ImportProvider {
    private static final Logger logger = Logger.getLogger(DirImportProvider.class);
    private final File rootDirectory;

    public DirImportProvider() {
        this.rootDirectory = new File(Platform.getPlatform().getTmpDirectory(), "keycloak-export");
        if (!this.rootDirectory.exists()) {
            throw new IllegalStateException("Directory " + this.rootDirectory + " doesn't exist");
        }
        logger.infof("Importing from directory %s", (Object)this.rootDirectory.getAbsolutePath());
    }

    public DirImportProvider(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        if (!this.rootDirectory.exists()) {
            throw new IllegalStateException("Directory " + this.rootDirectory + " doesn't exist");
        }
        logger.infof("Importing from directory %s", (Object)this.rootDirectory.getAbsolutePath());
    }

    public void importModel(KeycloakSessionFactory factory, Strategy strategy) throws IOException {
        List<String> realmNames = this.getRealmsToImport();
        for (String realmName : realmNames) {
            this.importRealm(factory, realmName, strategy);
        }
    }

    public boolean isMasterRealmExported() throws IOException {
        List<String> realmNames = this.getRealmsToImport();
        return realmNames.contains(Config.getAdminRealm());
    }

    private List<String> getRealmsToImport() throws IOException {
        File[] realmFiles = this.rootDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("-realm.json");
            }
        });
        ArrayList<String> realmNames = new ArrayList<String>();
        for (File file : realmFiles) {
            String fileName = file.getName();
            String realmName = fileName.substring(0, fileName.length() - 11);
            if (Config.getAdminRealm().equals(realmName)) {
                realmNames.add(0, realmName);
                continue;
            }
            realmNames.add(realmName);
        }
        return realmNames;
    }

    public void importRealm(KeycloakSessionFactory factory, final String realmName, final Strategy strategy) throws IOException {
        File realmFile = new File(this.rootDirectory + File.separator + realmName + "-realm.json");
        File[] userFiles = this.rootDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(realmName + "-users-[0-9]+\\.json");
            }
        });
        File[] federatedUserFiles = this.rootDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(realmName + "-federated-users-[0-9]+\\.json");
            }
        });
        FileInputStream is = new FileInputStream(realmFile);
        final RealmRepresentation realmRep = (RealmRepresentation)JsonSerialization.readValue((InputStream)is, RealmRepresentation.class);
        final AtomicBoolean realmImported = new AtomicBoolean();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            @Override
            public void runExportImportTask(KeycloakSession session) throws IOException {
                boolean imported = ImportUtils.importRealm(session, realmRep, strategy, true);
                realmImported.set(imported);
            }
        });
        if (realmImported.get()) {
            FileInputStream fis;
            for (final File userFile : userFiles) {
                fis = new FileInputStream(userFile);
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

                    @Override
                    protected void runExportImportTask(KeycloakSession session) throws IOException {
                        ImportUtils.importUsersFromStream(session, realmName, JsonSerialization.mapper, fis);
                        logger.infof("Imported users from %s", (Object)userFile.getAbsolutePath());
                    }
                });
            }
            for (final File userFile : federatedUserFiles) {
                fis = new FileInputStream(userFile);
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

                    @Override
                    protected void runExportImportTask(KeycloakSession session) throws IOException {
                        ImportUtils.importFederatedUsersFromStream(session, realmName, JsonSerialization.mapper, fis);
                        logger.infof("Imported federated users from %s", (Object)userFile.getAbsolutePath());
                    }
                });
            }
        }
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            @Override
            public void runExportImportTask(KeycloakSession session) throws IOException {
                RealmManager realmManager = new RealmManager(session);
                realmManager.setupClientServiceAccountsAndAuthorizationOnImport(realmRep, false);
            }
        });
    }

    public void close() {
    }
}

