/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.FindFile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.oidc.OIDCWellKnownProvider;
import org.keycloak.util.JsonSerialization;
import org.keycloak.wellknown.WellKnownProvider;
import org.keycloak.wellknown.WellKnownProviderFactory;

public class OIDCWellKnownProviderFactory
implements WellKnownProviderFactory {
    public static final String PROVIDER_ID = "openid-configuration";
    private static final Logger logger = Logger.getLogger(OIDCWellKnownProviderFactory.class);
    private Map<String, Object> openidConfigOverride = null;
    private boolean includeClientScopes = true;

    public WellKnownProvider create(KeycloakSession session) {
        return new OIDCWellKnownProvider(session, this.openidConfigOverride, this.includeClientScopes);
    }

    public void init(Config.Scope config) {
        String openidConfigurationOverride = config.get("openid-configuration-override");
        this.includeClientScopes = config.getBoolean("include-client-scopes", Boolean.valueOf(true));
        logger.debugf("Include Client Scopes in OIDC Well-known endpoint: %s", (Object)this.includeClientScopes);
        if (openidConfigurationOverride != null) {
            this.initConfigOverrideFromFile(openidConfigurationOverride);
        }
    }

    protected void initConfigOverrideFromFile(String openidConfigurationOverrideFile) {
        try {
            InputStream is = FindFile.findFile((String)openidConfigurationOverrideFile);
            this.openidConfigOverride = (Map)JsonSerialization.readValue((InputStream)is, Map.class);
            logger.infof("Overriding default OIDC well-known endpoint configuration with the options from file '%s'", (Object)openidConfigurationOverrideFile);
        }
        catch (RuntimeException re) {
            logger.warnf((Throwable)re, "Unable to find file specified for openid-configuration-override on custom location '%s'. Will stick to the default configuration for OIDC WellKnown endpoint", (Object)openidConfigurationOverrideFile);
        }
        catch (IOException ioe) {
            logger.warnf((Throwable)ioe, "Error when trying to deserialize JSON from the file '%s'. Check the JSON format. Will stick to the default configuration for OIDC WellKnown endpoint", (Object)openidConfigurationOverrideFile);
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    protected Map<String, Object> getOpenidConfigOverride() {
        return this.openidConfigOverride;
    }
}

