/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.OAuthErrorException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.authorization.AuthorizationTokenService;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.AuthenticationFlowResolver;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.protocol.oidc.TokenExchangeProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.TokenIntrospectionEndpoint;
import org.keycloak.protocol.oidc.grants.ciba.CibaGrantType;
import org.keycloak.protocol.oidc.grants.device.DeviceGrantType;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.oidc.utils.OAuth2Code;
import org.keycloak.protocol.oidc.utils.OAuth2CodeParser;
import org.keycloak.protocol.oidc.utils.PkceUtils;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ResourceOwnerPasswordCredentialsContext;
import org.keycloak.services.clientpolicy.context.ServiceAccountTokenRequestContext;
import org.keycloak.services.clientpolicy.context.TokenRefreshContext;
import org.keycloak.services.clientpolicy.context.TokenRequestContext;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.services.util.MtlsHoKTokenUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;
import org.keycloak.utils.ProfileHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TokenEndpoint {
    private static final Logger logger = Logger.getLogger(TokenEndpoint.class);
    private MultivaluedMap<String, String> formParams;
    private ClientModel client;
    private Map<String, String> clientAuthAttributes;
    private static final Pattern VALID_CODE_VERIFIER_PATTERN = Pattern.compile("^[0-9a-zA-Z\\-\\.~_]+$");
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpResponse httpResponse;
    @Context
    private HttpHeaders headers;
    @Context
    private ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final RealmModel realm;
    private final EventBuilder event;
    private Action action;
    private String grantType;
    private Cors cors;

    public TokenEndpoint(TokenManager tokenManager, RealmModel realm, EventBuilder event) {
        this.tokenManager = tokenManager;
        this.realm = realm;
        this.event = event;
    }

    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    public Response processGrantRequest() {
        this.cors = Cors.add(this.request).auth().allowedMethods("POST").auth().exposedHeaders("Access-Control-Allow-Methods");
        MultivaluedMap formParameters = this.request.getDecodedFormParameters();
        if (formParameters == null) {
            formParameters = new MultivaluedHashMap();
        }
        this.formParams = formParameters;
        this.grantType = (String)this.formParams.getFirst((Object)"grant_type");
        MultivaluedMap outputHeaders = this.httpResponse.getOutputHeaders();
        outputHeaders.putSingle((Object)"Cache-Control", (Object)"no-store");
        outputHeaders.putSingle((Object)"Pragma", (Object)"no-cache");
        this.checkSsl();
        this.checkRealm();
        this.checkGrantType();
        if (!this.action.equals((Object)Action.PERMISSION)) {
            this.checkClient();
            this.checkParameterDuplicated();
        }
        switch (this.action) {
            case AUTHORIZATION_CODE: {
                return this.codeToToken();
            }
            case REFRESH_TOKEN: {
                return this.refreshTokenGrant();
            }
            case PASSWORD: {
                return this.resourceOwnerPasswordCredentialsGrant();
            }
            case CLIENT_CREDENTIALS: {
                return this.clientCredentialsGrant();
            }
            case TOKEN_EXCHANGE: {
                return this.tokenExchange();
            }
            case PERMISSION: {
                return this.permissionGrant();
            }
            case OAUTH2_DEVICE_CODE: {
                return this.oauth2DeviceCodeToToken();
            }
            case CIBA: {
                return this.cibaGrant();
            }
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
    }

    @Path(value="introspect")
    public Object introspect() {
        TokenIntrospectionEndpoint tokenIntrospectionEndpoint = new TokenIntrospectionEndpoint(this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)tokenIntrospectionEndpoint);
        return tokenIntrospectionEndpoint;
    }

    @OPTIONS
    public Response preflight() {
        if (logger.isDebugEnabled()) {
            logger.debugv("CORS preflight from: {0}", this.headers.getRequestHeaders().getFirst((Object)"Origin"));
        }
        return Cors.add(this.request, Response.ok()).auth().preflight().allowedMethods("POST", "OPTIONS").build();
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.cors);
        this.client = clientAuth.getClient();
        this.clientAuthAttributes = clientAuth.getClientAuthAttributes();
        this.cors.allowedOrigins(this.session, this.client);
        if (this.client.isBearerOnly()) {
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
    }

    private void checkGrantType() {
        if (this.grantType == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Missing form parameter: grant_type", Response.Status.BAD_REQUEST);
        }
        if (this.grantType.equals("authorization_code")) {
            this.event.event(EventType.CODE_TO_TOKEN);
            this.action = Action.AUTHORIZATION_CODE;
        } else if (this.grantType.equals("refresh_token")) {
            this.event.event(EventType.REFRESH_TOKEN);
            this.action = Action.REFRESH_TOKEN;
        } else if (this.grantType.equals("password")) {
            this.event.event(EventType.LOGIN);
            this.action = Action.PASSWORD;
        } else if (this.grantType.equals("client_credentials")) {
            this.event.event(EventType.CLIENT_LOGIN);
            this.action = Action.CLIENT_CREDENTIALS;
        } else if (this.grantType.equals("urn:ietf:params:oauth:grant-type:token-exchange")) {
            this.event.event(EventType.TOKEN_EXCHANGE);
            this.action = Action.TOKEN_EXCHANGE;
        } else if (this.grantType.equals("urn:ietf:params:oauth:grant-type:uma-ticket")) {
            this.event.event(EventType.PERMISSION_TOKEN);
            this.action = Action.PERMISSION;
        } else if (this.grantType.equals("urn:ietf:params:oauth:grant-type:device_code")) {
            this.event.event(EventType.OAUTH2_DEVICE_CODE_TO_TOKEN);
            this.action = Action.OAUTH2_DEVICE_CODE;
        } else if (this.grantType.equals("urn:openid:params:grant-type:ciba")) {
            this.event.event(EventType.AUTHREQID_TO_TOKEN);
            this.action = Action.CIBA;
        } else {
            throw new CorsErrorResponseException(this.cors, "unsupported_grant_type", "Unsupported grant_type", Response.Status.BAD_REQUEST);
        }
        this.event.detail("grant_type", this.grantType);
    }

    private void checkParameterDuplicated() {
        for (String key : this.formParams.keySet()) {
            if (((List)this.formParams.get((Object)key)).size() == 1) continue;
            throw new CorsErrorResponseException(this.cors, "invalid_request", "duplicated parameter", Response.Status.BAD_REQUEST);
        }
    }

    public Response codeToToken() {
        String code = (String)this.formParams.getFirst((Object)"code");
        if (code == null) {
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Missing parameter: code", Response.Status.BAD_REQUEST);
        }
        OAuth2CodeParser.ParseResult parseResult = OAuth2CodeParser.parseCode(this.session, code, this.realm, this.event);
        if (parseResult.isIllegalCode()) {
            AuthenticatedClientSessionModel clientSession = parseResult.getClientSession();
            if (clientSession != null) {
                clientSession.detachFromUserSession();
            }
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Code not valid", Response.Status.BAD_REQUEST);
        }
        AuthenticatedClientSessionModel clientSession = parseResult.getClientSession();
        if (parseResult.isExpiredCode()) {
            this.event.error("expired_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Code is expired", Response.Status.BAD_REQUEST);
        }
        UserSessionModel userSession = null;
        if (clientSession != null) {
            userSession = clientSession.getUserSession();
        }
        if (userSession == null) {
            this.event.error("user_session_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User session not found", Response.Status.BAD_REQUEST);
        }
        UserModel user = userSession.getUser();
        if (user == null) {
            this.event.error("user_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User not found", Response.Status.BAD_REQUEST);
        }
        this.event.user(userSession.getUser());
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User disabled", Response.Status.BAD_REQUEST);
        }
        OAuth2Code codeData = parseResult.getCodeData();
        String redirectUri = codeData.getRedirectUriParam();
        String redirectUriParam = (String)this.formParams.getFirst((Object)"redirect_uri");
        if (redirectUriParam != null && redirectUriParam.contains("session_state=") && !redirectUri.contains("session_state=")) {
            redirectUriParam = KeycloakUriBuilder.fromUri((String)redirectUriParam).replaceQueryParam("session_state", null).build(new Object[0]).toString();
        }
        if (redirectUri != null && !redirectUri.equals(redirectUriParam)) {
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Incorrect redirect_uri", Response.Status.BAD_REQUEST);
        }
        if (!this.client.getClientId().equals(clientSession.getClient().getClientId())) {
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Auth error", Response.Status.BAD_REQUEST);
        }
        if (!this.client.isStandardFlowEnabled()) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Client not allowed to exchange code", Response.Status.BAD_REQUEST);
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            this.event.error("user_session_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Session not active", Response.Status.BAD_REQUEST);
        }
        String codeVerifier = (String)this.formParams.getFirst((Object)"code_verifier");
        String codeChallenge = codeData.getCodeChallenge();
        String codeChallengeMethod = codeData.getCodeChallengeMethod();
        String authUserId = user.getId();
        String authUsername = user.getUsername();
        if (authUserId == null) {
            authUserId = "unknown";
        }
        if (authUsername == null) {
            authUsername = "unknown";
        }
        if (codeChallengeMethod != null && !codeChallengeMethod.isEmpty()) {
            this.checkParamsForPkceEnforcedClient(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername);
        } else {
            this.checkParamsForPkceNotEnforcedClient(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenRequestContext(this.formParams, parseResult));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, "invalid_grant", cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        this.updateClientSession(clientSession);
        this.updateUserSessionFromClientAuth(userSession);
        String scopeParam = codeData.getScope();
        Supplier<Stream> clientScopesSupplier = () -> TokenManager.getRequestedClientScopes(scopeParam, this.client);
        if (!TokenManager.verifyConsentStillAvailable(this.session, user, this.client, clientScopesSupplier.get())) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", "Client no longer has requested consent from user", Response.Status.BAD_REQUEST);
        }
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionAndClientScopes(clientSession, clientScopesSupplier.get(), this.session);
        clientSessionCtx.setAttribute("nonce", codeData.getNonce());
        return this.createTokenResponse(user, userSession, clientSessionCtx, scopeParam, true);
    }

    public Response createTokenResponse(UserModel user, UserSessionModel userSession, ClientSessionContext clientSessionCtx, String scopeParam, boolean code) {
        AccessToken token = this.tokenManager.createClientAccessToken(this.session, this.realm, this.client, user, userSession, clientSessionCtx);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSessionCtx).accessToken(token);
        if (OIDCAdvancedConfigWrapper.fromClientModel(this.client).isUseRefreshToken()) {
            responseBuilder.generateRefreshToken();
        }
        this.checkMtlsHoKToken(responseBuilder, OIDCAdvancedConfigWrapper.fromClientModel(this.client).isUseRefreshToken());
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        AccessTokenResponse res = null;
        if (code) {
            try {
                res = responseBuilder.build();
            }
            catch (RuntimeException re) {
                if ("can not get encryption KEK".equals(re.getMessage())) {
                    throw new CorsErrorResponseException(this.cors, "invalid_request", "can not get encryption KEK", Response.Status.BAD_REQUEST);
                }
                throw re;
            }
        } else {
            res = responseBuilder.build();
        }
        this.event.success();
        return this.cors.builder(Response.ok((Object)res).type(MediaType.APPLICATION_JSON_TYPE)).build();
    }

    private void checkMtlsHoKToken(TokenManager.AccessTokenResponseBuilder responseBuilder, boolean useRefreshToken) {
        if (OIDCAdvancedConfigWrapper.fromClientModel(this.client).isUseMtlsHokToken()) {
            AccessToken.CertConf certConf = MtlsHoKTokenUtil.bindTokenWithClientCertificate(this.request, this.session);
            if (certConf != null) {
                responseBuilder.getAccessToken().setCertConf(certConf);
                if (useRefreshToken) {
                    responseBuilder.getRefreshToken().setCertConf(certConf);
                }
            } else {
                this.event.error("invalid_request");
                throw new CorsErrorResponseException(this.cors, "invalid_request", "Client Certification missing for MTLS HoK Token Binding", Response.Status.BAD_REQUEST);
            }
        }
    }

    private void checkParamsForPkceEnforcedClient(String codeVerifier, String codeChallenge, String codeChallengeMethod, String authUserId, String authUsername) {
        if (codeVerifier == null) {
            logger.warnf("PKCE code verifier not specified, authUserId = %s, authUsername = %s", (Object)authUserId, (Object)authUsername);
            this.event.error("code_verifier_missing");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE code verifier not specified", Response.Status.BAD_REQUEST);
        }
        this.verifyCodeVerifier(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername);
    }

    private void checkParamsForPkceNotEnforcedClient(String codeVerifier, String codeChallenge, String codeChallengeMethod, String authUserId, String authUsername) {
        if (codeChallenge != null && codeVerifier == null) {
            logger.warnf("PKCE code verifier not specified, authUserId = %s, authUsername = %s", (Object)authUserId, (Object)authUsername);
            this.event.error("code_verifier_missing");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE code verifier not specified", Response.Status.BAD_REQUEST);
        }
        if (codeChallenge != null) {
            this.verifyCodeVerifier(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername);
        }
    }

    private void verifyCodeVerifier(String codeVerifier, String codeChallenge, String codeChallengeMethod, String authUserId, String authUsername) {
        if (!this.isValidPkceCodeVerifier(codeVerifier)) {
            logger.infof("PKCE invalid code verifier", new Object[0]);
            this.event.error("invalid_code_verifier");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE invalid code verifier", Response.Status.BAD_REQUEST);
        }
        logger.debugf("PKCE supporting Client, codeVerifier = %s", (Object)codeVerifier);
        String codeVerifierEncoded = codeVerifier;
        try {
            if (codeChallengeMethod != null && codeChallengeMethod.equals("S256")) {
                logger.debugf("PKCE codeChallengeMethod = %s", (Object)codeChallengeMethod);
                codeVerifierEncoded = PkceUtils.generateS256CodeChallenge(codeVerifier);
            } else {
                logger.debug((Object)"PKCE codeChallengeMethod is plain");
                codeVerifierEncoded = codeVerifier;
            }
        }
        catch (Exception nae) {
            logger.infof("PKCE code verification failed, not supported algorithm specified", new Object[0]);
            this.event.error("pkce_verification_failed");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE code verification failed, not supported algorithm specified", Response.Status.BAD_REQUEST);
        }
        if (!codeChallenge.equals(codeVerifierEncoded)) {
            logger.warnf("PKCE verification failed. authUserId = %s, authUsername = %s", (Object)authUserId, (Object)authUsername);
            this.event.error("pkce_verification_failed");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE verification failed", Response.Status.BAD_REQUEST);
        }
        logger.debugf("PKCE verification success. codeVerifierEncoded = %s, codeChallenge = %s", (Object)codeVerifierEncoded, (Object)codeChallenge);
    }

    public Response refreshTokenGrant() {
        AccessTokenResponse res;
        String refreshToken = (String)this.formParams.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "No refresh token", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenRefreshContext(this.formParams));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        try {
            TokenManager.RefreshResult result = this.tokenManager.refreshAccessToken(this.session, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.realm, this.client, refreshToken, this.event, this.headers, this.request);
            res = result.getResponse();
            if (!result.isOfflineToken()) {
                UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, res.getSessionState());
                AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(this.client.getId());
                this.updateClientSession(clientSession);
                this.updateUserSessionFromClientAuth(userSession);
            }
        }
        catch (OAuthErrorException e) {
            logger.trace((Object)e.getMessage(), (Throwable)e);
            if ("Client certificate missing, or its thumbprint and one in the refresh token did NOT match".equals(e.getDescription())) {
                this.event.error("not_allowed");
                throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.UNAUTHORIZED);
            }
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.BAD_REQUEST);
        }
        this.event.success();
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    private void updateClientSession(AuthenticatedClientSessionModel clientSession) {
        if (clientSession == null) {
            ServicesLogger.LOGGER.clientSessionNull();
            return;
        }
        String adapterSessionId = (String)this.formParams.getFirst((Object)"client_session_state");
        if (adapterSessionId != null) {
            String oldClientSessionHost;
            String adapterSessionHost = (String)this.formParams.getFirst((Object)"client_session_host");
            logger.debugf("Adapter Session '%s' saved in ClientSession for client '%s'. Host is '%s'", (Object)adapterSessionId, (Object)this.client.getClientId(), (Object)adapterSessionHost);
            String oldClientSessionState = clientSession.getNote("client_session_state");
            if (!adapterSessionId.equals(oldClientSessionState)) {
                clientSession.setNote("client_session_state", adapterSessionId);
            }
            if (!Objects.equals(adapterSessionHost, oldClientSessionHost = clientSession.getNote("client_session_host"))) {
                clientSession.setNote("client_session_host", adapterSessionHost);
            }
        }
    }

    private void updateUserSessionFromClientAuth(UserSessionModel userSession) {
        for (Map.Entry<String, String> attr : this.clientAuthAttributes.entrySet()) {
            userSession.setNote(attr.getKey(), attr.getValue());
        }
    }

    public Response resourceOwnerPasswordCredentialsGrant() {
        String scopeParam;
        this.event.detail("auth_method", "oauth_credentials");
        if (!this.client.isDirectAccessGrantsEnabled()) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Client not allowed for direct access grants", Response.Status.BAD_REQUEST);
        }
        if (this.client.isConsentRequired()) {
            this.event.error("consent_denied");
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Client requires user consent", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new ResourceOwnerPasswordCredentialsContext(this.formParams));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        String scope = this.getRequestedScopes();
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(this.client);
        authSession.setProtocol("openid-connect");
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        AuthenticationFlowModel flow = AuthenticationFlowResolver.resolveDirectGrantFlow((AuthenticationSessionModel)authSession);
        String flowId = flow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setAuthenticationSession(authSession).setFlowId(flowId).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri()).setRequest(this.request);
        Response challenge = processor.authenticateOnly();
        if (challenge != null) {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, false);
            this.cors.build(this.httpResponse);
            return challenge;
        }
        processor.evaluateRequiredActionTriggers();
        UserModel user = authSession.getAuthenticatedUser();
        if (user.getRequiredActionsStream().count() > 0L || authSession.getRequiredActions().size() > 0) {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, false);
            this.event.error("resolve_required_actions");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Account is not fully set up", Response.Status.BAD_REQUEST);
        }
        AuthenticationManager.setClientScopesInSession(authSession);
        ClientSessionContext clientSessionCtx = processor.attachSession();
        UserSessionModel userSession = processor.getUserSession();
        this.updateUserSessionFromClientAuth(userSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSessionCtx).generateAccessToken();
        if (OIDCAdvancedConfigWrapper.fromClientModel(this.client).isUseRefreshToken()) {
            responseBuilder.generateRefreshToken();
        }
        if (TokenUtil.isOIDCRequest((String)(scopeParam = clientSessionCtx.getClientSession().getNote("scope")))) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.success();
        AuthenticationManager.logSuccess(this.session, authSession);
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    public Response clientCredentialsGrant() {
        if (this.client.isBearerOnly()) {
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Bearer-only client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (this.client.isPublicClient()) {
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Public client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (!this.client.isServiceAccountsEnabled()) {
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Client not enabled to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        UserModel clientUser = this.session.users().getServiceAccount(this.client);
        if (clientUser == null || this.client.getProtocolMapperByName("openid-connect", "Client ID") == null) {
            logger.debugf("Service account user for client '%s' not found or default protocol mapper for service account not found. Creating now", (Object)this.client.getClientId());
            new ClientManager(new RealmManager(this.session)).enableServiceAccount(this.client);
            clientUser = this.session.users().getServiceAccount(this.client);
        }
        String clientUsername = clientUser.getUsername();
        this.event.detail("username", clientUsername);
        this.event.user(clientUser);
        if (!clientUser.isEnabled()) {
            this.event.error("user_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "User '" + clientUsername + "' disabled", Response.Status.UNAUTHORIZED);
        }
        String scope = this.getRequestedScopes();
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(this.client);
        authSession.setAuthenticatedUser(clientUser);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        UserSessionModel.SessionPersistenceState sessionPersistenceState = UserSessionModel.SessionPersistenceState.PERSISTENT;
        boolean useRefreshToken = OIDCAdvancedConfigWrapper.fromClientModel(this.client).isUseRefreshTokenForClientCredentialsGrant();
        if (!useRefreshToken) {
            sessionPersistenceState = UserSessionModel.SessionPersistenceState.TRANSIENT;
        }
        UserSessionModel userSession = this.session.sessions().createUserSession(authSession.getParentSession().getId(), this.realm, clientUser, clientUsername, this.clientConnection.getRemoteAddr(), "client_auth", false, null, null, sessionPersistenceState);
        this.event.session(userSession);
        AuthenticationManager.setClientScopesInSession(authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
        userSession.setNote("clientId", this.client.getClientId());
        userSession.setNote("clientHost", this.clientConnection.getRemoteHost());
        userSession.setNote("clientAddress", this.clientConnection.getRemoteAddr());
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new ServiceAccountTokenRequestContext(this.formParams, clientSessionCtx.getClientSession()));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        this.updateUserSessionFromClientAuth(userSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSessionCtx).generateAccessToken();
        if (useRefreshToken) {
            responseBuilder = responseBuilder.generateRefreshToken();
        } else {
            responseBuilder.getAccessToken().setSessionState(null);
        }
        this.checkMtlsHoKToken(responseBuilder, useRefreshToken);
        String scopeParam = clientSessionCtx.getClientSession().getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.success();
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    private String getRequestedScopes() {
        String scope = (String)this.formParams.getFirst((Object)"scope");
        if (!TokenManager.isValidScope(scope, this.client)) {
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", "Invalid scopes: " + scope, Response.Status.BAD_REQUEST);
        }
        return scope;
    }

    public Response tokenExchange() {
        ProfileHelper.requireFeature(Profile.Feature.TOKEN_EXCHANGE);
        this.event.detail("auth_method", "token_exchange");
        this.event.client(this.client);
        TokenExchangeContext context = new TokenExchangeContext(this.session, this.formParams, (Object)this.cors, this.realm, this.event, this.client, this.clientConnection, this.headers, (Object)this.tokenManager, this.clientAuthAttributes);
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(TokenExchangeProvider.class).sorted((f1, f2) -> f2.order() - f1.order()).map(f -> (TokenExchangeProvider)this.session.getProvider(TokenExchangeProvider.class, f.getId())).filter(p -> p.supports(context)).findFirst().orElseThrow(() -> new InternalServerErrorException("No token exchange provider available")).exchange(context);
    }

    public Response permissionGrant() {
        String responsePermissionsLimit;
        this.event.detail("auth_method", "oauth_credentials");
        String accessTokenString = null;
        String authorizationHeader = (String)this.headers.getRequestHeaders().getFirst((Object)"Authorization");
        if (authorizationHeader != null && authorizationHeader.toLowerCase().startsWith("bearer")) {
            new AppAuthManager();
            accessTokenString = AppAuthManager.extractAuthorizationHeaderToken(this.headers);
        }
        if (accessTokenString != null) {
            AccessToken accessToken = Tokens.getAccessToken(this.session);
            if (accessToken == null) {
                try {
                    AccessToken invalidToken = (AccessToken)new JWSInput(accessTokenString).readJsonContent(AccessToken.class);
                    ClientModel client = this.realm.getClientByClientId(invalidToken.getIssuedFor());
                    this.cors.allowedOrigins(this.session, client);
                    this.event.client(client);
                }
                catch (JWSInputException invalidToken) {
                    // empty catch block
                }
                this.event.error("invalid_token");
                throw new CorsErrorResponseException(this.cors, "invalid_grant", "Invalid bearer token", Response.Status.UNAUTHORIZED);
            }
            ClientModel client = this.realm.getClientByClientId(accessToken.getIssuedFor());
            this.session.getContext().setClient(client);
            this.cors.allowedOrigins(this.session, client);
            this.event.client(client);
        }
        String claimToken = null;
        if (this.formParams.containsKey((Object)"claim_token")) {
            claimToken = (String)((List)this.formParams.get((Object)"claim_token")).get(0);
        }
        String claimTokenFormat = (String)this.formParams.getFirst((Object)"claim_token_format");
        if (claimToken != null && claimTokenFormat == null) {
            claimTokenFormat = "http://openid.net/specs/openid-connect-core-1_0.html#IDToken";
        }
        String subjectToken = (String)this.formParams.getFirst((Object)"subject_token");
        if (accessTokenString == null) {
            this.checkClient();
            accessTokenString = "http://openid.net/specs/openid-connect-core-1_0.html#IDToken".equalsIgnoreCase(claimTokenFormat) ? claimToken : (subjectToken != null ? subjectToken : ((AccessTokenResponse)AccessTokenResponse.class.cast(this.clientCredentialsGrant().getEntity())).getToken());
        }
        AuthorizationTokenService.KeycloakAuthorizationRequest authorizationRequest = new AuthorizationTokenService.KeycloakAuthorizationRequest((AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class), this.tokenManager, this.event, this.request, this.cors, this.clientConnection);
        authorizationRequest.setTicket((String)this.formParams.getFirst((Object)"ticket"));
        authorizationRequest.setClaimToken(claimToken);
        authorizationRequest.setClaimTokenFormat(claimTokenFormat);
        authorizationRequest.setPct((String)this.formParams.getFirst((Object)"pct"));
        String rpt = (String)this.formParams.getFirst((Object)"rpt");
        if (rpt != null) {
            AccessToken accessToken = (AccessToken)this.session.tokens().decode(rpt, AccessToken.class);
            if (accessToken == null) {
                this.event.error("invalid_request");
                throw new CorsErrorResponseException(this.cors, "invalid_rpt", "RPT signature is invalid", Response.Status.FORBIDDEN);
            }
            authorizationRequest.setRpt(accessToken);
        }
        authorizationRequest.setScope((String)this.formParams.getFirst((Object)"scope"));
        String audienceParam = (String)this.formParams.getFirst((Object)"audience");
        authorizationRequest.setAudience(audienceParam);
        authorizationRequest.setSubjectToken(accessTokenString);
        this.event.detail("audience", audienceParam);
        String submitRequest = (String)this.formParams.getFirst((Object)"submit_request");
        authorizationRequest.setSubmitRequest(submitRequest == null ? true : Boolean.valueOf(submitRequest));
        List permissions = (List)this.formParams.get((Object)"permission");
        if (permissions != null) {
            this.event.detail("permission", String.join((CharSequence)"|", permissions));
            for (String permission : permissions) {
                String[] parts = permission.split("#");
                String resource = parts[0];
                if (parts.length == 1) {
                    authorizationRequest.addPermission(resource, new String[0]);
                    continue;
                }
                String[] scopes = parts[1].split(",");
                authorizationRequest.addPermission(parts[0], scopes);
            }
        }
        AuthorizationRequest.Metadata metadata = new AuthorizationRequest.Metadata();
        String responseIncludeResourceName = (String)this.formParams.getFirst((Object)"response_include_resource_name");
        if (responseIncludeResourceName != null) {
            metadata.setIncludeResourceName(Boolean.valueOf(Boolean.parseBoolean(responseIncludeResourceName)));
        }
        if ((responsePermissionsLimit = (String)this.formParams.getFirst((Object)"response_permissions_limit")) != null) {
            metadata.setLimit(Integer.valueOf(Integer.parseInt(responsePermissionsLimit)));
        }
        metadata.setResponseMode((String)this.formParams.getFirst((Object)"response_mode"));
        authorizationRequest.setMetadata(metadata);
        Response authorizationResponse = AuthorizationTokenService.instance().authorize(authorizationRequest);
        this.event.success();
        return authorizationResponse;
    }

    public Response oauth2DeviceCodeToToken() {
        DeviceGrantType deviceGrantType = new DeviceGrantType(this.formParams, this.client, this.session, this, this.realm, this.event, this.cors);
        return deviceGrantType.oauth2DeviceFlow();
    }

    public Response cibaGrant() {
        CibaGrantType grantType = new CibaGrantType(this.formParams, this.client, this.session, this, this.realm, this.event, this.cors);
        return grantType.cibaGrant();
    }

    private boolean isValidPkceCodeVerifier(String codeVerifier) {
        if (codeVerifier.length() < 43) {
            logger.infof(" Error: PKCE codeVerifier length under lower limit , codeVerifier = %s", (Object)codeVerifier);
            return false;
        }
        if (codeVerifier.length() > 128) {
            logger.infof(" Error: PKCE codeVerifier length over upper limit , codeVerifier = %s", (Object)codeVerifier);
            return false;
        }
        Matcher m = VALID_CODE_VERIFIER_PATTERN.matcher(codeVerifier);
        return m.matches();
    }

    public static class TokenExchangeSamlProtocol
    extends SamlProtocol {
        final SamlClient samlClient;

        public TokenExchangeSamlProtocol(SamlClient samlClient) {
            this.samlClient = samlClient;
        }

        @Override
        protected Response buildAuthenticatedResponse(AuthenticatedClientSessionModel clientSession, String redirectUri, Document samlDocument, JaxrsSAML2BindingBuilder bindingBuilder) throws ConfigurationException, ProcessingException, IOException {
            JaxrsSAML2BindingBuilder.PostBindingBuilder builder = bindingBuilder.postBinding(samlDocument);
            Element assertionElement = this.samlClient.requiresEncryption() ? DocumentUtil.getElement((Document)builder.getDocument(), (QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ENCRYPTED_ASSERTION.get())) : DocumentUtil.getElement((Document)builder.getDocument(), (QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()));
            if (assertionElement == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String assertion = DocumentUtil.getNodeAsString((Node)assertionElement);
            return Response.ok((Object)assertion, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }

        @Override
        protected Response buildErrorResponse(boolean isPostBinding, String destination, JaxrsSAML2BindingBuilder binding, Document document) throws ConfigurationException, ProcessingException, IOException {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    private static enum Action {
        AUTHORIZATION_CODE,
        REFRESH_TOKEN,
        PASSWORD,
        CLIENT_CREDENTIALS,
        TOKEN_EXCHANGE,
        PERMISSION,
        OAUTH2_DEVICE_CODE,
        CIBA;

    }
}

