/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.net.URI;
import org.keycloak.models.RealmModel;
import org.keycloak.services.Urls;
import org.keycloak.theme.Theme;

public class UrlBean {
    private String realm;
    private Theme theme;
    private URI baseURI;
    private URI baseQueryURI;
    private URI currentURI;

    public UrlBean(RealmModel realm, Theme theme, URI baseURI, URI baseQueryURI, URI currentURI, String stateChecker) {
        this.realm = realm.getName();
        this.theme = theme;
        this.baseURI = baseURI;
        this.baseQueryURI = baseQueryURI;
        this.currentURI = currentURI;
    }

    public String getApplicationsUrl() {
        return Urls.accountApplicationsPage(this.baseQueryURI, this.realm).toString();
    }

    public String getAccountUrl() {
        return Urls.accountPage(this.baseQueryURI, this.realm).toString();
    }

    public String getPasswordUrl() {
        return Urls.accountPasswordPage(this.baseQueryURI, this.realm).toString();
    }

    public String getSocialUrl() {
        return Urls.accountFederatedIdentityPage(this.baseQueryURI, this.realm).toString();
    }

    public String getTotpUrl() {
        return Urls.accountTotpPage(this.baseQueryURI, this.realm).toString();
    }

    public String getLogUrl() {
        return Urls.accountLogPage(this.baseQueryURI, this.realm).toString();
    }

    public String getSessionsUrl() {
        return Urls.accountSessionsPage(this.baseQueryURI, this.realm).toString();
    }

    public String getLogoutUrl() {
        return Urls.accountLogout(this.baseQueryURI, this.currentURI, this.realm).toString();
    }

    public String getResourceUrl() {
        return Urls.accountResourcesPage(this.baseQueryURI, this.realm).toString();
    }

    public String getResourceDetailUrl(String id) {
        return Urls.accountResourceDetailPage(id, this.baseQueryURI, this.realm).toString();
    }

    public String getResourceGrant(String id) {
        return Urls.accountResourceGrant(id, this.baseQueryURI, this.realm).toString();
    }

    public String getResourceShare(String id) {
        return Urls.accountResourceShare(id, this.baseQueryURI, this.realm).toString();
    }

    public String getResourcesPath() {
        URI uri = Urls.themeRoot(this.baseURI);
        return uri.getPath() + "/" + this.theme.getType().toString().toLowerCase() + "/" + this.theme.getName();
    }

    public String getResourcesCommonPath() {
        URI uri = Urls.themeRoot(this.baseURI);
        return uri.getPath() + "/common/keycloak";
    }
}

