/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.keys.AbstractRsaKeyProvider;
import org.keycloak.keys.JavaKeystoreKeyProviderFactory;
import org.keycloak.models.RealmModel;

public class JavaKeystoreKeyProvider
extends AbstractRsaKeyProvider {
    private static final Logger logger = Logger.getLogger(JavaKeystoreKeyProvider.class);

    public JavaKeystoreKeyProvider(RealmModel realm, ComponentModel model) {
        super(realm, model);
    }

    @Override
    protected AbstractRsaKeyProvider.Keys loadKeys(RealmModel realm, ComponentModel model) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(model.get(JavaKeystoreKeyProviderFactory.KEYSTORE_KEY)), model.get(JavaKeystoreKeyProviderFactory.KEYSTORE_PASSWORD_KEY).toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(model.get(JavaKeystoreKeyProviderFactory.KEY_ALIAS_KEY), model.get(JavaKeystoreKeyProviderFactory.KEY_PASSWORD_KEY).toCharArray());
            PublicKey publicKey = KeyUtils.extractPublicKey((PrivateKey)privateKey);
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            X509Certificate certificate = (X509Certificate)keyStore.getCertificate(model.get(JavaKeystoreKeyProviderFactory.KEY_ALIAS_KEY));
            if (certificate == null) {
                certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)realm.getName());
            }
            String kid = KeyUtils.createKeyId((Key)keyPair.getPublic());
            return new AbstractRsaKeyProvider.Keys(kid, keyPair, certificate);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load keys", e);
        }
    }
}

