/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScriptModel;
import org.keycloak.models.UserModel;
import org.keycloak.scripting.InvocableScriptAdapter;
import org.keycloak.scripting.ScriptExecutionException;
import org.keycloak.scripting.ScriptingProvider;

public class ScriptBasedAuthenticator
implements Authenticator {
    private static final Logger LOGGER = Logger.getLogger(ScriptBasedAuthenticator.class);
    static final String SCRIPT_CODE = "scriptCode";
    static final String SCRIPT_NAME = "scriptName";
    static final String SCRIPT_DESCRIPTION = "scriptDescription";
    static final String ACTION_FUNCTION_NAME = "action";
    static final String AUTHENTICATE_FUNCTION_NAME = "authenticate";

    public void authenticate(AuthenticationFlowContext context) {
        this.tryInvoke(AUTHENTICATE_FUNCTION_NAME, context);
    }

    public void action(AuthenticationFlowContext context) {
        this.tryInvoke(ACTION_FUNCTION_NAME, context);
    }

    private void tryInvoke(String functionName, AuthenticationFlowContext context) {
        if (!this.hasAuthenticatorConfig(context)) {
            context.success();
            return;
        }
        InvocableScriptAdapter invocableScriptAdapter = this.getInvocableScriptAdapter(context);
        if (!invocableScriptAdapter.isDefined(functionName)) {
            return;
        }
        try {
            invocableScriptAdapter.invokeFunction(functionName, new Object[]{context});
        }
        catch (ScriptExecutionException e) {
            LOGGER.error((Object)e);
            context.failure(AuthenticationFlowError.INTERNAL_ERROR);
        }
    }

    private boolean hasAuthenticatorConfig(AuthenticationFlowContext context) {
        return context != null && context.getAuthenticatorConfig() != null && context.getAuthenticatorConfig().getConfig() != null && !context.getAuthenticatorConfig().getConfig().isEmpty();
    }

    private InvocableScriptAdapter getInvocableScriptAdapter(AuthenticationFlowContext context) {
        Map config = context.getAuthenticatorConfig().getConfig();
        String scriptName = (String)config.get(SCRIPT_NAME);
        String scriptCode = (String)config.get(SCRIPT_CODE);
        String scriptDescription = (String)config.get(SCRIPT_DESCRIPTION);
        RealmModel realm = context.getRealm();
        ScriptingProvider scripting = (ScriptingProvider)context.getSession().getProvider(ScriptingProvider.class);
        ScriptModel script = scripting.createScript(realm.getId(), "text/javascript", scriptName, scriptCode, scriptDescription);
        return scripting.prepareInvocableScript(script, bindings -> {
            bindings.put("script", (Object)script);
            bindings.put("realm", (Object)context.getRealm());
            bindings.put("user", (Object)context.getUser());
            bindings.put("session", (Object)context.getSession());
            bindings.put("httpRequest", (Object)context.getHttpRequest());
            bindings.put("LOG", (Object)LOGGER);
        });
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

