/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.idpverifyemail;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.idpverifyemail.IdpVerifyAccountLinkActionToken;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionModel;

public class IdpVerifyAccountLinkActionTokenHandler
extends AbstractActionTokenHandler<IdpVerifyAccountLinkActionToken> {
    public IdpVerifyAccountLinkActionTokenHandler() {
        super("idp-verify-account-via-email", IdpVerifyAccountLinkActionToken.class, "staleCodeMessage", EventType.IDENTITY_PROVIDER_LINK_ACCOUNT, "invalid_token");
    }

    @Override
    public TokenVerifier.Predicate<? super IdpVerifyAccountLinkActionToken>[] getVerifiers(ActionTokenContext<IdpVerifyAccountLinkActionToken> tokenContext) {
        return TokenUtils.predicates(this.verifyEmail(tokenContext));
    }

    @Override
    public Response handleToken(IdpVerifyAccountLinkActionToken token, ActionTokenContext<IdpVerifyAccountLinkActionToken> tokenContext) {
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        EventBuilder event = tokenContext.getEvent();
        UriInfo uriInfo = tokenContext.getUriInfo();
        RealmModel realm = tokenContext.getRealm();
        KeycloakSession session = tokenContext.getSession();
        event.event(EventType.IDENTITY_PROVIDER_LINK_ACCOUNT).detail("email", user.getEmail()).detail("identity_provider", token.getIdentityProviderAlias()).detail("identity_provider_identity", token.getIdentityProviderUsername()).success();
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        if (tokenContext.isAuthenticationSessionFresh()) {
            token.setOriginalCompoundAuthenticationSessionId(token.getCompoundAuthenticationSessionId());
            String authSessionEncodedId = AuthenticationSessionCompoundId.fromAuthSession((AuthenticationSessionModel)authSession).getEncodedId();
            token.setCompoundAuthenticationSessionId(authSessionEncodedId);
            UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, uriInfo), authSession.getClient().getClientId(), authSession.getTabId());
            String confirmUri = builder.build(new Object[]{realm.getName()}).toString();
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("confirmAccountLinking", new Object[]{token.getIdentityProviderUsername(), token.getIdentityProviderAlias()}).setAttribute("actionUri", (Object)confirmUri).createInfoPage();
        }
        user.setEmailVerified(true);
        if (token.getOriginalCompoundAuthenticationSessionId() != null) {
            AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
            asm.removeAuthenticationSession(realm, authSession, true);
            AuthenticationSessionCompoundId compoundId = AuthenticationSessionCompoundId.encoded((String)token.getOriginalCompoundAuthenticationSessionId());
            ClientModel originalClient = realm.getClientById(compoundId.getClientUUID());
            authSession = asm.getAuthenticationSessionByIdAndClient(realm, compoundId.getRootSessionId(), originalClient, compoundId.getTabId());
            if (authSession != null) {
                authSession.setAuthNote("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername());
            } else {
                session.authenticationSessions().updateNonlocalSessionAuthNotes(compoundId, Collections.singletonMap("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername()));
            }
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("identityProviderLinkSuccess", new Object[]{token.getIdentityProviderAlias(), token.getIdentityProviderUsername()}).setAttribute("skipLink", (Object)true).createInfoPage();
        }
        authSession.setAuthNote("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername());
        return tokenContext.brokerFlow(null, null, authSession.getAuthNote("current.flow.path"));
    }
}

