/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml.mappers;

import org.jboss.logging.Logger;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class AbstractAttributeToGroupMapper
extends AbstractIdentityProviderMapper {
    private static final Logger LOG = Logger.getLogger(AbstractAttributeToGroupMapper.class);

    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        GroupModel group = this.getGroup(realm, mapperModel);
        if (group == null) {
            return;
        }
        if (this.applies(mapperModel, context)) {
            user.joinGroup(group);
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        GroupModel group = this.getGroup(realm, mapperModel);
        if (group == null) {
            return;
        }
        String groupId = group.getId();
        if (!context.hasMapperAssignedGroup(groupId)) {
            if (this.applies(mapperModel, context)) {
                context.addMapperAssignedGroup(groupId);
                user.joinGroup(group);
            } else {
                user.leaveGroup(group);
            }
        }
    }

    protected abstract boolean applies(IdentityProviderMapperModel var1, BrokeredIdentityContext var2);

    private GroupModel getGroup(RealmModel realm, IdentityProviderMapperModel mapperModel) {
        String groupPath = (String)mapperModel.getConfig().get("group");
        GroupModel group = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)groupPath);
        if (group == null) {
            LOG.warnf("Unable to find group by path '%s' referenced by mapper '%s' on realm '%s'.", (Object)groupPath, (Object)mapperModel.getName(), (Object)realm.getName());
        }
        return group;
    }
}

