/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.policy.PasswordPolicyNotMetException;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.UserProfileResource;
import org.keycloak.services.resources.admin.UserResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.UserPermissionEvaluator;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.utils.SearchQueryUtils;

@Extension(name="x-smallrye-profile-admin", value="")
public class UsersResource {
    private static final Logger logger = Logger.getLogger(UsersResource.class);
    private static final String SEARCH_ID_PARAMETER = "id:";
    protected final RealmModel realm;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    protected final ClientConnection clientConnection;
    protected final KeycloakSession session;
    protected final HttpHeaders headers;

    public UsersResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.adminEvent = adminEvent.resource(ResourceType.USER);
        this.headers = session.getContext().getRequestHeaders();
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Create a new user Username must be unique.")
    public Response createUser(UserRepresentation rep) {
        block18: {
            try {
                this.auth.users().requireManage();
            }
            catch (ForbiddenException exception) {
                if (this.canCreateGroupMembers(rep)) break block18;
                throw exception;
            }
        }
        String username = rep.getUsername();
        if (this.realm.isRegistrationEmailAsUsername()) {
            username = rep.getEmail();
        }
        if (ObjectUtil.isBlank((CharSequence)username)) {
            throw ErrorResponse.error("User name is missing", Response.Status.BAD_REQUEST);
        }
        if (this.session.users().getUserByUsername(this.realm, username) != null) {
            throw ErrorResponse.exists("User exists with same username");
        }
        if (rep.getEmail() != null && !this.realm.isDuplicateEmailsAllowed()) {
            try {
                if (this.session.users().getUserByEmail(this.realm, rep.getEmail()) != null) {
                    throw ErrorResponse.exists("User exists with same email");
                }
            }
            catch (ModelDuplicateException e) {
                throw ErrorResponse.exists("User exists with same email");
            }
        }
        UserProfileProvider profileProvider = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        UserProfile profile = profileProvider.create(UserProfileContext.USER_API, rep.toAttributes());
        try {
            Response response = UserResource.validateUserProfile(profile, this.session, this.auth.adminAuth());
            if (response != null) {
                return response;
            }
            UserModel user = profile.create();
            UserResource.updateUserFromRep(profile, user, rep, this.session, false);
            RepresentationToModel.createFederatedIdentities((UserRepresentation)rep, (KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user);
            RepresentationToModel.createGroups((KeycloakSession)this.session, (UserRepresentation)rep, (RealmModel)this.realm, (UserModel)user);
            RepresentationToModel.createCredentials((UserRepresentation)rep, (KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user, (boolean)true);
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), user.getId()).representation(rep).success();
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(user.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            throw ErrorResponse.exists("User exists with same username or email");
        }
        catch (PasswordPolicyNotMetException e) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            throw ErrorResponse.error("Password policy not met", Response.Status.BAD_REQUEST);
        }
        catch (ModelException me) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            logger.warn((Object)"Could not create user", (Throwable)me);
            throw ErrorResponse.error("Could not create user", Response.Status.BAD_REQUEST);
        }
    }

    private boolean canCreateGroupMembers(UserRepresentation rep) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)) {
            return false;
        }
        List groups = Optional.ofNullable(rep.getGroups()).orElse(Collections.emptyList()).stream().map(path -> KeycloakModelUtils.findGroupByPath((KeycloakSession)this.session, (RealmModel)this.realm, (String)path)).filter(Objects::nonNull).collect(Collectors.toList());
        if (groups.isEmpty()) {
            return false;
        }
        for (GroupModel group : groups) {
            this.auth.groups().requireManageMembers(group);
            this.auth.groups().requireManageMembership(group);
        }
        return true;
    }

    @Path(value="{id}")
    public UserResource user(@PathParam(value="id") String id) {
        UserModel user = null;
        if (LightweightUserAdapter.isLightweightUser((String)id)) {
            UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, LightweightUserAdapter.getLightweightUserId((String)id));
            if (userSession != null) {
                user = userSession.getUser();
            }
        } else {
            user = this.session.users().getUserById(this.realm, id);
        }
        if (user == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("User not found");
            }
            throw new ForbiddenException();
        }
        return new UserResource(this.session, user, this.auth, this.adminEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Get users Returns a stream of users, filtered according to query parameters.")
    public Stream<UserRepresentation> getUsers(@Parameter(description="A String contained in username, first or last name, or email. Default search behavior is prefix-based (e.g., foo or foo*). Use *foo* for infix search and \"foo\" for exact search.") @QueryParam(value="search") String search, @Parameter(description="A String contained in lastName, or the complete lastName, if param \"exact\" is true") @QueryParam(value="lastName") String last, @Parameter(description="A String contained in firstName, or the complete firstName, if param \"exact\" is true") @QueryParam(value="firstName") String first, @Parameter(description="A String contained in email, or the complete email, if param \"exact\" is true") @QueryParam(value="email") String email, @Parameter(description="A String contained in username, or the complete username, if param \"exact\" is true") @QueryParam(value="username") String username, @Parameter(description="whether the email has been verified") @QueryParam(value="emailVerified") Boolean emailVerified, @Parameter(description="The alias of an Identity Provider linked to the user") @QueryParam(value="idpAlias") String idpAlias, @Parameter(description="The userId at an Identity Provider linked to the user") @QueryParam(value="idpUserId") String idpUserId, @Parameter(description="Pagination offset") @QueryParam(value="first") Integer firstResult, @Parameter(description="Maximum results size (defaults to 100)") @QueryParam(value="max") Integer maxResults, @Parameter(description="Boolean representing if user is enabled or not") @QueryParam(value="enabled") Boolean enabled, @Parameter(description="Boolean which defines whether brief representations are returned (default: false)") @QueryParam(value="briefRepresentation") Boolean briefRepresentation, @Parameter(description="Boolean which defines whether the params \"last\", \"first\", \"email\" and \"username\" must match exactly") @QueryParam(value="exact") Boolean exact, @Parameter(description="A query to search for custom attributes, in the format 'key1:value2 key2:value2'") @QueryParam(value="q") String searchQuery) {
        UserPermissionEvaluator userPermissionEvaluator = this.auth.users();
        userPermissionEvaluator.requireQuery();
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : 100;
        Map<Object, Object> searchAttributes = searchQuery == null ? Collections.emptyMap() : SearchQueryUtils.getFields(searchQuery);
        Stream<UserModel> userModels = Stream.empty();
        if (search != null) {
            if (search.startsWith(SEARCH_ID_PARAMETER)) {
                UserModel userModel = this.session.users().getUserById(this.realm, search.substring(SEARCH_ID_PARAMETER.length()).trim());
                if (userModel == null) return this.toRepresentation(this.realm, userPermissionEvaluator, briefRepresentation, userModels);
                userModels = Stream.of(userModel);
                return this.toRepresentation(this.realm, userPermissionEvaluator, briefRepresentation, userModels);
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("keycloak.session.realm.users.query.search", search.trim());
            if (enabled == null) return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
            attributes.put("enabled", enabled.toString());
            return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
        }
        if (last == null && first == null && email == null && username == null && emailVerified == null && idpAlias == null && idpUserId == null && enabled == null && exact == null) {
            if (searchAttributes.isEmpty()) return this.searchForUser(new HashMap<String, String>(), this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (last != null) {
            attributes.put("lastName", last);
        }
        if (first != null) {
            attributes.put("firstName", first);
        }
        if (email != null) {
            attributes.put("email", email);
        }
        if (username != null) {
            attributes.put("username", username);
        }
        if (emailVerified != null) {
            attributes.put("emailVerified", emailVerified.toString());
        }
        if (idpAlias != null) {
            attributes.put("keycloak.session.realm.users.query.idp_alias", idpAlias);
        }
        if (idpUserId != null) {
            attributes.put("keycloak.session.realm.users.query.idp_user_id", idpUserId);
        }
        if (enabled != null) {
            attributes.put("enabled", enabled.toString());
        }
        if (exact != null) {
            attributes.put("keycloak.session.realm.users.query.exact", exact.toString());
        }
        attributes.putAll(searchAttributes);
        return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, true);
    }

    @Path(value="count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(summary="Returns the number of users that match the given criteria.", description="It can be called in three different ways. 1. Don\u2019t specify any criteria and pass {@code null}. The number of all users within that realm will be returned. <p> 2. If {@code search} is specified other criteria such as {@code last} will be ignored even though you set them. The {@code search} string will be matched against the first and last name, the username and the email of a user. <p> 3. If {@code search} is unspecified but any of {@code last}, {@code first}, {@code email} or {@code username} those criteria are matched against their respective fields on a user entity. Combined with a logical and.")
    public Integer getUsersCount(@Parameter(description="arbitrary search string for all the fields below. Default search behavior is prefix-based (e.g., foo or foo*). Use *foo* for infix search and \"foo\" for exact search.") @QueryParam(value="search") String search, @Parameter(description="last name filter") @QueryParam(value="lastName") String last, @Parameter(description="first name filter") @QueryParam(value="firstName") String first, @Parameter(description="email filter") @QueryParam(value="email") String email, @QueryParam(value="emailVerified") Boolean emailVerified, @Parameter(description="username filter") @QueryParam(value="username") String username, @Parameter(description="Boolean representing if user is enabled or not") @QueryParam(value="enabled") Boolean enabled, @QueryParam(value="q") String searchQuery) {
        Map<Object, Object> searchAttributes;
        UserPermissionEvaluator userPermissionEvaluator = this.auth.users();
        userPermissionEvaluator.requireQuery();
        Map<Object, Object> map = searchAttributes = searchQuery == null ? Collections.emptyMap() : SearchQueryUtils.getFields(searchQuery);
        if (search != null) {
            if (search.startsWith(SEARCH_ID_PARAMETER)) {
                UserModel userModel = this.session.users().getUserById(this.realm, search.substring(SEARCH_ID_PARAMETER.length()).trim());
                return userModel != null && userPermissionEvaluator.canView(userModel) ? 1 : 0;
            }
            if (userPermissionEvaluator.canView()) {
                return this.session.users().getUsersCount(this.realm, search.trim());
            }
            return this.session.users().getUsersCount(this.realm, search.trim(), this.auth.groups().getGroupsWithViewPermission());
        }
        if (last != null || first != null || email != null || username != null || emailVerified != null || enabled != null || !searchAttributes.isEmpty()) {
            HashMap<Object, Object> parameters = new HashMap<Object, Object>();
            if (last != null) {
                parameters.put("lastName", last);
            }
            if (first != null) {
                parameters.put("firstName", first);
            }
            if (email != null) {
                parameters.put("email", email);
            }
            if (username != null) {
                parameters.put("username", username);
            }
            if (emailVerified != null) {
                parameters.put("emailVerified", emailVerified.toString());
            }
            if (enabled != null) {
                parameters.put("enabled", enabled.toString());
            }
            parameters.putAll(searchAttributes);
            if (userPermissionEvaluator.canView()) {
                return this.session.users().getUsersCount(this.realm, parameters);
            }
            return this.session.users().getUsersCount(this.realm, parameters, this.auth.groups().getGroupsWithViewPermission());
        }
        if (userPermissionEvaluator.canView()) {
            return this.session.users().getUsersCount(this.realm);
        }
        return this.session.users().getUsersCount(this.realm, this.auth.groups().getGroupsWithViewPermission());
    }

    @Path(value="profile")
    public UserProfileResource userProfile() {
        return new UserProfileResource(this.session, this.auth);
    }

    private Stream<UserRepresentation> searchForUser(Map<String, String> attributes, RealmModel realm, UserPermissionEvaluator usersEvaluator, Boolean briefRepresentation, Integer firstResult, Integer maxResults, Boolean includeServiceAccounts) {
        Set<String> groupModels;
        attributes.put("keycloak.session.realm.users.query.include_service_account", includeServiceAccounts.toString());
        if (!this.auth.users().canView() && !(groupModels = this.auth.groups().getGroupsWithViewPermission()).isEmpty()) {
            this.session.setAttribute("keycloak.session.realm.users.query.groups", groupModels);
        }
        Stream userModels = this.session.users().searchForUserStream(realm, attributes, firstResult, maxResults);
        return this.toRepresentation(realm, usersEvaluator, briefRepresentation, userModels);
    }

    private Stream<UserRepresentation> toRepresentation(RealmModel realm, UserPermissionEvaluator usersEvaluator, Boolean briefRepresentation, Stream<UserModel> userModels) {
        boolean briefRepresentationB = briefRepresentation != null && briefRepresentation != false;
        boolean canViewGlobal = usersEvaluator.canView();
        usersEvaluator.grantIfNoPermission(this.session.getAttribute("keycloak.session.realm.users.query.groups") != null);
        return userModels.filter(user -> canViewGlobal || usersEvaluator.canView((UserModel)user)).map(user -> {
            UserRepresentation userRep = briefRepresentationB ? ModelToRepresentation.toBriefRepresentation((UserModel)user) : ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)realm, (UserModel)user);
            userRep.setAccess(usersEvaluator.getAccess((UserModel)user));
            return userRep;
        });
    }
}

